<?php
    require'include/cabeza.php';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Super Admin Dashboard | HealthBüro</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Candara:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <!-- [favicon] begin -->
    <link rel="shortcut icon" type="image/x-icon" href="https://sylvianettebox.net/favicon.ico" />
    <link rel="icon" type="image/x-icon" href="https://sylvianettebox.net/favicon.ico" />
    <!-- [favicon] end -->
    <link rel="stylesheet" href="assets/css/core.css" type="text/css"/>
</head>
<body>
    <div class="dashboard-container">
        <?php 
            $page = 'Dashboard';
            include 'include/sidebar.php'
        ?>
        
        <!-- Main Content -->
        <div class="main-content">
            <div class="content-wrapper">
                <? include 'include/topbar.php' ?>
                <!-- Messages -->
                <div class="message success">
                    <i class="fas fa-check-circle"></i>
                    <div class="message-content">System updated successfully. All modules are running optimally.</div>
                    <button class="close-message">
                        <i class="fas fa-times"></i>
                    </button>
                </div>
                
                <div class="message error">
                    <i class="fas fa-exclamation-circle"></i>
                    <div class="message-content">Pharmacy stock critical: 3 medications need immediate attention.</div>
                    <button class="close-message">
                        <i class="fas fa-times"></i>
                    </button>
                </div>
                
                <!-- Stats Grid -->
                <div class="stats-grid">
                    <div class="stat-card appointments">
                        <div class="stat-header">
                            <div class="stat-title">Appointments Today</div>
                            <div class="stat-icon appointments">
                                <i class="fas fa-calendar-check"></i>
                            </div>
                        </div>
                        <div class="stat-value">142</div>
                        <div class="stat-change positive">
                            <i class="fas fa-arrow-up"></i>
                            12% increase
                        </div>
                    </div>
                    
                    <div class="stat-card patients">
                        <div class="stat-header">
                            <div class="stat-title">Active Patients</div>
                            <div class="stat-icon patients">
                                <i class="fas fa-user-injured"></i>
                            </div>
                        </div>
                        <div class="stat-value">2,842</div>
                        <div class="stat-change positive">
                            <i class="fas fa-arrow-up"></i>
                            5% increase
                        </div>
                    </div>
                    
                    <div class="stat-card revenue">
                        <div class="stat-header">
                            <div class="stat-title">Revenue Today</div>
                            <div class="stat-icon revenue">
                                <i class="fas fa-dollar-sign"></i>
                            </div>
                        </div>
                        <div class="stat-value">$24,568</div>
                        <div class="stat-change positive">
                            <i class="fas fa-arrow-up"></i>
                            8% increase
                        </div>
                    </div>
                    
                    <div class="stat-card queues">
                        <div class="stat-header">
                            <div class="stat-title">Current Queues</div>
                            <div class="stat-icon queues">
                                <i class="fas fa-list-ol"></i>
                            </div>
                        </div>
                        <div class="stat-value">8</div>
                        <div class="stat-change negative">
                            <i class="fas fa-arrow-down"></i>
                            3% decrease
                        </div>
                    </div>
                </div>
                
                <!-- Charts Section -->
                <div class="charts-section">
                    <div class="chart-container">
                        <div class="chart-header">
                            <div class="chart-title">Appointments Overview</div>
                            <div class="chart-actions">
                                <button class="active">Today</button>
                                <button>Week</button>
                                <button>Month</button>
                            </div>
                        </div>
                        <div class="chart-wrapper">
                            <canvas id="appointmentsChart"></canvas>
                        </div>
                    </div>
                    
                    <div class="activity-container">
                        <div class="chart-header">
                            <div class="chart-title">Recent Activity</div>
                            <div class="chart-actions">
                                <button>View All</button>
                            </div>
                        </div>
                        <div class="activity-list">
                            <div class="activity-item">
                                <div class="activity-icon appointment">
                                    <i class="fas fa-calendar-check"></i>
                                </div>
                                <div class="activity-content">
                                    <div class="activity-title">New Appointment</div>
                                    <div class="activity-desc">Dr. Smith - Cardiology</div>
                                    <div class="activity-time">
                                        <i class="far fa-clock"></i> 10 mins ago
                                    </div>
                                </div>
                            </div>
                            
                            <div class="activity-item">
                                <div class="activity-icon payment">
                                    <i class="fas fa-file-invoice-dollar"></i>
                                </div>
                                <div class="activity-content">
                                    <div class="activity-title">Payment Received</div>
                                    <div class="activity-desc">Invoice #INV-00542 - $350</div>
                                    <div class="activity-time">
                                        <i class="far fa-clock"></i> 45 mins ago
                                    </div>
                                </div>
                            </div>
                            
                            <div class="activity-item">
                                <div class="activity-icon patient">
                                    <i class="fas fa-user-plus"></i>
                                </div>
                                <div class="activity-content">
                                    <div class="activity-title">New Patient Registered</div>
                                    <div class="activity-desc">Michael Anderson</div>
                                    <div class="activity-time">
                                        <i class="far fa-clock"></i> 1 hour ago
                                    </div>
                                </div>
                            </div>
                            
                            <div class="activity-item">
                                <div class="activity-icon appointment">
                                    <i class="fas fa-prescription"></i>
                                </div>
                                <div class="activity-content">
                                    <div class="activity-title">Prescription Filled</div>
                                    <div class="activity-desc">Order #PH-78214</div>
                                    <div class="activity-time">
                                        <i class="far fa-clock"></i> 2 hours ago
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- System Status -->
                <div class="system-status">
                    <div class="status-card">
                        <div class="status-header">
                            <div class="status-icon active">
                                <i class="fas fa-server"></i>
                            </div>
                            <div class="status-title">System Health</div>
                        </div>
                        <div class="status-info">All systems operational. No issues detected in any modules.</div>
                        <div class="status-stats">
                            <div class="status-stat">
                                <div class="stat-number">99.98%</div>
                                <div class="stat-label">Uptime</div>
                            </div>
                            <div class="status-stat">
                                <div class="stat-number">24ms</div>
                                <div class="stat-label">Avg. Response</div>
                            </div>
                            <div class="status-stat">
                                <div class="stat-number">0</div>
                                <div class="stat-label">Errors</div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="status-card">
                        <div class="status-header">
                            <div class="status-icon warning">
                                <i class="fas fa-ambulance"></i>
                            </div>
                            <div class="status-title">Fleet Management</div>
                        </div>
                        <div class="status-info">2 ambulances require maintenance. Schedule service immediately.</div>
                        <div class="status-stats">
                            <div class="status-stat">
                                <div class="stat-number">14</div>
                                <div class="stat-label">Total Vehicles</div>
                            </div>
                            <div class="status-stat">
                                <div class="stat-number">12</div>
                                <div class="stat-label">Active</div>
                            </div>
                            <div class="status-stat">
                                <div class="stat-number">2</div>
                                <div class="stat-label">Maintenance</div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="status-card">
                        <div class="status-header">
                            <div class="status-icon critical">
                                <i class="fas fa-pills"></i>
                            </div>
                            <div class="status-title">Pharmacy Stock</div>
                        </div>
                        <div class="status-info">3 medications are running low. Reorder required within 24 hours.</div>
                        <div class="status-stats">
                            <div class="status-stat">
                                <div class="stat-number">782</div>
                                <div class="stat-label">Total Items</div>
                            </div>
                            <div class="status-stat">
                                <div class="stat-number">12</div>
                                <div class="stat-label">Low Stock</div>
                            </div>
                            <div class="status-stat">
                                <div class="stat-number">3</div>
                                <div class="stat-label">Critical</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <? include 'include/footer.php' ?>
        </div>
         <?php
            include 'include/messenger.php';
            include 'include/notification.php';
         ?>
        
    </div>
    <script src="/assets/js/main.js"></script>
</body>
</html>