<?php
header('Content-Type: text/html; charset=UTF-8');
require_once "include/session.php";
if (isLoggedIn()) {
  header("Location: dashboard.php");
}
if (isset($_POST['reset_password'])) {
    require_once "include/db.php";
    require_once 'functions.php';
    $success = $error = "";
    $email = trim($_POST['email']);

    $stmt = $conn->prepare("SELECT id FROM users WHERE email = ?");
    $stmt->bind_param("s", $email);
    $stmt->execute();
    $stmt->store_result();

    if ($stmt->num_rows === 0) {
        $error = "No account found with that email.";
        log_audit($conn, 'Reset Password Failed - Email Not Found', 'users', null, null, null, $email, null, 'PasswordRecovery');
    } else {
        $token = bin2hex(random_bytes(32));
        $expiry = date('Y-m-d H:i:s', strtotime('+10 minutes'));

        $stmt = $conn->prepare("UPDATE users SET reset_token = ?, token_expiry = ? WHERE email = ?");
        $stmt->bind_param("sss", $token, $expiry, $email);
        $stmt->execute();

        if (sendPasswordResetEmail($email, $token)) {
            $success = "A reset link has been sent to your email address.";
            log_audit($conn, 'Reset Password Link Sent', 'users', null, null, json_encode(['email' => $email, 'reset_token' => $token, 'expiry' => $expiry]), $email, null, 'PasswordRecovery');
        } else {
            $error = "Reset token generated, but failed to send email.";
            log_audit($conn, 'Reset Password Email Failed', 'users', null, null, json_encode(['email' => $email, 'reset_token' => $token]), $email, null, 'PasswordRecovery');
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Password Recovery | HealthBro Healthcare Management</title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <!-- [favicon] begin -->
    <link rel="shortcut icon" type="image/x-icon" href="https://sylvianettebox.net/favicon.ico" />
    <link rel="icon" type="image/x-icon" href="https://sylvianettebox.net/favicon.ico" />
    <!-- [favicon] end -->
    <link rel="stylesheet" href="auth.css" type="text/css"  />
</head>
<body>
    <div class="auth-container">
        <button class="theme-toggle" id="themeToggle">
            <i class="fas fa-moon"></i>
        </button>
        
        <?php include 'illustrator.php'?>
        
        <div class="auth-forms">
            <div class="logo">
                <h1>HealthBro</h1>
                <p>Healthcare Management System</p>
            </div>
            
            <!-- Forgot Password Form -->
            <form method="POST">
                <div id="forgot-password-form" class="auth-form active">
                    <h2 class="form-title">Reset Your Password</h2>
                    <?php if (!empty($success)): ?>
                        <div class="success-message">
                            <span class="close-btn">&times;</span>
                            <i class="fas fa-check-circle"></i> <?= $success ?>
                        </div>
                    <?php elseif (!empty($error)): ?>
                        <div class="error-message">
                            <span class="close-btn">&times;</span>
                            <i class="fas fa-times-circle"></i> <?= $error ?>
                        </div>
                    <?php endif; ?>
                    <div class="form-group">
                        <div class="input-group">
                            <i class="fas fa-envelope input-icon"></i>
                            <input type="email" name="email" class="form-control" placeholder="Enter your email address">
                        </div>
                    </div>
                    
                    <div class="form-group">
                        <p class="text-muted">We'll send a password reset link to your email</p><br>
                        <button class="btn btn-primary" name="reset_password">Send Reset Link</button>
                    </div>
                    
                    <div class="auth-footer">
                        Remember your password? <a href="login" id="back-to-login">Sign In</a>
                    </div>
                </div>
            </form>
        </div>
    </div>
    
    <div class="toast-container"></div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Theme toggle
            const themeToggle = document.getElementById('themeToggle');
            const body = document.body;
            
            themeToggle.addEventListener('click', function() {
                body.classList.toggle('dark-mode');
                
                if (body.classList.contains('dark-mode')) {
                    themeToggle.innerHTML = '<i class="fas fa-sun"></i>';
                } else {
                    themeToggle.innerHTML = '<i class="fas fa-moon"></i>';
                }
            });
        });
        document.querySelectorAll('.close-btn').forEach(function(btn) {
            btn.addEventListener('click', function() {
                this.parentElement.style.display = 'none';
            });
        });
    </script>
</body>
</html>