<?php
session_start();
require_once "include/db.php"; // adjust path as needed

if (!isset($_SESSION['user_id'])) {
    header("Location: login");
    exit();
}

$user_id = $_SESSION['user_id'];

$stmt = $conn->prepare("SELECT name, userID, profile_pic, is_verified FROM users WHERE id = ?");
if (!$stmt) {
    die("Prepare failed: " . $conn->error);
}

$stmt->bind_param("i", $user_id);
$stmt->execute();
$stmt->bind_result($name, $userID, $profile_pic, $verified);

if (!$stmt->fetch()) {
    die("User not found for ID: $user_id");
}
$stmt->close();

// Assign values to be used in HTML
$userName = $name;
$userID = ucfirst($userID); // e.g. Client or Corporate
$userVerified = $verified ? true : false;
$userPhoto = !empty($profile_pic) ? "profile_pics/" . $profile_pic : "HB";
?>