<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>HealthBüro - Comprehensive Healthcare Management Solution</title>
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@400;500;600;700&family=Open+Sans:wght@400;600&display=swap" rel="stylesheet">
    <!-- FontAwesome -->    
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <!-- [favicon] begin -->
    <link rel="shortcut icon" type="image/x-icon" href="http://sylvianettebox.net/favicon.ico" />
    <link rel="shortcut icon" type="image/x-icon" href="http://sylvianettebox.net/favicon.ico" />
    <!-- [favicon] end -->
    <style>
        :root {
            --primary: #0d6efd;
            --secondary: #6c757d;
            --success: #198754;
            --info: #0dcaf0;
            --warning: #ffc107;
            --danger: #dc3545;
            --light: #f8f9fa;
            --dark: #212529;
            --health-blue: #1a73e8;
            --health-teal: #20c997;
            --health-dark: #2c3e50;
        }
        
        body {
            font-family: 'Candara','Montserrat', sans-serif;
            color: #333;
            background-color: #f8f9fa;
            scroll-behavior: smooth;
        }
        
        h1, h2, h3, h4, h5, h6 {
            font-family: 'Montserrat', sans-serif;
            font-weight: 700;
        }
        
        .navbar {
            background-color: white;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            padding: 15px 0;
        }
        
        .hero {
            background: linear-gradient(135deg, #1a73e8 0%, #0d47a1 100%);
            color: white;
            padding: 120px 0 80px;
            position: relative;
            overflow: hidden;
        }
        
        .hero::before {
            content: "";
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-image: url('data:image/svg+xml;utf8,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1440 320"><path fill="%23ffffff" fill-opacity="0.1" d="M0,192L48,197.3C96,203,192,213,288,229.3C384,245,480,267,576,261.3C672,256,768,224,864,218.7C960,213,1056,235,1152,229.3C1248,224,1344,192,1392,176L1440,160L1440,320L1392,320C1344,320,1248,320,1152,320C1056,320,960,320,864,320C768,320,672,320,576,320C480,320,384,320,288,320C192,320,96,320,48,320L0,320Z"></path></svg>');
            background-repeat: no-repeat;
            background-position: bottom;
            background-size: cover;
        }
        
        .section-title {
            position: relative;
            margin-bottom: 50px;
            padding-bottom: 15px;
        }
        
        .section-title::after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 50%;
            transform: translateX(-50%);
            width: 80px;
            height: 4px;
            background: var(--health-teal);
            border-radius: 2px;
        }
        
        .feature-card {
            background: white;
            border-radius: 10px;
            box-shadow: 0 5px 15px rgba(0,0,0,0.05);
            transition: all 0.3s ease;
            height: 100%;
            border: none;
            overflow: hidden;
        }
        
        .feature-card:hover {
            transform: translateY(-10px);
            box-shadow: 0 15px 30px rgba(0,0,0,0.1);
        }
        
        .feature-icon {
            width: 70px;
            height: 70px;
            border-radius: 50%;
            background: rgba(26, 115, 232, 0.1);
            display: flex;
            align-items: center;
            justify-content: center;
            margin-bottom: 20px;
        }
        
        .feature-icon i {
            font-size: 30px;
            color: var(--health-blue);
        }
        
        .module-badge {
            display: inline-block;
            background: #e9f5ff;
            color: var(--health-blue);
            padding: 8px 15px;
            border-radius: 30px;
            margin: 5px;
            font-size: 0.9rem;
            transition: all 0.3s;
        }
        
        .module-badge:hover {
            background: var(--health-blue);
            color: white;
            transform: scale(1.05);
        }
        
        .security-card {
            border-left: 4px solid var(--health-blue);
            transition: all 0.3s;
        }
        
        .security-card:hover {
            background: #f8f9fa;
            transform: translateX(5px);
        }
        
        .device-card {
            text-align: center;
            padding: 30px 20px;
            border-radius: 10px;
            background: white;
            box-shadow: 0 5px 15px rgba(0,0,0,0.05);
            transition: all 0.3s;
        }
        
        .device-card:hover {
            transform: translateY(-10px);
            box-shadow: 0 15px 30px rgba(0,0,0,0.1);
        }
        
        .device-card i {
            font-size: 50px;
            margin-bottom: 20px;
            color: var(--health-blue);
        }
        
        .cta-section {
            background: linear-gradient(135deg, #1a73e8 0%, #0d47a1 100%);
            color: white;
            padding: 80px 0;
            position: relative;
            overflow: hidden;
        }
        
        .cta-section::before {
            content: "";
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-image: url('data:image/svg+xml;utf8,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1440 320"><path fill="%23ffffff" fill-opacity="0.1" d="M0,160L48,149.3C96,139,192,117,288,122.7C384,128,480,160,576,165.3C672,171,768,149,864,138.7C960,128,1056,128,1152,138.7C1248,149,1344,171,1392,181.3L1440,192L1440,320L1392,320C1344,320,1248,320,1152,320C1056,320,960,320,864,320C768,320,672,320,576,320C480,320,384,320,288,320C192,320,96,320,48,320L0,320Z"></path></svg>');
            background-repeat: no-repeat;
            background-position: bottom;
            background-size: cover;
        }
        
        .footer {
            background: var(--health-dark);
            color: white;
            padding: 70px 0 30px;
        }
        
        .footer a {
            color: rgba(255,255,255,0.7);
            text-decoration: none;
            transition: all 0.3s;
        }
        
        .footer a:hover {
            color: white;
        }
        
        .social-icon {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            background: rgba(255,255,255,0.1);
            display: inline-flex;
            align-items: center;
            justify-content: center;
            margin-right: 10px;
            transition: all 0.3s;
        }
        
        .social-icon:hover {
            background: var(--health-blue);
            transform: translateY(-5px);
        }
        
        .stat-number {
            font-size: 2.5rem;
            font-weight: 700;
            color: var(--health-blue);
        }
        
        .stat-label {
            font-size: 1rem;
            color: var(--secondary);
            text-transform: uppercase;
            letter-spacing: 1px;
        }
        
        .btn-primary {
            background-color: var(--health-blue);
            border-color: var(--health-blue);
            padding: 10px 25px;
            font-weight: 600;
            transition: all 0.3s;
        }
        
        .btn-primary:hover {
            background-color: #0d47a1;
            border-color: #0d47a1;
            transform: translateY(-3px);
        }
        
        .btn-outline-light:hover {
            background-color: var(--health-blue);
            border-color: var(--health-blue);
        }
        
        .timeline {
            position: relative;
            max-width: 1200px;
            margin: 0 auto;
        }
        
        .timeline::after {
            content: '';
            position: absolute;
            width: 4px;
            background-color: var(--health-teal);
            top: 0;
            bottom: 0;
            left: 50%;
            margin-left: -2px;
        }
        
        .timeline-item {
            padding: 10px 40px;
            position: relative;
            width: 50%;
            box-sizing: border-box;
        }
        
        .timeline-item::after {
            content: '';
            position: absolute;
            width: 20px;
            height: 20px;
            background-color: white;
            border: 4px solid var(--health-teal);
            top: 15px;
            border-radius: 50%;
            z-index: 1;
        }
        
        .left {
            left: 0;
        }
        
        .right {
            left: 50%;
        }
        
        .left::after {
            right: -12px;
        }
        
        .right::after {
            left: -12px;
        }
        
        .timeline-content {
            padding: 20px 30px;
            background-color: white;
            position: relative;
            border-radius: 10px;
            box-shadow: 0 5px 15px rgba(0,0,0,0.05);
        }
        
        @media screen and (max-width: 768px) {
            .timeline::after {
                left: 31px;
            }
            
            .timeline-item {
                width: 100%;
                padding-left: 70px;
                padding-right: 25px;
            }
            
            .timeline-item::after {
                left: 21px;
            }
            
            .right {
                left: 0;
            }
        }
        
        .demo-video {
            border-radius: 15px;
            overflow: hidden;
            box-shadow: 0 10px 30px rgba(0,0,0,0.15);
            margin-bottom: 30px;
        }
        
        .demo-thumbnails {
            display: flex;
            gap: 15px;
            overflow-x: auto;
            padding: 10px 0;
        }
        
        .demo-thumbnail {
            flex: 0 0 auto;
            width: 150px;
            height: 100px;
            border-radius: 8px;
            overflow: hidden;
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
            transition: all 0.3s;
            cursor: pointer;
        }
        
        .demo-thumbnail:hover {
            transform: translateY(-5px);
            box-shadow: 0 8px 20px rgba(0,0,0,0.15);
        }
        
        .whatsapp-btn {
            position: fixed;
            bottom: 30px;
            right: 30px;
            width: 60px;
            height: 60px;
            background: #25D366;
            color: white;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 30px;
            box-shadow: 0 5px 15px rgba(0,0,0,0.2);
            z-index: 1000;
            transition: all 0.3s;
        }
        
        .whatsapp-btn:hover {
            transform: scale(1.1);
            box-shadow: 0 8px 20px rgba(0,0,0,0.3);
            color: white;
        }
        
        .contact-form .form-control {
            border-radius: 8px;
            padding: 12px 15px;
            border: 1px solid #e0e0e0;
        }
        
        .contact-form .form-control:focus {
            border-color: var(--health-blue);
            box-shadow: 0 0 0 0.25rem rgba(26, 115, 232, 0.25);
        }
        
        .contact-form label {
            font-weight: 600;
            margin-bottom: 8px;
        }
    </style>
</head>
<body>
    <!-- Navigation -->
    <nav class="navbar navbar-expand-lg navbar-light sticky-top">
        <div class="container">
            <a class="navbar-brand fw-bold" href="#">
                <i class="bi bi-heart-pulse-fill me-2 text-primary"></i>
                <span class="text-primary">Health</span><span class="text-dark">Büro</span>
            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto">
                    <li class="nav-item"><a class="nav-link" href="#features"><i class="fas fa-star me-1"></i>Features</a></li>
                    <li class="nav-item"><a class="nav-link" href="#modules"><i class="fas fa-th-large me-1"></i>Modules</a></li>
                    <li class="nav-item"><a class="nav-link" href="#demo"><i class="fas fa-play-circle me-1"></i>Demo</a></li>
                    <li class="nav-item"><a class="nav-link" href="#security"><i class="fas fa-shield-alt me-1"></i>Security</a></li>
                    <li class="nav-item"><a class="nav-link" href="#timeline"><i class="fas fa-route me-2"></i>Roadmap</a></li>
                    <li class="nav-item"><a class="nav-link" href="#contact"><i class="fas fa-envelope me-1"></i>Contact</a></li>
                </ul>
                <div class="ms-lg-3 mt-3 mt-lg-0">
                    <a class="btn btn-outline-primary me-2" href="login"><i class="fas fa-user-alt me-1"></i>Account</a>
                    <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#demoModal"><i class="fas fa-play-circle me-1"></i>Get Demo</button>
                </div>
            </div>
        </div>
    </nav>

    <!-- Hero Section -->
    <section class="hero">
        <div class="container position-relative">
            <div class="row align-items-center">
                <div class="col-lg-6">
                    <h1 class="display-4 fw-bold mb-4">HealthBüro</h1>
                    <p class="lead mb-5">A robust, hybrid e-health management system that brings modern efficiency and connectivity to healthcare institutions. From patient registration to morgue management, HealthBüro delivers comprehensive solutions for healthcare operations.</p>
                    <div class="d-flex flex-wrap gap-2">
                        <button class="btn btn-light btn-lg fw-bold" data-bs-toggle="modal" data-bs-target="#demoModal">Book a Demo</button>
                        <button class="btn btn-outline-light btn-lg" data-bs-toggle="modal" data-bs-target="#salesModal">Contact Sales</button>
                    </div>
                </div>
                <div class="col-lg-6 mt-5 mt-lg-0">
                    <div class="position-relative">
                        <img src="data:image/svg+xml;utf8,<svg xmlns='http://www.w3.org/2000/svg' width='600' height='400' viewBox='0 0 600 400'><rect width='600' height='400' fill='%23ffffff' opacity='0.1' rx='20'/><rect x='50' y='50' width='500' height='300' fill='%23ffffff' opacity='0.2' rx='15'/><circle cx='300' cy='200' r='80' fill='%23ffffff' opacity='0.3'/><line x1='300' y1='120' x2='300' y2='280' stroke='%23ffffff' stroke-width='10'/><line x1='220' y1='200' x2='380' y2='200' stroke='%23ffffff' stroke-width='10'/></svg>" alt="HealthBüro Dashboard" class="img-fluid rounded-3 shadow-lg">
                        <div class="position-absolute top-0 end-0 mt-4 me-4">
                            <div class="bg-success text-white p-2 rounded-pill fw-bold">Version 0.4.2</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Stats Section -->
    <section class="py-5 bg-light">
        <div class="container">
            <div class="row text-center">
                <div class="col-md-3">
                    <div class="stat-number">15+</div>
                    <div class="stat-label">Integrated Modules</div>
                </div>
                <div class="col-md-3">
                    <div class="stat-number">4</div>
                    <div class="stat-label">Languages</div>
                </div>
                <div class="col-md-3">
                    <div class="stat-number">3</div>
                    <div class="stat-label">Platforms</div>
                </div>
                <div class="col-md-3">
                    <div class="stat-number">9+</div>
                    <div class="stat-label">Years Active</div>
                </div>
            </div>
        </div>
    </section>

    <!-- Features Section -->
    <section id="features" class="py-5">
        <div class="container">
            <div class="text-center mb-5">
                <h2 class="section-title">Comprehensive Healthcare Features</h2>
                <p class="lead">Everything you need to manage your healthcare institution efficiently</p>
            </div>
            
            <div class="row g-4">
                <!-- Feature 1 -->
                <div class="col-md-6 col-lg-4">
                    <div class="feature-card p-4 h-100">
                        <div class="feature-icon mx-auto">
                            <i class="bi bi-people-fill"></i>
                        </div>
                        <h4 class="text-center mb-3">e-Patient Management</h4>
                        <p class="text-center">Seamlessly handle patient registration, admissions, medication, discharge, and billing in one integrated system.</p>
                    </div>
                </div>
                
                <!-- Feature 2 -->
                <div class="col-md-6 col-lg-4">
                    <div class="feature-card p-4 h-100">
                        <div class="feature-icon mx-auto">
                            <i class="bi bi-file-earmark-medical-fill"></i>
                        </div>
                        <h4 class="text-center mb-3">e-Health Records (EHR)</h4>
                        <p class="text-center">Secure storage and real-time updates of medical histories and treatment plans with advanced encryption.</p>
                    </div>
                </div>
                
                <!-- Feature 3 -->
                <div class="col-md-6 col-lg-4">
                    <div class="feature-card p-4 h-100">
                        <div class="feature-icon mx-auto">
                            <i class="bi bi-calendar-check-fill"></i>
                        </div>
                        <h4 class="text-center mb-3">e-Appointment Scheduling</h4>
                        <p class="text-center">Smart, calendar-based appointment booking for patients and providers with automated reminders.</p>
                    </div>
                </div>
                
                <!-- Feature 4 -->
                <div class="col-md-6 col-lg-4">
                    <div class="feature-card p-4 h-100">
                        <div class="feature-icon mx-auto">
                            <i class="bi bi-droplet-fill"></i>
                        </div>
                        <h4 class="text-center mb-3">e-Laboratory Module</h4>
                        <p class="text-center">Custom lab reports with seamless medical record integration for faster diagnostics.</p>
                    </div>
                </div>
                
                <!-- Feature 5 - e-Ambulance -->
                <div class="col-md-6 col-lg-4">
                    <div class="feature-card p-4 h-100">
                        <div class="feature-icon mx-auto">
                            <i class="bi bi-ambulance"></i>
                        </div>
                        <h4 class="text-center mb-3">e-Ambulance Management</h4>
                        <p class="text-center">Real-time ambulance tracking, dispatch management, and emergency response coordination.</p>
                    </div>
                </div>
                
                <!-- Feature 6 - e-Mortuary -->
                <div class="col-md-6 col-lg-4">
                    <div class="feature-card p-4 h-100">
                        <div class="feature-icon mx-auto">
                            <i class="bi bi-building"></i>
                        </div>
                        <h4 class="text-center mb-3">e-Mortuary Management</h4>
                        <p class="text-center">Comprehensive morgue logistics, inventory tracking, and documentation management.</p>
                    </div>
                </div>
                
                <!-- New Feature 1 - e-Queues -->
                <div class="col-md-6 col-lg-4">
                    <div class="feature-card p-4 h-100">
                        <div class="feature-icon mx-auto">
                            <i class="bi bi-people"></i>
                        </div>
                        <h4 class="text-center mb-3">e-Queue Management</h4>
                        <p class="text-center">Monitor facility access and manage patient queues efficiently with FIFO and priority systems.</p>
                    </div>
                </div>
                
                <!-- New Feature 2 - e-Accounts -->
                <div class="col-md-6 col-lg-4">
                    <div class="feature-card p-4 h-100">
                        <div class="feature-icon mx-auto">
                            <i class="bi bi-cash-coin"></i>
                        </div>
                        <h4 class="text-center mb-3">e-Accounts & Billing</h4>
                        <p class="text-center">POS/web payments, receipts, insurance claims, and financial analytics in one platform.</p>
                    </div>
                </div>
                
                <!-- New Feature 3 - e-Staff -->
                <div class="col-md-6 col-lg-4">
                    <div class="feature-card p-4 h-100">
                        <div class="feature-icon mx-auto">
                            <i class="bi bi-person-badge"></i>
                        </div>
                        <h4 class="text-center mb-3">e-Staff Management</h4>
                        <p class="text-center">Schedule, track, and manage healthcare professionals with shift planning and performance analytics.</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Modules Section -->
    <section id="modules" class="py-5 bg-light">
        <div class="container">
            <div class="text-center mb-5">
                <h2 class="section-title">Tailored Modules for Every Department</h2>
                <p class="lead">Specialized solutions designed for different healthcare roles</p>
            </div>
            
            <div class="row justify-content-center">
                <div class="col-md-8">
                    <div class="d-flex flex-wrap justify-content-center">
                        <span class="module-badge"><i class="bi bi-reception-4 me-2"></i> Front Desk</span>
                        <span class="module-badge"><i class="bi bi-heart-pulse me-2"></i> Nurses</span>
                        <span class="module-badge"><i class="bi bi-person-badge me-2"></i> Consultants</span>
                        <span class="module-badge"><i class="bi bi-droplet me-2"></i> Laboratory</span>
                        <span class="module-badge"><i class="bi bi-capsule me-2"></i> Pharmacy</span>
                        <span class="module-badge"><i class="bi bi-cash-coin me-2"></i> Finance & Accounts</span>
                        <span class="module-badge"><i class="bi bi-people-fill me-2"></i> HR</span>
                        <span class="module-badge"><i class="bi bi-ambulance me-2"></i> Ambulance</span>
                        <span class="module-badge"><i class="bi bi-building me-2"></i> Morgue</span>
                        <span class="module-badge"><i class="bi bi-laptop me-2"></i> IT & Admin</span>
                        <span class="module-badge"><i class="bi bi-person-circle me-2"></i> Patient Portal</span>
                    </div>
                </div>
            </div>
            
            <div class="row mt-5 g-4">
                <div class="col-lg-4">
                    <div class="card border-0 shadow h-100">
                        <div class="card-body p-4">
                            <h3 class="mb-4">For Healthcare Providers</h3>
                            <p>Streamline operations, reduce paperwork, and improve patient care with specialized tools for medical professionals.</p>
                            <ul class="list-group list-group-flush">
                                <li class="list-group-item bg-transparent border-0 px-0"><i class="bi bi-check-circle-fill text-success me-2"></i> Real-time patient data access</li>
                                <li class="list-group-item bg-transparent border-0 px-0"><i class="bi bi-check-circle-fill text-success me-2"></i> Automated appointment scheduling</li>
                                <li class="list-group-item bg-transparent border-0 px-0"><i class="bi bi-check-circle-fill text-success me-2"></i> Integrated billing system</li>
                            </ul>
                        </div>
                    </div>
                </div>
                
                <div class="col-lg-4">
                    <div class="card border-0 shadow h-100">
                        <div class="card-body p-4">
                            <h3 class="mb-4">For Medical Institutions</h3>
                            <p>Manage entire healthcare facilities with comprehensive solutions for clinics, hospitals, and laboratories.</p>
                            <ul class="list-group list-group-flush">
                                <li class="list-group-item bg-transparent border-0 px-0"><i class="bi bi-check-circle-fill text-success me-2"></i> Multi-facility management</li>
                                <li class="list-group-item bg-transparent border-0 px-0"><i class="bi bi-check-circle-fill text-success me-2"></i> Centralized administration</li>
                                <li class="list-group-item bg-transparent border-0 px-0"><i class="bi bi-check-circle-fill text-success me-2"></i> Scalable infrastructure</li>
                            </ul>
                        </div>
                    </div>
                </div>
                
                <div class="col-lg-4">
                    <div class="card border-0 shadow h-100">
                        <div class="card-body p-4">
                            <h3 class="mb-4">For Patients</h3>
                            <p>Digital-first, remote-access care that puts patients in control of their health journey.</p>
                            <ul class="list-group list-group-flush">
                                <li class="list-group-item bg-transparent border-0 px-0"><i class="bi bi-check-circle-fill text-success me-2"></i> Online appointment booking</li>
                                <li class="list-group-item bg-transparent border-0 px-0"><i class="bi bi-check-circle-fill text-success me-2"></i> Access to medical records</li>
                                <li class="list-group-item bg-transparent border-0 px-0"><i class="bi bi-check-circle-fill text-success me-2"></i> Virtual consultations</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Demo Section -->
    <section id="demo" class="py-5">
        <div class="container">
            <div class="text-center mb-5">
                <h2 class="section-title">See HealthBüro in Action</h2>
                <p class="lead">Experience our comprehensive healthcare management solution</p>
            </div>
            
            <div class="row">
                <div class="col-lg-8 mx-auto">
                    <div class="demo-video ratio ratio-16x9">
                        <div class="bg-primary bg-opacity-10 d-flex align-items-center justify-content-center rounded">
                            <div class="text-center">
                                <i class="bi bi-play-circle-fill text-primary" style="font-size: 4rem;"></i>
                                <h4 class="mt-3">HealthBüro System Demo</h4>
                                <p class="text-muted">Click to play the video</p>
                            </div>
                        </div>
                    </div>
                    
                    <div class="text-center mt-4">
                        <h4 class="mb-3">What Our Clients Say</h4>
                        <div class="d-flex justify-content-center">
                            <div class="mx-3">
                                <div class="d-flex align-items-center">
                                    <i class="bi bi-star-fill text-warning me-1"></i>
                                    <i class="bi bi-star-fill text-warning me-1"></i>
                                    <i class="bi bi-star-fill text-warning me-1"></i>
                                    <i class="bi bi-star-fill text-warning me-1"></i>
                                    <i class="bi bi-star-fill text-warning"></i>
                                </div>
                                <p class="small mb-0">4.9/5 from 128 reviews</p>
                            </div>
                        </div>
                    </div>
                    
                    <h5 class="mt-5 mb-3">System Screenshots</h5>
                    <div class="demo-thumbnails">
                        <div class="demo-thumbnail bg-primary bg-opacity-10"></div>
                        <div class="demo-thumbnail bg-info bg-opacity-10"></div>
                        <div class="demo-thumbnail bg-success bg-opacity-10"></div>
                        <div class="demo-thumbnail bg-warning bg-opacity-10"></div>
                        <div class="demo-thumbnail bg-danger bg-opacity-10"></div>
                        <div class="demo-thumbnail bg-secondary bg-opacity-10"></div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Security Section -->
    <section id="security" class="py-5 bg-light">
        <div class="container">
            <div class="text-center mb-5">
                <h2 class="section-title">Security & Compliance</h2>
                <p class="lead">Protecting your data with enterprise-grade security measures</p>
            </div>
            
            <div class="row g-4">
                <div class="col-md-6">
                    <div class="security-card p-4 h-100">
                        <div class="d-flex align-items-center mb-3">
                            <div class="bg-primary bg-opacity-10 p-3 rounded-circle me-3">
                                <i class="bi bi-shield-lock-fill text-primary fs-3"></i>
                            </div>
                            <h4 class="mb-0">Data Encryption</h4>
                        </div>
                        <p>All sensitive data is encrypted both in transit and at rest using industry-standard AES-256 encryption.</p>
                    </div>
                </div>
                
                <div class="col-md-6">
                    <div class="security-card p-4 h-100">
                        <div class="d-flex align-items-center mb-3">
                            <div class="bg-primary bg-opacity-10 p-3 rounded-circle me-3">
                                <i class="bi bi-person-badge-fill text-primary fs-3"></i>
                            </div>
                            <h4 class="mb-0">Role-based Access</h4>
                        </div>
                        <p>Granular access controls ensure that staff only see information relevant to their role and department.</p>
                    </div>
                </div>
                
                <div class="col-md-6">
                    <div class="security-card p-4 h-100">
                        <div class="d-flex align-items-center mb-3">
                            <div class="bg-primary bg-opacity-10 p-3 rounded-circle me-3">
                                <i class="bi bi-cloud-arrow-up-fill text-primary fs-3"></i>
                            </div>
                            <h4 class="mb-0">Server Backup</h4>
                        </div>
                        <p>Automated daily backups and cloud syncing ensure your data is always protected and accessible.</p>
                    </div>
                </div>
                
                <div class="col-md-6">
                    <div class="security-card p-4 h-100">
                        <div class="d-flex align-items-center mb-3">
                            <div class="bg-primary bg-opacity-10 p-3 rounded-circle me-3">
                                <i class="bi bi-file-earmark-medical-fill text-primary fs-3"></i>
                            </div>
                            <h4 class="mb-0">HIPAA Compliant</h4>
                        </div>
                        <p>Designed to meet healthcare compliance standards including HIPAA, GDPR, and more.</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Multi-Platform Section -->
    <section class="py-5">
        <div class="container">
            <div class="text-center mb-5">
                <h2 class="section-title">Multi-Language & Device Access</h2>
                <p class="lead">Access HealthBüro anytime, anywhere, on any device</p>
            </div>
            
            <div class="row g-4">
                <div class="col-md-4">
                    <div class="device-card h-100">
                        <i class="bi bi-globe"></i>
                        <h4>Web App</h4>
                        <p>Access all features through any modern web browser with responsive design.</p>
                    </div>
                </div>
                
                <div class="col-md-4">
                    <div class="device-card h-100">
                        <i class="bi bi-laptop"></i>
                        <h4>Desktop App</h4>
                        <p>Native applications for Windows and macOS with offline capabilities.</p>
                    </div>
                </div>
                
                <div class="col-md-4">
                    <div class="device-card h-100">
                        <i class="bi bi-phone"></i>
                        <h4>Mobile App</h4>
                        <p>Full-featured mobile apps for iOS and Android for on-the-go access.</p>
                    </div>
                </div>
            </div>
            
            <div class="mt-5 text-center">
                <h4 class="mb-3">Supported Languages</h4>
                <div class="d-flex justify-content-center flex-wrap">
                    <span class="badge bg-primary me-2 mb-2 px-3 py-2 fs-6">English</span>
                    <span class="badge bg-primary me-2 mb-2 px-3 py-2 fs-6">French</span>
                    <span class="badge bg-primary me-2 mb-2 px-3 py-2 fs-6">Spanish</span>
                    <span class="badge bg-primary mb-2 px-3 py-2 fs-6">Portuguese</span>
                </div>
            </div>
        </div>
    </section>

    <!-- Future Roadmap -->
    <section id="timeline" class="py-5 bg-light">
        <div class="container">
            <div class="text-center mb-5">
                <h2 class="section-title">Future Ready Roadmap</h2>
                <p class="lead">Innovative features coming soon to HealthBüro</p>
            </div>
            
            <div class="timeline">
                <div class="timeline-item left">
                    <div class="timeline-content">
                        <h4>e-Medical Store</h4>
                        <p>Integrated medical e-commerce module for purchasing medical supplies and equipment directly through HealthBüro.</p>
                        <div class="badge bg-info">Q3 2023</div>
                    </div>
                </div>
                <div class="timeline-item right">
                    <div class="timeline-content">
                        <h4>Wallet Management</h4>
                        <p>Secure digital wallets for patients to store payment information and manage healthcare expenses.</p>
                        <div class="badge bg-info">Q4 2023</div>
                    </div>
                </div>
                <div class="timeline-item left">
                    <div class="timeline-content">
                        <h4>e-Prescription Network</h4>
                        <p>Digital prescription system connecting doctors, pharmacies, and patients with real-time tracking.</p>
                        <div class="badge bg-info">Q1 2024</div>
                    </div>
                </div>
                <div class="timeline-item right">
                    <div class="timeline-content">
                        <h4>Advanced Analytics Suite</h4>
                        <p>Predictive analytics and data visualization tools for healthcare trend analysis and decision support.</p>
                        <div class="badge bg-info">Q2 2024</div>
                    </div>
                </div>
                <div class="timeline-item left">
                    <div class="timeline-content">
                        <h4>Remote Patient Monitoring</h4>
                        <p>Integration with IoT devices for continuous health monitoring and automated alerts.</p>
                        <div class="badge bg-info">Q3 2024</div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- CTA Section -->
    <section class="cta-section">
        <div class="container position-relative">
            <div class="row justify-content-center">
                <div class="col-lg-8 text-center">
                    <h2 class="mb-4">Ready to modernize your healthcare facility?</h2>
                    <p class="lead mb-5">HealthBüro is your all-in-one platform to streamline hospital operations and deliver quality healthcare faster and smarter.</p>
                    <div class="d-flex flex-wrap justify-content-center gap-3">
                        <button class="btn btn-light btn-lg fw-bold px-4" data-bs-toggle="modal" data-bs-target="#demoModal">Book a Demo</button>
                        <button class="btn btn-outline-light btn-lg px-4" data-bs-toggle="modal" data-bs-target="#salesModal">Contact Sales</button>
                        <button class="btn btn-outline-light btn-lg px-4">Request Docs</button>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Contact Section -->
    <section id="contact" class="py-5">
        <div class="container">
            <div class="text-center mb-5">
                <h2 class="section-title">Contact Us</h2>
                <p class="lead">Get in touch with our healthcare technology experts</p>
            </div>
            
            <div class="row">
                <div class="col-lg-6">
                    <div class="card h-100 border-0 shadow">
                        <div class="card-body p-5">
                            <h3 class="mb-4">Send us a message</h3>
                            <form class="contact-form">
                                <div class="mb-3">
                                    <label for="name" class="form-label">Full Name</label>
                                    <input type="text" class="form-control" id="name" placeholder="John Smith">
                                </div>
                                <div class="mb-3">
                                    <label for="email" class="form-label">Email Address</label>
                                    <input type="email" class="form-control" id="email" placeholder="name@example.com">
                                </div>
                                <div class="mb-3">
                                    <label for="institution" class="form-label">Institution Name</label>
                                    <input type="text" class="form-control" id="institution" placeholder="Medical Center">
                                </div>
                                <div class="mb-3">
                                    <label for="message" class="form-label">Message</label>
                                    <textarea class="form-control" id="message" rows="4" placeholder="Tell us about your healthcare needs"></textarea>
                                </div>
                                <button type="submit" class="btn btn-primary w-100">Send Message</button>
                            </form>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6 mt-5 mt-lg-0">
                    <div class="card h-100 border-0 shadow">
                        <div class="card-body p-5">
                            <h3 class="mb-4">Contact Information</h3>
                            <ul class="list-unstyled">
                                <li class="mb-4">
                                    <div class="d-flex">
                                        <div class="me-4">
                                            <i class="bi bi-geo-alt fs-2 text-primary"></i>
                                        </div>
                                        <div>
                                            <h5>Our Location</h5>
                                            <p class="mb-0">Healthcare Technology Park, Lagos, Nigeria</p>
                                        </div>
                                    </div>
                                </li>
                                <li class="mb-4">
                                    <div class="d-flex">
                                        <div class="me-4">
                                            <i class="bi bi-envelope fs-2 text-primary"></i>
                                        </div>
                                        <div>
                                            <h5>Email Us</h5>
                                            <p class="mb-0">support@healthburo.com<br>sales@healthburo.com</p>
                                        </div>
                                    </div>
                                </li>
                                <li>
                                    <div class="d-flex">
                                        <div class="me-4">
                                            <i class="bi bi-telephone fs-2 text-primary"></i>
                                        </div>
                                        <div>
                                            <h5>Call Us</h5>
                                            <p class="mb-0">+234-803-333-3628<br>+234-809-555-1234</p>
                                        </div>
                                    </div>
                                </li>
                            </ul>
                            <div class="mt-5">
                                <h5>Business Hours</h5>
                                <p class="mb-1">Monday - Friday: 8am to 6pm</p>
                                <p class="mb-1">Saturday: 9am to 1pm</p>
                                <p class="mb-0">Sunday: Closed</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Footer -->
    <footer class="footer">
        <div class="container">
            <div class="row g-5">
                <div class="col-lg-4">
                    <h3 class="mb-4"><i class="bi bi-heart-pulse-fill me-2"></i> HealthBüro</h3>
                    <p>A robust, hybrid e-health management system that brings modern efficiency and connectivity to healthcare institutions.</p>
                    <div class="mt-4">
                        <a href="#" class="social-icon"><i class="bi bi-facebook"></i></a>
                        <a href="#" class="social-icon"><i class="bi bi-twitter"></i></a>
                        <a href="#" class="social-icon"><i class="bi bi-linkedin"></i></a>
                        <a href="#" class="social-icon"><i class="bi bi-instagram"></i></a>
                    </div>
                </div>
                
                <div class="col-lg-2 col-md-6">
                    <h5 class="mb-4">Quick Links</h5>
                    <ul class="list-unstyled">
                        <li class="mb-2">
                            <a href="#features"><i class="fas fa-star me-2"></i> Features</a>
                        </li>
                        <li class="mb-2">
                            <a href="#modules"><i class="fas fa-th-large me-2"></i> Modules</a>
                        </li>
                        <li class="mb-2">
                            <a href="#demo"><i class="fas fa-play-circle me-2"></i> Demo</a>
                        </li>
                        <li class="mb-2">
                            <a href="#security"><i class="fas fa-shield-alt me-2"></i> Security</a>
                        </li>
                        <li>
                            <a href="#contact"><i class="fas fa-envelope me-2"></i> Contact</a>
                        </li>
                    </ul>
                </div>
                
                <div class="col-lg-3 col-md-6">
                    <h5 class="mb-4">Resources</h5>
                    <ul class="list-unstyled">
                        <li class="mb-2">
                            <a href="#"><i class="fas fa-book me-2"></i> Documentation</a>
                        </li>
                        <li class="mb-2">
                            <a href="#"><i class="fas fa-plug me-2"></i> API Integration</a>
                        </li>
                        <li class="mb-2">
                            <a href="#"><i class="fas fa-life-ring me-2"></i> Help Center</a>
                        </li>
                        <li class="mb-2">
                            <a href="#"><i class="fas fa-users me-2"></i> Community Forum</a>
                        </li>
                        <li>
                            <a href="#"><i class="fas fa-clipboard-list me-2"></i> Release Notes</a>
                        </li>
                    </ul>
                </div>

                
                <div class="col-lg-3">
                    <h5 class="mb-4">Contact Us</h5>
                    <ul class="list-unstyled">
                        <li class="mb-3"><i class="bi bi-envelope me-2"></i> support@healthburo.com</li>
                        <li class="mb-3"><i class="bi bi-telephone me-2"></i> +234-803-333-3628</li>
                        <li><i class="bi bi-building me-2"></i> Healthcare Technology Park, Lagos, Nigeria</li>
                    </ul>
                </div>
            </div>
            
            <hr class="mt-5 mb-4">
            
            <div class="row">
                <div class="col-md-6 mb-3 mb-md-0">
                    <p class="mb-0">&copy; 2025HealthBüro. All rights reserved.</p>
                </div>
                <div class="col-md-6 text-md-end">
                    <p class="mb-0">Version 0.4.2 | Launched April 31, 2016</p>
                </div>
            </div>
        </div>
    </footer>

    <!-- WhatsApp Button -->
    <a href="https://wa.me/2348033333628" class="whatsapp-btn" target="_blank">
        <i class="bi bi-whatsapp"></i>
    </a>

    <!-- Demo Modal -->
    <div class="modal fade" id="demoModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Book a Demo</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form id="demoForm">
                        <div class="mb-3">
                            <label class="form-label">Full Name</label>
                            <input type="text" class="form-control" placeholder="John Smith" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Email Address</label>
                            <input type="email" class="form-control" placeholder="name@example.com" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Institution Name</label>
                            <input type="text" class="form-control" placeholder="Medical Center">
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Preferred Date</label>
                            <input type="date" class="form-control">
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Message</label>
                            <textarea class="form-control" rows="3" placeholder="Specific features you'd like to see"></textarea>
                        </div>
                        <button type="submit" class="btn btn-primary w-100">Request Demo</button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Sales Modal -->
    <div class="modal fade" id="salesModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Contact Sales</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form id="salesForm">
                        <div class="mb-3">
                            <label class="form-label">Full Name</label>
                            <input type="text" class="form-control" placeholder="John Smith" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Email Address</label>
                            <input type="email" class="form-control" placeholder="name@example.com" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Phone Number</label>
                            <input type="tel" class="form-control" placeholder="+234 803 333 3628">
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Institution Type</label>
                            <select class="form-select">
                                <option>Select institution type</option>
                                <option>Clinic</option>
                                <option>Hospital</option>
                                <option>Medical Laboratory</option>
                                <option>Community Health Center</option>
                                <option>Other</option>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Message</label>
                            <textarea class="form-control" rows="3" placeholder="Tell us about your requirements"></textarea>
                        </div>
                        <button type="submit" class="btn btn-primary w-100">Contact Sales</button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Confirmation Modal -->
    <div class="modal fade" id="confirmationModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-sm">
            <div class="modal-content">
                <div class="modal-body text-center p-4">
                    <div class="mb-3">
                        <i class="bi bi-check-circle-fill text-success" style="font-size: 3rem;"></i>
                    </div>
                    <h5>Thank You!</h5>
                    <p class="mb-0">Your request has been submitted successfully.</p>
                </div>
                <div class="modal-footer justify-content-center">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
    
    <script>
        // Handle form submissions
        document.addEventListener('DOMContentLoaded', function() {
            // Demo form
            const demoForm = document.getElementById('demoForm');
            if(demoForm) {
                demoForm.addEventListener('submit', function(e) {
                    e.preventDefault();
                    const demoModal = bootstrap.Modal.getInstance(document.getElementById('demoModal'));
                    demoModal.hide();
                    
                    // Show confirmation modal
                    const confirmationModal = new bootstrap.Modal(document.getElementById('confirmationModal'));
                    confirmationModal.show();
                    
                    // Reset form
                    demoForm.reset();
                });
            }
            
            // Sales form
            const salesForm = document.getElementById('salesForm');
            if(salesForm) {
                salesForm.addEventListener('submit', function(e) {
                    e.preventDefault();
                    const salesModal = bootstrap.Modal.getInstance(document.getElementById('salesModal'));
                    salesModal.hide();
                    
                    // Show confirmation modal
                    const confirmationModal = new bootstrap.Modal(document.getElementById('confirmationModal'));
                    confirmationModal.show();
                    
                    // Reset form
                    salesForm.reset();
                });
            }
            
            // Smooth scrolling for navigation links
            document.querySelectorAll('a[href^="#"]').forEach(anchor => {
                anchor.addEventListener('click', function (e) {
                    e.preventDefault();
                    
                    const target = document.querySelector(this.getAttribute('href'));
                    if (target) {
                        window.scrollTo({
                            top: target.offsetTop - 80,
                            behavior: 'smooth'
                        });
                    }
                });
            });
        });
    </script>
</body>
</html>