<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>MediSync - Medical Notes Management</title>
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <!-- DataTables -->
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap5.min.css">
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@300;400;500;600;700&family=Orbitron:wght@400;500;600;700&display=swap" rel="stylesheet">
    <style>
        :root {
            --primary: #0a84ff;
            --secondary: #5e5ce6;
            --accent: #00d9ff;
            --success: #30d158;
            --warning: #ff9f0a;
            --danger: #ff375f;
            --dark: #1c1c1e;
            --darker: #121214;
            --light: #f5f5f7;
        }
        
        body {
            background-color: #121214;
            color: #e5e5e7;
            font-family: 'Montserrat', sans-serif;
            overflow-x: hidden;
            height: 100vh;
        }
        
        .futuristic-font {
            font-family: 'Orbitron', sans-serif;
            letter-spacing: 1px;
        }
        
        /* Custom Scrollbar */
        ::-webkit-scrollbar {
            width: 8px;
        }
        ::-webkit-scrollbar-track {
            background: var(--darker);
        }
        ::-webkit-scrollbar-thumb {
            background: var(--secondary);
            border-radius: 4px;
        }
        
        /* Sidebar */
        #sidebar {
            background: linear-gradient(180deg, var(--darker) 0%, rgba(28,28,30,0.95) 100%);
            border-right: 1px solid rgba(94,92,230,0.2);
            height: 100vh;
            position: fixed;
            transition: all 0.3s;
            z-index: 1000;
            box-shadow: 0 0 20px rgba(0,0,0,0.5);
        }
        
        .sidebar-header {
            padding: 20px;
            background: rgba(10,132,255,0.1);
            border-bottom: 1px solid rgba(94,92,230,0.2);
        }
        
        .sidebar-menu {
            padding-top: 20px;
        }
        
        .sidebar-menu .nav-link {
            color: rgba(229,229,231,0.7);
            padding: 12px 20px;
            margin: 5px 15px;
            border-radius: 8px;
            transition: all 0.3s;
            font-weight: 500;
        }
        
        .sidebar-menu .nav-link:hover, .sidebar-menu .nav-link.active {
            background: linear-gradient(90deg, rgba(94,92,230,0.3) 0%, rgba(10,132,255,0.2) 100%);
            color: var(--accent);
            transform: translateX(5px);
        }
        
        .sidebar-menu .nav-link i {
            margin-right: 10px;
            font-size: 1.2rem;
            width: 25px;
            text-align: center;
        }
        
        /* Main Content */
        #content {
            margin-left: 250px;
            padding: 20px;
            min-height: 100vh;
        }
        
        /* Top Bar */
        .top-bar {
            background: rgba(28,28,30,0.8);
            backdrop-filter: blur(10px);
            border-bottom: 1px solid rgba(94,92,230,0.2);
            padding: 15px 25px;
            border-radius: 12px;
            margin-bottom: 25px;
        }
        
        /* Cards */
        .card {
            background: rgba(28,28,30,0.7);
            border: 1px solid rgba(94,92,230,0.15);
            border-radius: 16px;
            backdrop-filter: blur(10px);
            box-shadow: 0 8px 32px rgba(0,0,0,0.3);
            transition: transform 0.3s, box-shadow 0.3s;
            margin-bottom: 25px;
        }
        
        .card:hover {
            transform: translateY(-5px);
            box-shadow: 0 12px 40px rgba(94,92,230,0.25);
        }
        
        .card-header {
            background: linear-gradient(90deg, rgba(94,92,230,0.2) 0%, rgba(10,132,255,0.15) 100%);
            border-bottom: 1px solid rgba(94,92,230,0.15);
            padding: 15px 20px;
            border-radius: 16px 16px 0 0 !important;
            font-weight: 600;
        }
        
        /* Buttons */
        .btn-primary {
            background: linear-gradient(90deg, var(--primary) 0%, var(--secondary) 100%);
            border: none;
            border-radius: 8px;
            font-weight: 600;
        }
        
        .btn-outline-primary {
            border: 1px solid var(--primary);
            color: var(--primary);
            border-radius: 8px;
            font-weight: 600;
        }
        
        .btn-outline-primary:hover {
            background: linear-gradient(90deg, var(--primary) 0%, var(--secondary) 100%);
        }
        
        /* Data Table */
        .dataTables_wrapper {
            padding: 0 15px 15px 15px;
        }
        
        .dataTables_filter input {
            background: rgba(28,28,30,0.5);
            border: 1px solid rgba(94,92,230,0.2);
            color: white;
            border-radius: 8px;
            padding: 8px 15px;
        }
        
        .dataTables_length select {
            background: rgba(28,28,30,0.5);
            border: 1px solid rgba(94,92,230,0.2);
            color: white;
            border-radius: 8px;
            padding: 5px;
        }
        
        /* Stats Cards */
        .stat-card {
            text-align: center;
            padding: 20px;
            border-radius: 16px;
            background: rgba(28,28,30,0.7);
            border: 1px solid rgba(94,92,230,0.15);
            transition: all 0.3s;
        }
        
        .stat-card:hover {
            transform: translateY(-5px);
            border-color: var(--accent);
        }
        
        .stat-card i {
            font-size: 2.5rem;
            margin-bottom: 15px;
            background: linear-gradient(90deg, var(--primary) 0%, var(--secondary) 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }
        
        .stat-card .value {
            font-size: 2rem;
            font-weight: 700;
            margin: 10px 0;
            background: linear-gradient(90deg, var(--accent) 0%, var(--success) 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }
        
        /* Toasts */
        .toast {
            background: rgba(28,28,30,0.9);
            border: 1px solid rgba(94,92,230,0.3);
            border-left: 4px solid var(--success);
            backdrop-filter: blur(10px);
            border-radius: 8px;
        }
        
        .toast-header {
            background: rgba(28,28,30,0.7);
            color: var(--success);
            border-bottom: 1px solid rgba(94,92,230,0.2);
        }
        
        /* Modal */
        .modal-content {
            background: rgba(28,28,30,0.95);
            border: 1px solid rgba(94,92,230,0.3);
            border-radius: 16px;
            backdrop-filter: blur(10px);
        }
        
        .modal-header {
            border-bottom: 1px solid rgba(94,92,230,0.2);
        }
        
        /* Form Elements */
        .form-control, .form-select {
            background: rgba(28,28,30,0.7);
            border: 1px solid rgba(94,92,230,0.2);
            color: white;
            border-radius: 8px;
            padding: 10px 15px;
        }
        
        .form-control:focus, .form-select:focus {
            background: rgba(28,28,30,0.8);
            border-color: var(--accent);
            box-shadow: 0 0 0 0.25rem rgba(0, 217, 255, 0.25);
            color: white;
        }
        
        /* Neon Elements */
        .neon-border {
            position: relative;
        }
        
        .neon-border::before {
            content: '';
            position: absolute;
            top: -2px;
            left: -2px;
            right: -2px;
            bottom: -2px;
            background: linear-gradient(45deg, var(--primary), var(--accent), var(--secondary), var(--accent));
            z-index: -1;
            border-radius: 18px;
            filter: blur(5px);
        }
        
        /* Animations */
        @keyframes pulse {
            0% { box-shadow: 0 0 0 0 rgba(0, 217, 255, 0.4); }
            70% { box-shadow: 0 0 0 10px rgba(0, 217, 255, 0); }
            100% { box-shadow: 0 0 0 0 rgba(0, 217, 255, 0); }
        }
        
        .pulse {
            animation: pulse 2s infinite;
        }
        
        /* Patient Lookup */
        .patient-lookup {
            position: relative;
        }
        
        .lookup-results {
            position: absolute;
            top: 100%;
            left: 0;
            right: 0;
            background: rgba(28,28,30,0.95);
            border: 1px solid rgba(94,92,230,0.3);
            border-radius: 0 0 12px 12px;
            max-height: 300px;
            overflow-y: auto;
            z-index: 1000;
            display: none;
        }
        
        .lookup-item {
            padding: 12px 15px;
            border-bottom: 1px solid rgba(94,92,230,0.1);
            cursor: pointer;
            transition: all 0.2s;
        }
        
        .lookup-item:hover {
            background: rgba(94,92,230,0.15);
        }
        
        .lookup-item:last-child {
            border-bottom: none;
        }
        
        .lookup-item .patient-id {
            font-size: 0.85rem;
            color: var(--accent);
        }
        
        /* Medical Note Styles */
        .note-card {
            border-left: 4px solid var(--primary);
            background: rgba(28,28,30,0.6);
            border-radius: 8px;
            padding: 15px;
            margin-bottom: 15px;
            transition: all 0.3s;
        }
        
        .note-card:hover {
            transform: translateX(5px);
            background: rgba(28,28,30,0.8);
        }
        
        .note-card.critical {
            border-left-color: var(--danger);
        }
        
        .note-card.warning {
            border-left-color: var(--warning);
        }
        
        .note-card.success {
            border-left-color: var(--success);
        }
        
        .note-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 10px;
        }
        
        .note-tag {
            padding: 3px 10px;
            border-radius: 20px;
            font-size: 0.75rem;
            font-weight: 600;
        }
        
        .tag-diagnosis {
            background: rgba(48, 209, 88, 0.15);
            color: var(--success);
        }
        
        .tag-treatment {
            background: rgba(10, 132, 255, 0.15);
            color: var(--primary);
        }
        
        .tag-symptom {
            background: rgba(255, 159, 10, 0.15);
            color: var(--warning);
        }
        
        .tag-critical {
            background: rgba(255, 55, 95, 0.15);
            color: var(--danger);
        }
        
        .note-content {
            line-height: 1.6;
        }
        
        /* Timeline */
        .timeline {
            position: relative;
            padding-left: 30px;
            margin-left: 15px;
        }
        
        .timeline::before {
            content: '';
            position: absolute;
            left: 7px;
            top: 0;
            bottom: 0;
            width: 2px;
            background: linear-gradient(to bottom, var(--primary), var(--accent));
        }
        
        .timeline-item {
            position: relative;
            margin-bottom: 30px;
        }
        
        .timeline-item::before {
            content: '';
            position: absolute;
            left: -30px;
            top: 5px;
            width: 16px;
            height: 16px;
            border-radius: 50%;
            background: var(--primary);
            border: 3px solid var(--darker);
        }
        
        .timeline-date {
            font-size: 0.9rem;
            color: var(--accent);
            margin-bottom: 5px;
        }
        
        /* Responsive */
        @media (max-width: 768px) {
            #sidebar {
                width: 100%;
                height: auto;
                position: relative;
            }
            
            #content {
                margin-left: 0;
            }
            
            .top-bar {
                padding: 10px 15px;
            }
        }
    </style>
</head>
<body>
    <!-- Sidebar -->
    <div id="sidebar" class="d-flex flex-column">
        <div class="sidebar-header">
            <h3 class="futuristic-font mb-0"><i class="fas fa-heartbeat me-2"></i>MediSync</h3>
            <p class="text-muted mb-0">Medical Notes Management</p>
        </div>
        
        <ul class="nav flex-column sidebar-menu">
            <li class="nav-item">
                <a class="nav-link" href="#"><i class="fas fa-tachometer-alt"></i> Dashboard</a>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="#"><i class="fas fa-user-injured"></i> Patients</a>
            </li>
            <li class="nav-item">
                <a class="nav-link active" href="#"><i class="fas fa-file-medical"></i> Medical Notes</a>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="#"><i class="fas fa-calendar-check"></i> Appointments</a>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="#"><i class="fas fa-procedures"></i> Admissions</a>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="#"><i class="fas fa-vial"></i> Laboratory</a>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="#"><i class="fas fa-prescription-bottle-alt"></i> Pharmacy</a>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="#"><i class="fas fa-file-invoice-dollar"></i> Accounts</a>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="#"><i class="fas fa-cog"></i> Settings</a>
            </li>
        </ul>
        
        <div class="mt-auto p-3 text-center">
            <div class="btn-group">
                <button class="btn btn-sm btn-outline-primary"><i class="fas fa-sync-alt"></i></button>
                <button class="btn btn-sm btn-outline-primary"><i class="fas fa-question-circle"></i></button>
                <button class="btn btn-sm btn-primary"><i class="fas fa-sign-out-alt"></i> Logout</button>
            </div>
        </div>
    </div>

    <!-- Main Content -->
    <div id="content">
        <!-- Top Bar -->
        <div class="top-bar d-flex justify-content-between align-items-center">
            <div>
                <h4 class="futuristic-font mb-0"><i class="fas fa-file-medical me-2"></i> Medical Notes</h4>
                <p class="text-muted mb-0">Comprehensive patient medical records</p>
            </div>
            <div class="d-flex align-items-center">
                <div class="me-3">
                    <button class="btn btn-primary"><i class="fas fa-plus me-1"></i> New Note</button>
                </div>
                <div class="dropdown me-3">
                    <button class="btn btn-outline-primary dropdown-toggle" type="button" data-bs-toggle="dropdown">
                        <i class="fas fa-filter me-2"></i> Filters
                    </button>
                    <ul class="dropdown-menu dropdown-menu-end">
                        <li><a class="dropdown-item" href="#"><i class="fas fa-stethoscope me-2"></i> Diagnosis</a></li>
                        <li><a class="dropdown-item" href="#"><i class="fas fa-pills me-2"></i> Treatment</a></li>
                        <li><a class="dropdown-item" href="#"><i class="fas fa-exclamation-triangle me-2"></i> Symptoms</a></li>
                        <li><a class="dropdown-item" href="#"><i class="fas fa-notes-medical me-2"></i> All Notes</a></li>
                    </ul>
                </div>
                <div class="dropdown">
                    <button class="btn btn-outline-primary dropdown-toggle" type="button" data-bs-toggle="dropdown">
                        <i class="fas fa-user-circle me-2"></i> Dr. Anderson
                    </button>
                    <ul class="dropdown-menu dropdown-menu-end">
                        <li><a class="dropdown-item" href="#"><i class="fas fa-user me-2"></i> Profile</a></li>
                        <li><a class="dropdown-item" href="#"><i class="fas fa-cog me-2"></i> Settings</a></li>
                        <li><hr class="dropdown-divider"></li>
                        <li><a class="dropdown-item" href="#"><i class="fas fa-sign-out-alt me-2"></i> Logout</a></li>
                    </ul>
                </div>
            </div>
        </div>
        
        <!-- Patient Lookup -->
        <div class="card mb-4">
            <div class="card-header">
                <h5 class="mb-0"><i class="fas fa-search me-2"></i> Patient Lookup</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-8">
                        <div class="patient-lookup">
                            <div class="input-group">
                                <span class="input-group-text"><i class="fas fa-user-injured"></i></span>
                                <input type="text" class="form-control" id="patientSearch" placeholder="Search patients by name, ID, or contact info..." autocomplete="off">
                                <button class="btn btn-primary"><i class="fas fa-search me-1"></i> Search</button>
                            </div>
                            <div class="lookup-results" id="lookupResults">
                                <!-- Results will be populated by JavaScript -->
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="d-flex justify-content-end">
                            <button class="btn btn-outline-primary me-2"><i class="fas fa-sync-alt me-1"></i> Refresh</button>
                            <button class="btn btn-outline-primary"><i class="fas fa-qrcode me-1"></i> Scan ID</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Selected Patient Info -->
        <div class="card mb-4" id="patientInfoCard">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="flex-shrink-0 me-3">
                        <div class="avatar bg-primary rounded-circle d-flex align-items-center justify-content-center" style="width: 80px; height: 80px;">
                            <i class="fas fa-user fa-2x"></i>
                        </div>
                    </div>
                    <div class="flex-grow-1">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h4 class="mb-1">Sarah Wilson</h4>
                                <div class="d-flex mb-2">
                                    <span class="badge bg-primary me-2">ID: P-10248</span>
                                    <span class="badge bg-success me-2">29 years</span>
                                    <span class="badge bg-info">Female</span>
                                </div>
                                <p class="mb-1"><i class="fas fa-phone me-2"></i> (555) 123-4567</p>
                                <p class="mb-0"><i class="fas fa-envelope me-2"></i> sarah.w@example.com</p>
                            </div>
                            <div class="text-end">
                                <p class="mb-1"><i class="fas fa-heartbeat me-2 text-danger"></i> Blood Type: O+</p>
                                <p class="mb-0"><i class="fas fa-allergies me-2 text-warning"></i> Allergies: Penicillin, Latex</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="card-footer bg-transparent border-top border-secondary">
                <div class="d-flex justify-content-between">
                    <div>
                        <span class="me-3"><i class="fas fa-calendar-plus me-1"></i> Last Visit: 2023-10-16</span>
                        <span><i class="fas fa-file-medical me-1"></i> 24 Medical Notes</span>
                    </div>
                    <div>
                        <button class="btn btn-sm btn-outline-primary me-2"><i class="fas fa-history me-1"></i> Medical History</button>
                        <button class="btn btn-sm btn-primary"><i class="fas fa-file-medical me-1"></i> Add New Note</button>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Medical Notes Timeline -->
        <div class="row">
            <div class="col-lg-8">
                <div class="card">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h5 class="mb-0"><i class="fas fa-clipboard-list me-2"></i> Medical Notes Timeline</h5>
                        <div class="d-flex">
                            <input type="text" class="form-control form-control-sm me-2" placeholder="Search notes..." style="width: 200px;">
                            <button class="btn btn-sm btn-outline-primary me-2"><i class="fas fa-filter me-1"></i> Filter</button>
                            <button class="btn btn-sm btn-outline-primary"><i class="fas fa-sort me-1"></i> Sort</button>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="timeline">
                            <!-- Today -->
                            <div class="timeline-item">
                                <div class="timeline-date">Today, 10:45 AM <span class="badge bg-danger">Critical</span></div>
                                <div class="note-card critical">
                                    <div class="note-header">
                                        <div>
                                            <h6 class="mb-0">Severe Allergic Reaction</h6>
                                            <div class="text-muted">Dr. Anderson</div>
                                        </div>
                                        <span class="note-tag tag-critical">Emergency</span>
                                    </div>
                                    <div class="note-content">
                                        <p>Patient presented with acute dyspnea, facial swelling, and urticaria after suspected exposure to peanuts. Administered epinephrine 0.3mg IM. Oxygen saturation at 92% on room air. Transferred to ER for observation.</p>
                                        <div class="mt-2">
                                            <span class="badge bg-danger me-1">Anaphylaxis</span>
                                            <span class="badge bg-warning me-1">Dyspnea</span>
                                            <span class="badge bg-info me-1">Urticaria</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Yesterday -->
                            <div class="timeline-item">
                                <div class="timeline-date">Yesterday, 3:20 PM</div>
                                <div class="note-card">
                                    <div class="note-header">
                                        <div>
                                            <h6 class="mb-0">Follow-up Consultation</h6>
                                            <div class="text-muted">Dr. Roberts</div>
                                        </div>
                                        <span class="note-tag tag-treatment">Treatment</span>
                                    </div>
                                    <div class="note-content">
                                        <p>Patient reports improvement in migraine symptoms since starting new medication regimen. Frequency decreased from 4/week to 1/week. Mild nausea reported as side effect. Continue current treatment plan and reassess in 4 weeks.</p>
                                        <ul class="mt-2">
                                            <li>Continue Topiramate 50mg BID</li>
                                            <li>Add Ondansetron 4mg PRN for nausea</li>
                                            <li>Recommend stress reduction techniques</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Last Week -->
                            <div class="timeline-item">
                                <div class="timeline-date">Oct 10, 2023, 11:15 AM</div>
                                <div class="note-card">
                                    <div class="note-header">
                                        <div>
                                            <h6 class="mb-0">Annual Physical Examination</h6>
                                            <div class="text-muted">Dr. Anderson</div>
                                        </div>
                                        <span class="note-tag tag-diagnosis">Diagnosis</span>
                                    </div>
                                    <div class="note-content">
                                        <p>Comprehensive physical exam. Patient in good health with no acute issues. Blood pressure 118/76, heart rate 72 bpm. BMI 22.3. Labs ordered: CBC, metabolic panel, lipid profile. Discussed lifestyle modifications for migraine management.</p>
                                        <div class="mt-2">
                                            <span class="badge bg-success me-1">Vitals Normal</span>
                                            <span class="badge bg-primary me-1">Preventive Care</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Older -->
                            <div class="timeline-item">
                                <div class="timeline-date">Sep 28, 2023, 2:30 PM</div>
                                <div class="note-card warning">
                                    <div class="note-header">
                                        <div>
                                            <h6 class="mb-0">Migraine Management</h6>
                                            <div class="text-muted">Dr. Roberts</div>
                                        </div>
                                        <span class="note-tag tag-symptom">Symptom</span>
                                    </div>
                                    <div class="note-content">
                                        <p>Patient reports increased migraine frequency (4/week) with photophobia and nausea. Previous treatment with NSAIDs ineffective. Neurological exam normal. Prescribed Topiramate 25mg BID, titrating to 50mg after 1 week. Advised headache diary.</p>
                                        <div class="mt-2">
                                            <span class="badge bg-warning me-1">Migraine</span>
                                            <span class="badge bg-info me-1">Photophobia</span>
                                            <span class="badge bg-secondary me-1">Nausea</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Patient Summary & Actions -->
            <div class="col-lg-4">
                <div class="card mb-4">
                    <div class="card-header">
                        <h5 class="mb-0"><i class="fas fa-user-injured me-2"></i> Patient Summary</h5>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <h6>Medical Conditions</h6>
                            <div class="d-flex flex-wrap">
                                <span class="badge bg-danger me-1 mb-1">Migraines</span>
                                <span class="badge bg-warning me-1 mb-1">Seasonal Allergies</span>
                                <span class="badge bg-info me-1 mb-1">Asthma (Mild)</span>
                            </div>
                        </div>
                        
                        <div class="mb-3">
                            <h6>Current Medications</h6>
                            <ul class="list-group list-group-flush">
                                <li class="list-group-item bg-transparent text-light border-secondary d-flex justify-content-between">
                                    <span>Topiramate</span>
                                    <span>50mg BID</span>
                                </li>
                                <li class="list-group-item bg-transparent text-light border-secondary d-flex justify-content-between">
                                    <span>Fluticasone</span>
                                    <span>1 spray daily</span>
                                </li>
                                <li class="list-group-item bg-transparent text-light border-secondary d-flex justify-content-between">
                                    <span>Albuterol</span>
                                    <span>PRN</span>
                                </li>
                            </ul>
                        </div>
                        
                        <div>
                            <h6>Recent Lab Results</h6>
                            <div class="table-responsive">
                                <table class="table table-sm table-borderless">
                                    <thead>
                                        <tr>
                                            <th>Test</th>
                                            <th>Result</th>
                                            <th>Status</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td>CBC</td>
                                            <td>Normal</td>
                                            <td><span class="badge bg-success">Complete</span></td>
                                        </tr>
                                        <tr>
                                            <td>Lipid Panel</td>
                                            <td>Chol: 192</td>
                                            <td><span class="badge bg-success">Complete</span></td>
                                        </tr>
                                        <tr>
                                            <td>Allergy Panel</td>
                                            <td>Pending</td>
                                            <td><span class="badge bg-warning">Processing</span></td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0"><i class="fas fa-bolt me-2"></i> Quick Actions</h5>
                    </div>
                    <div class="card-body">
                        <div class="d-grid gap-2">
                            <button class="btn btn-primary mb-2"><i class="fas fa-file-medical me-2"></i> Create New Note</button>
                            <button class="btn btn-outline-primary mb-2"><i class="fas fa-prescription me-2"></i> Prescribe Medication</button>
                            <button class="btn btn-outline-primary mb-2"><i class="fas fa-vial me-2"></i> Order Lab Test</button>
                            <button class="btn btn-outline-primary mb-2"><i class="fas fa-calendar-plus me-2"></i> Schedule Follow-up</button>
                            <button class="btn btn-outline-primary mb-2"><i class="fas fa-share-alt me-2"></i> Share Records</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Add Medical Note Modal -->
    <div class="modal fade" id="addNoteModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><i class="fas fa-file-medical me-2"></i> New Medical Note</h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form>
                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label class="form-label">Patient</label>
                                <input type="text" class="form-control" value="Sarah Wilson (P-10248)" readonly>
                            </div>
                            <div class="col-md-3">
                                <label class="form-label">Date</label>
                                <input type="date" class="form-control" value="2023-10-16">
                            </div>
                            <div class="col-md-3">
                                <label class="form-label">Time</label>
                                <input type="time" class="form-control" value="10:45">
                            </div>
                        </div>
                        
                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label class="form-label">Note Type</label>
                                <select class="form-select">
                                    <option>Consultation</option>
                                    <option selected>Emergency</option>
                                    <option>Follow-up</option>
                                    <option>Procedure</option>
                                    <option>Lab Result</option>
                                </select>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Priority</label>
                                <select class="form-select">
                                    <option>Routine</option>
                                    <option>Urgent</option>
                                    <option selected>Critical</option>
                                </select>
                            </div>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">Diagnosis/Reason</label>
                            <input type="text" class="form-control" value="Anaphylactic reaction">
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">Clinical Notes</label>
                            <textarea class="form-control" rows="6">Patient presented with acute dyspnea, facial swelling, and urticaria 30 minutes after consuming a protein bar. Symptoms began within 10 minutes of ingestion. Patient self-administered epinephrine auto-injector prior to arrival. Observed: respiratory distress, O2 sat 92% on room air, BP 90/60, HR 110. Administered supplemental oxygen and IV fluids. Symptoms improved after second dose of epinephrine. Transferred to ER for observation.</textarea>
                        </div>
                        
                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label class="form-label">Tags</label>
                                <select class="form-select" multiple>
                                    <option selected>Emergency</option>
                                    <option selected>Anaphylaxis</option>
                                    <option>Allergic Reaction</option>
                                    <option>Respiratory Distress</option>
                                    <option>Epinephrine</option>
                                </select>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Attending Physician</label>
                                <input type="text" class="form-control" value="Dr. Anderson">
                                <div class="form-text">Add co-signers if applicable</div>
                            </div>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">Attachments</label>
                            <div class="border rounded p-3">
                                <div class="d-flex justify-content-between align-items-center mb-2">
                                    <div>
                                        <i class="fas fa-file-medical me-2"></i> allergy-test-2023.pdf
                                    </div>
                                    <button class="btn btn-sm btn-outline-danger"><i class="fas fa-times"></i></button>
                                </div>
                                <button class="btn btn-sm btn-outline-primary"><i class="fas fa-plus me-1"></i> Add Attachment</button>
                            </div>
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="button" class="btn btn-primary">Save Medical Note</button>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Toast Container -->
    <div class="toast-container position-fixed bottom-0 end-0 p-3">
        <div class="toast" role="alert" aria-live="assertive" aria-atomic="true" data-bs-autohide="false">
            <div class="toast-header">
                <strong class="me-auto"><i class="fas fa-check-circle me-2"></i> Success</strong>
                <small>Just now</small>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="toast" aria-label="Close"></button>
            </div>
            <div class="toast-body">
                Medical note saved successfully.
            </div>
        </div>
    </div>

    <!-- Scripts -->
    <script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
    
    <script>
        $(document).ready(function() {
            // Patient lookup functionality
            const patients = [
                {id: "P-10245", name: "John Smith", age: 42, gender: "Male", lastVisit: "2023-10-15"},
                {id: "P-10246", name: "Emily Johnson", age: 35, gender: "Female", lastVisit: "2023-10-14"},
                {id: "P-10247", name: "Robert Davis", age: 68, gender: "Male", lastVisit: "2023-09-22"},
                {id: "P-10248", name: "Sarah Wilson", age: 29, gender: "Female", lastVisit: "2023-10-16"},
                {id: "P-10249", name: "Michael Brown", age: 51, gender: "Male", lastVisit: "2023-10-15"},
                {id: "P-10250", name: "Lisa Taylor", age: 45, gender: "Female", lastVisit: "2023-10-12"},
                {id: "P-10251", name: "David Miller", age: 33, gender: "Male", lastVisit: "2023-10-11"},
                {id: "P-10252", name: "Jennifer Wilson", age: 28, gender: "Female", lastVisit: "2023-10-10"}
            ];
            
            $('#patientSearch').on('input', function() {
                const searchTerm = $(this).val().toLowerCase();
                const results = patients.filter(patient => 
                    patient.name.toLowerCase().includes(searchTerm) || 
                    patient.id.toLowerCase().includes(searchTerm)
                
                const resultsContainer = $('#lookupResults');
                resultsContainer.empty();
                
                if (searchTerm.length > 0 && results.length > 0) {
                    results.forEach(patient => {
                        resultsContainer.append(`
                            <div class="lookup-item" data-id="${patient.id}">
                                <div class="d-flex justify-content-between">
                                    <div>
                                        <strong>${patient.name}</strong>
                                        <div class="patient-id">${patient.id}</div>
                                    </div>
                                    <div>
                                        <span class="badge bg-info">${patient.gender}, ${patient.age} yrs</span>
                                        <div class="text-muted small">Last visit: ${patient.lastVisit}</div>
                                    </div>
                                </div>
                            </div>
                        `);
                    });
                    resultsContainer.show();
                } else if (searchTerm.length > 0) {
                    resultsContainer.append(`<div class="lookup-item text-center">No patients found</div>`);
                    resultsContainer.show();
                } else {
                    resultsContainer.hide();
                }
            });
            
            $(document).on('click', '.lookup-item', function() {
                const patientId = $(this).data('id');
                const patient = patients.find(p => p.id === patientId);
                
                if (patient) {
                    $('#patientSearch').val(patient.name);
                    $('#lookupResults').hide();
                    
                    // Update patient info card
                    $('#patientInfoCard h4').text(patient.name);
                    $('#patientInfoCard .badge:eq(0)').text(`ID: ${patient.id}`);
                    $('#patientInfoCard .badge:eq(1)').text(`${patient.age} years`);
                    
                    // Show toast notification
                    $('.toast-body').html(`Patient <strong>${patient.name}</strong> selected. Loading medical records...`);
                    $('.toast').toast('show');
                }
            });
            
            $(document).on('click', function(e) {
                if (!$(e.target).closest('.patient-lookup').length) {
                    $('#lookupResults').hide();
                }
            });
            
            // Show modal on button click
            $('.btn-primary:contains("New Note")').on('click', function() {
                $('#addNoteModal').modal('show');
            });
            
            // Pulse animation for critical notes
            setInterval(() => {
                $('.critical .note-header').toggleClass('pulse');
            }, 2000);
        });
    </script>
</body>
</html>