<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>MediSync - Morgue Management</title>
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <!-- DataTables -->
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap5.min.css">
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@300;400;500;600;700&family=Orbitron:wght@400;500;600;700&display=swap" rel="stylesheet">
    <style>
        :root {
            --primary: #0a84ff;
            --secondary: #5e5ce6;
            --accent: #00d9ff;
            --success: #30d158;
            --warning: #ff9f0a;
            --danger: #ff375f;
            --dark: #1c1c1e;
            --darker: #121214;
            --light: #f5f5f7;
            --morgue: #6a0dad;
        }
        
        body {
            background-color: #121214;
            color: #e5e5e7;
            font-family: 'Candara', 'Montserrat', sans-serif;
            overflow-x: hidden;
            height: 100vh;
        }
        
        .futuristic-font {
            font-family:  'Montserrat', sans-serif;
            letter-spacing: 1px;
        }
        
        /* Custom Scrollbar */
        ::-webkit-scrollbar {
            width: 8px;
        }
        ::-webkit-scrollbar-track {
            background: var(--darker);
        }
        ::-webkit-scrollbar-thumb {
            background: var(--morgue);
            border-radius: 4px;
        }
        
        /* Sidebar */
        #sidebar {
            background: linear-gradient(180deg, var(--darker) 0%, rgba(28,28,30,0.95) 100%);
            border-right: 1px solid rgba(94,92,230,0.2);
            height: 100vh;
            position: fixed;
            transition: all 0.3s;
            z-index: 1000;
            box-shadow: 0 0 20px rgba(0,0,0,0.5);
        }
        
        .sidebar-header {
            padding: 20px;
            background: rgba(106, 13, 173, 0.2);
            border-bottom: 1px solid rgba(94,92,230,0.2);
        }
        
        .sidebar-menu {
            padding-top: 20px;
        }
        
        .sidebar-menu .nav-link {
            color: rgba(229,229,231,0.7);
            padding: 12px 20px;
            margin: 5px 15px;
            border-radius: 8px;
            transition: all 0.3s;
            font-weight: 500;
        }
        
        .sidebar-menu .nav-link:hover, .sidebar-menu .nav-link.active {
            background: linear-gradient(90deg, rgba(106, 13, 173, 0.3) 0%, rgba(10,132,255,0.2) 100%);
            color: var(--accent);
            transform: translateX(5px);
        }
        
        .sidebar-menu .nav-link i {
            margin-right: 10px;
            font-size: 1.2rem;
            width: 25px;
            text-align: center;
        }
        
        /* Main Content */
        #content {
            margin-left: 250px;
            padding: 20px;
            min-height: 100vh;
        }
        
        /* Top Bar */
        .top-bar {
            background: rgba(28,28,30,0.8);
            backdrop-filter: blur(10px);
            border-bottom: 1px solid rgba(94,92,230,0.2);
            padding: 15px 25px;
            border-radius: 12px;
            margin-bottom: 25px;
        }
        
        /* Cards */
        .card {
            background: rgba(28,28,30,0.7);
            border: 1px solid rgba(106, 13, 173, 0.3);
            border-radius: 16px;
            backdrop-filter: blur(10px);
            box-shadow: 0 8px 32px rgba(0,0,0,0.3);
            transition: transform 0.3s, box-shadow 0.3s;
            margin-bottom: 25px;
        }
        
        .card:hover {
            transform: translateY(-5px);
            box-shadow: 0 12px 40px rgba(106, 13, 173, 0.4);
        }
        
        .card-header {
            background: linear-gradient(90deg, rgba(106, 13, 173, 0.2) 0%, rgba(10,132,255,0.15) 100%);
            border-bottom: 1px solid rgba(106, 13, 173, 0.2);
            padding: 15px 20px;
            border-radius: 16px 16px 0 0 !important;
            font-weight: 600;
        }
        
        /* Buttons */
        .btn-morgue {
            background: linear-gradient(90deg, var(--morgue) 0%, #8a2be2 100%);
            border: none;
            border-radius: 8px;
            font-weight: 600;
            color: white;
        }
        
        .btn-outline-morgue {
            border: 1px solid var(--morgue);
            color: var(--morgue);
            border-radius: 8px;
            font-weight: 600;
        }
        
        .btn-outline-morgue:hover {
            background: linear-gradient(90deg, var(--morgue) 0%, #8a2be2 100%);
            color: white;
        }
        
        /* Data Table */
        .dataTables_wrapper {
            padding: 0 15px 15px 15px;
        }
        
        .dataTables_filter input {
            background: rgba(28,28,30,0.5);
            border: 1px solid rgba(106, 13, 173, 0.3);
            color: white;
            border-radius: 8px;
            padding: 8px 15px;
        }
        
        .dataTables_length select {
            background: rgba(28,28,30,0.5);
            border: 1px solid rgba(106, 13, 173, 0.3);
            color: white;
            border-radius: 8px;
            padding: 5px;
        }
        
        /* Stats Cards */
        .stat-card {
            text-align: center;
            padding: 20px;
            border-radius: 16px;
            background: rgba(28,28,30,0.7);
            border: 1px solid rgba(106, 13, 173, 0.3);
            transition: all 0.3s;
        }
        
        .stat-card:hover {
            transform: translateY(-5px);
            border-color: var(--accent);
        }
        
        .stat-card i {
            font-size: 2.5rem;
            margin-bottom: 15px;
            background: linear-gradient(90deg, var(--morgue) 0%, #8a2be2 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }
        
        .stat-card .value {
            font-size: 2rem;
            font-weight: 700;
            margin: 10px 0;
            background: linear-gradient(90deg, var(--accent) 0%, var(--morgue) 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }
        
        /* Toasts */
        .toast {
            background: rgba(28,28,30,0.9);
            border: 1px solid rgba(106, 13, 173, 0.5);
            border-left: 4px solid var(--morgue);
            backdrop-filter: blur(10px);
            border-radius: 8px;
        }
        
        .toast-header {
            background: rgba(28,28,30,0.7);
            color: var(--morgue);
            border-bottom: 1px solid rgba(106, 13, 173, 0.3);
        }
        
        /* Modal */
        .modal-content {
            background: rgba(28,28,30,0.95);
            border: 1px solid rgba(106, 13, 173, 0.5);
            border-radius: 16px;
            backdrop-filter: blur(10px);
        }
        
        .modal-header {
            border-bottom: 1px solid rgba(106, 13, 173, 0.3);
        }
        
        /* Form Elements */
        .form-control, .form-select {
            background: rgba(28,28,30,0.7);
            border: 1px solid rgba(106, 13, 173, 0.3);
            color: white;
            border-radius: 8px;
            padding: 10px 15px;
        }
        
        .form-control:focus, .form-select:focus {
            background: rgba(28,28,30,0.8);
            border-color: var(--accent);
            box-shadow: 0 0 0 0.25rem rgba(106, 13, 173, 0.25);
            color: white;
        }
        
        /* Status Badges */
        .badge-admitted {
            background: rgba(106, 13, 173, 0.2);
            color: #b19cd9;
        }
        
        .badge-released {
            background: rgba(48, 209, 88, 0.2);
            color: var(--success);
        }
        
        .badge-pending {
            background: rgba(255, 159, 10, 0.2);
            color: var(--warning);
        }
        
        .badge-unidentified {
            background: rgba(150, 150, 150, 0.2);
            color: #ccc;
        }
        
        /* Cold Storage Visualization */
        .storage-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(120px, 1fr));
            gap: 15px;
            margin-top: 20px;
        }
        
        .storage-unit {
            background: rgba(28,28,30,0.8);
            border: 1px solid rgba(106, 13, 173, 0.4);
            border-radius: 8px;
            padding: 15px 10px;
            text-align: center;
            transition: all 0.3s;
            position: relative;
        }
        
        .storage-unit.occupied {
            background: rgba(106, 13, 173, 0.2);
            border-color: var(--morgue);
        }
        
        .storage-unit.occupied::after {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            border-radius: 8px;
            box-shadow: 0 0 15px rgba(106, 13, 173, 0.6);
            opacity: 0;
            transition: opacity 0.3s;
        }
        
        .storage-unit.occupied:hover::after {
            opacity: 1;
        }
        
        .storage-unit .unit-id {
            font-weight: 600;
            margin-bottom: 5px;
            color: var(--morgue);
        }
        
        .storage-unit .status {
            font-size: 0.8rem;
            border-radius: 10px;
            padding: 3px 8px;
            display: inline-block;
        }
        
        /* Morgue Specific Elements */
        .deceased-tag {
            display: inline-block;
            padding: 3px 10px;
            border-radius: 20px;
            font-size: 0.75rem;
            font-weight: 600;
            background: rgba(255, 55, 95, 0.15);
            color: var(--danger);
            margin-right: 5px;
        }
        
        /* Responsive */
        @media (max-width: 768px) {
            #sidebar {
                width: 100%;
                height: auto;
                position: relative;
            }
            
            #content {
                margin-left: 0;
            }
            
            .top-bar {
                padding: 10px 15px;
            }
            
            .storage-grid {
                grid-template-columns: repeat(auto-fill, minmax(100px, 1fr));
            }
        }
    </style>
</head>
<body>
    <!-- Sidebar -->
    <div id="sidebar" class="d-flex flex-column">
        <div class="sidebar-header">
            <h3 class="futuristic-font mb-0"><i class="fas fa-skull me-2"></i>MediSync</h3>
            <p class="text-muted mb-0">Morgue Management System</p>
        </div>
        
        <ul class="nav flex-column sidebar-menu">
            <li class="nav-item">
                <a class="nav-link" href="#"><i class="fas fa-tachometer-alt"></i> Dashboard</a>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="#"><i class="fas fa-user-injured"></i> Patients</a>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="#"><i class="fas fa-file-medical"></i> Medical Notes</a>
            </li>
            <li class="nav-item">
                <a class="nav-link active" href="#"><i class="fas fa-skull"></i> Morgue</a>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="#"><i class="fas fa-calendar-check"></i> Appointments</a>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="#"><i class="fas fa-procedures"></i> Admissions</a>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="#"><i class="fas fa-vial"></i> Laboratory</a>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="#"><i class="fas fa-prescription-bottle-alt"></i> Pharmacy</a>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="#"><i class="fas fa-file-invoice-dollar"></i> Accounts</a>
            </li>
        </ul>
        
        <div class="mt-auto p-3 text-center">
            <div class="btn-group">
                <button class="btn btn-sm btn-outline-morgue"><i class="fas fa-sync-alt"></i></button>
                <button class="btn btn-sm btn-outline-morgue"><i class="fas fa-question-circle"></i></button>
                <button class="btn btn-sm btn-morgue"><i class="fas fa-sign-out-alt"></i> Logout</button>
            </div>
        </div>
    </div>

    <!-- Main Content -->
    <div id="content">
        <!-- Top Bar -->
        <div class="top-bar d-flex justify-content-between align-items-center">
            <div>
                <h4 class="futuristic-font mb-0"><i class="fas fa-skull me-2"></i> Morgue Management</h4>
                <p class="text-muted mb-0">Deceased patient records and storage management</p>
            </div>
            <div class="d-flex align-items-center">
                <div class="me-3">
                    <button class="btn btn-morgue me-2" data-bs-toggle="modal" data-bs-target="#admitModal">
                        <i class="fas fa-plus me-1"></i> New Admission
                    </button>
                    <button class="btn btn-outline-morgue" data-bs-toggle="modal" data-bs-target="#dischargeModal">
                        <i class="fas fa-external-link-alt me-1"></i> Release Corpse
                    </button>
                </div>
                <div class="dropdown">
                    <button class="btn btn-outline-morgue dropdown-toggle" type="button" data-bs-toggle="dropdown">
                        <i class="fas fa-user-circle me-2"></i> Dr. Anderson
                    </button>
                    <ul class="dropdown-menu dropdown-menu-end">
                        <li><a class="dropdown-item" href="#"><i class="fas fa-user me-2"></i> Profile</a></li>
                        <li><a class="dropdown-item" href="#"><i class="fas fa-cog me-2"></i> Settings</a></li>
                        <li><hr class="dropdown-divider"></li>
                        <li><a class="dropdown-item" href="#"><i class="fas fa-sign-out-alt me-2"></i> Logout</a></li>
                    </ul>
                </div>
            </div>
        </div>
        
        <!-- Stats Overview -->
        <div class="row">
            <div class="col-md-3">
                <div class="stat-card">
                    <i class="fas fa-bed"></i>
                    <div class="label">Total Capacity</div>
                    <div class="value">48</div>
                    <div class="text-muted small">Units Available</div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="stat-card">
                    <i class="fas fa-skull"></i>
                    <div class="label">Current Occupancy</div>
                    <div class="value">32</div>
                    <div class="text-danger small">66.7% occupied</div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="stat-card">
                    <i class="fas fa-calendar-day"></i>
                    <div class="label">Today's Admissions</div>
                    <div class="value">4</div>
                    <div class="text-warning small">2 pending autopsy</div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="stat-card">
                    <i class="fas fa-external-link-alt"></i>
                    <div class="label">Pending Releases</div>
                    <div class="value">7</div>
                    <div class="text-success small">3 scheduled today</div>
                </div>
            </div>
        </div>
        
        <!-- Storage Visualization -->
        <div class="card mb-4">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0"><i class="fas fa-warehouse me-2"></i> Cold Storage Units</h5>
                <div class="d-flex">
                    <span class="badge bg-admitted me-2"><i class="fas fa-skull me-1"></i> Occupied: 32</span>
                    <span class="badge bg-secondary"><i class="fas fa-bed me-1"></i> Available: 16</span>
                </div>
            </div>
            <div class="card-body">
                <div class="storage-grid">
                    <div class="storage-unit occupied">
                        <div class="unit-id">A-01</div>
                        <div class="status badge-admitted">Occupied</div>
                        <div class="deceased-id small">C-23001</div>
                    </div>
                    <div class="storage-unit occupied">
                        <div class="unit-id">A-02</div>
                        <div class="status badge-admitted">Occupied</div>
                        <div class="deceased-id small">C-23002</div>
                    </div>
                    <div class="storage-unit">
                        <div class="unit-id">A-03</div>
                        <div class="status badge-released">Available</div>
                    </div>
                    <div class="storage-unit occupied">
                        <div class="unit-id">A-04</div>
                        <div class="status badge-pending">Autopsy</div>
                        <div class="deceased-id small">C-23004</div>
                    </div>
                    <div class="storage-unit occupied">
                        <div class="unit-id">A-05</div>
                        <div class="status badge-admitted">Occupied</div>
                        <div class="deceased-id small">C-23005</div>
                    </div>
                    <div class="storage-unit">
                        <div class="unit-id">A-06</div>
                        <div class="status badge-released">Available</div>
                    </div>
                    <div class="storage-unit occupied">
                        <div class="unit-id">A-07</div>
                        <div class="status badge-unidentified">Unidentified</div>
                    </div>
                    <div class="storage-unit occupied">
                        <div class="unit-id">A-08</div>
                        <div class="status badge-admitted">Occupied</div>
                        <div class="deceased-id small">C-23008</div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Deceased Records -->
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0"><i class="fas fa-clipboard-list me-2"></i> Deceased Records</h5>
                <div>
                    <div class="input-group" style="width: 300px;">
                        <input type="text" class="form-control" placeholder="Search records...">
                        <button class="btn btn-outline-morgue"><i class="fas fa-search"></i></button>
                    </div>
                </div>
            </div>
            <div class="card-body">
                <table id="deceasedTable" class="table table-hover">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Deceased Name</th>
                            <th>Age</th>
                            <th>Gender</th>
                            <th>Cause of Death</th>
                            <th>Admission Date</th>
                            <th>Storage Unit</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>C-23001</td>
                            <td>John Smith</td>
                            <td>72</td>
                            <td>Male</td>
                            <td>Cardiac Arrest</td>
                            <td>2023-10-12</td>
                            <td>A-01</td>
                            <td><span class="badge badge-admitted">Admitted</span></td>
                            <td>
                                <button class="btn btn-sm btn-outline-morgue me-1"><i class="fas fa-info-circle"></i></button>
                                <button class="btn btn-sm btn-outline-warning me-1"><i class="fas fa-edit"></i></button>
                                <button class="btn btn-sm btn-outline-danger"><i class="fas fa-trash"></i></button>
                            </td>
                        </tr>
                        <tr>
                            <td>C-23002</td>
                            <td>Mary Johnson</td>
                            <td>68</td>
                            <td>Female</td>
                            <td>Cerebral Hemorrhage</td>
                            <td>2023-10-13</td>
                            <td>A-02</td>
                            <td><span class="badge badge-admitted">Admitted</span></td>
                            <td>
                                <button class="btn btn-sm btn-outline-morgue me-1"><i class="fas fa-info-circle"></i></button>
                                <button class="btn btn-sm btn-outline-warning me-1"><i class="fas fa-edit"></i></button>
                                <button class="btn btn-sm btn-outline-danger"><i class="fas fa-trash"></i></button>
                            </td>
                        </tr>
                        <tr>
                            <td>C-23004</td>
                            <td>Robert Davis</td>
                            <td>55</td>
                            <td>Male</td>
                            <td>Trauma (MVA)</td>
                            <td>2023-10-15</td>
                            <td>A-04</td>
                            <td><span class="badge badge-pending">Awaiting Autopsy</span></td>
                            <td>
                                <button class="btn btn-sm btn-outline-morgue me-1"><i class="fas fa-info-circle"></i></button>
                                <button class="btn btn-sm btn-outline-warning me-1"><i class="fas fa-edit"></i></button>
                                <button class="btn btn-sm btn-outline-danger"><i class="fas fa-trash"></i></button>
                            </td>
                        </tr>
                        <tr>
                            <td>C-23005</td>
                            <td>Sarah Wilson</td>
                            <td>62</td>
                            <td>Female</td>
                            <td>Pulmonary Embolism</td>
                            <td>2023-10-15</td>
                            <td>A-05</td>
                            <td><span class="badge badge-admitted">Admitted</span></td>
                            <td>
                                <button class="btn btn-sm btn-outline-morgue me-1"><i class="fas fa-info-circle"></i></button>
                                <button class="btn btn-sm btn-outline-warning me-1"><i class="fas fa-edit"></i></button>
                                <button class="btn btn-sm btn-outline-danger"><i class="fas fa-trash"></i></button>
                            </td>
                        </tr>
                        <tr>
                            <td>C-23007</td>
                            <td>Unknown Male</td>
                            <td>~45</td>
                            <td>Male</td>
                            <td>Unknown</td>
                            <td>2023-10-14</td>
                            <td>A-07</td>
                            <td><span class="badge badge-unidentified">Unidentified</span></td>
                            <td>
                                <button class="btn btn-sm btn-outline-morgue me-1"><i class="fas fa-info-circle"></i></button>
                                <button class="btn btn-sm btn-outline-warning me-1"><i class="fas fa-edit"></i></button>
                                <button class="btn btn-sm btn-outline-danger"><i class="fas fa-trash"></i></button>
                            </td>
                        </tr>
                        <tr>
                            <td>C-23008</td>
                            <td>Michael Brown</td>
                            <td>79</td>
                            <td>Male</td>
                            <td>Renal Failure</td>
                            <td>2023-10-16</td>
                            <td>A-08</td>
                            <td><span class="badge badge-admitted">Admitted</span></td>
                            <td>
                                <button class="btn btn-sm btn-outline-morgue me-1"><i class="fas fa-info-circle"></i></button>
                                <button class="btn btn-sm btn-outline-warning me-1"><i class="fas fa-edit"></i></button>
                                <button class="btn btn-sm btn-outline-danger"><i class="fas fa-trash"></i></button>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    
    <!-- Corpse Admission Modal -->
    <div class="modal fade" id="admitModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><i class="fas fa-plus me-2"></i> New Corpse Admission</h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form>
                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label class="form-label">First Name</label>
                                <input type="text" class="form-control">
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Last Name</label>
                                <input type="text" class="form-control">
                            </div>
                        </div>
                        
                        <div class="row mb-3">
                            <div class="col-md-3">
                                <label class="form-label">Date of Birth</label>
                                <input type="date" class="form-control">
                            </div>
                            <div class="col-md-3">
                                <label class="form-label">Gender</label>
                                <select class="form-select">
                                    <option>Male</option>
                                    <option>Female</option>
                                    <option>Unknown</option>
                                </select>
                            </div>
                            <div class="col-md-3">
                                <label class="form-label">Date of Death</label>
                                <input type="date" class="form-control">
                            </div>
                            <div class="col-md-3">
                                <label class="form-label">Time of Death</label>
                                <input type="time" class="form-control">
                            </div>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">Cause of Death</label>
                            <input type="text" class="form-control" placeholder="Primary cause">
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">Secondary Factors</label>
                            <textarea class="form-control" rows="2" placeholder="Contributing conditions or factors"></textarea>
                        </div>
                        
                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label class="form-label">Referring Physician</label>
                                <input type="text" class="form-control">
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Admitting Staff</label>
                                <input type="text" class="form-control" value="Dr. Anderson" readonly>
                            </div>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">Storage Location</label>
                            <div class="row">
                                <div class="col-md-6">
                                    <select class="form-select">
                                        <option>Select Storage Unit</option>
                                        <option>A-03 (Available)</option>
                                        <option>A-06 (Available)</option>
                                        <option>B-02 (Available)</option>
                                        <option>C-04 (Available)</option>
                                    </select>
                                </div>
                                <div class="col-md-6">
                                    <select class="form-select">
                                        <option>Refrigeration Type</option>
                                        <option>Standard Refrigeration</option>
                                        <option>Cryonic Preservation</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">Personal Effects</label>
                            <textarea class="form-control" rows="2" placeholder="List any personal items received with the body"></textarea>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">Autopsy Required</label>
                            <div class="form-check">
                                <input class="form-check-input" type="radio" name="autopsy" id="autopsyYes">
                                <label class="form-check-label" for="autopsyYes">
                                    Yes
                                </label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="radio" name="autopsy" id="autopsyNo" checked>
                                <label class="form-check-label" for="autopsyNo">
                                    No
                                </label>
                            </div>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">Next of Kin Information</label>
                            <div class="row">
                                <div class="col-md-6">
                                    <input type="text" class="form-control mb-2" placeholder="Name">
                                </div>
                                <div class="col-md-6">
                                    <input type="tel" class="form-control mb-2" placeholder="Contact Number">
                                </div>
                                <div class="col-md-12">
                                    <input type="text" class="form-control" placeholder="Relationship">
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="button" class="btn btn-morgue">Admit Corpse</button>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Corpse Discharge Modal -->
    <div class="modal fade" id="dischargeModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><i class="fas fa-external-link-alt me-2"></i> Corpse Release</h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form>
                        <div class="row mb-3">
                            <div class="col-md-8">
                                <label class="form-label">Select Corpse</label>
                                <select class="form-select">
                                    <option>Select a corpse to release</option>
                                    <option>John Smith (C-23001, A-01)</option>
                                    <option>Mary Johnson (C-23002, A-02)</option>
                                    <option>Robert Davis (C-23004, A-04)</option>
                                    <option>Sarah Wilson (C-23005, A-05)</option>
                                    <option>Unknown Male (C-23007, A-07)</option>
                                    <option>Michael Brown (C-23008, A-08)</option>
                                </select>
                            </div>
                            <div class="col-md-4">
                                <label class="form-label">Release Date</label>
                                <input type="date" class="form-control" value="2023-10-16">
                            </div>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">Released To</label>
                            <div class="row">
                                <div class="col-md-6">
                                    <input type="text" class="form-control mb-2" placeholder="Recipient Name">
                                </div>
                                <div class="col-md-6">
                                    <input type="tel" class="form-control mb-2" placeholder="Contact Number">
                                </div>
                                <div class="col-md-12">
                                    <input type="text" class="form-control" placeholder="Relationship to Deceased">
                                </div>
                            </div>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">Funeral Home</label>
                            <div class="row">
                                <div class="col-md-6">
                                    <input type="text" class="form-control mb-2" placeholder="Funeral Home Name">
                                </div>
                                <div class="col-md-6">
                                    <input type="tel" class="form-control mb-2" placeholder="Funeral Home Phone">
                                </div>
                                <div class="col-md-12">
                                    <input type="text" class="form-control" placeholder="Funeral Home Address">
                                </div>
                            </div>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">Release Authorization</label>
                            <div class="form-check mb-2">
                                <input class="form-check-input" type="checkbox" id="deathCertificate">
                                <label class="form-check-label" for="deathCertificate">
                                    Death Certificate Presented
                                </label>
                            </div>
                            <div class="form-check mb-2">
                                <input class="form-check-input" type="checkbox" id="releaseAuth">
                                <label class="form-check-label" for="releaseAuth">
                                    Release Authorization Signed
                                </label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="personalEffects">
                                <label class="form-check-label" for="personalEffects">
                                    Personal Effects Returned
                                </label>
                            </div>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">Discharge Notes</label>
                            <textarea class="form-control" rows="3" placeholder="Any special instructions or notes"></textarea>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">Releasing Staff</label>
                            <div class="row">
                                <div class="col-md-6">
                                    <input type="text" class="form-control" value="Dr. Anderson" readonly>
                                </div>
                                <div class="col-md-6">
                                    <input type="text" class="form-control" placeholder="Staff Signature">
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="button" class="btn btn-morgue">Release Corpse</button>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Toast Container -->
    <div class="toast-container position-fixed bottom-0 end-0 p-3">
        <div class="toast" role="alert" aria-live="assertive" aria-atomic="true" data-bs-autohide="false">
            <div class="toast-header">
                <strong class="me-auto"><i class="fas fa-check-circle me-2"></i> Corpse Admitted</strong>
                <small>Just now</small>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="toast" aria-label="Close"></button>
            </div>
            <div class="toast-body">
                John Doe (C-23009) has been admitted to unit A-03.
            </div>
        </div>
    </div>

    <!-- Scripts -->
    <script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap5.min.js"></script>
    
    <script>
        $(document).ready(function() {
            // Initialize DataTable
            $('#deceasedTable').DataTable({
                pageLength: 5,
                lengthMenu: [[5, 10, 25, 50, -1], [5, 10, 25, 50, 'All']],
                responsive: true,
                dom: '<"row"<"col-sm-12 col-md-6"l><"col-sm-12 col-md-6"f>>rt<"row"<"col-sm-12 col-md-6"i><"col-sm-12 col-md-6"p>>'
            });
            
            // Show toast notification
            $('.toast').toast('show');
            
            // Pulse effect for occupied units
            setInterval(() => {
                $('.storage-unit.occupied').toggleClass('pulse');
            }, 2000);
            
            // Show admission modal on page load for demo
            setTimeout(function() {
                $('#admitModal').modal('show');
            }, 1000);
        });
    </script>
</body>
</html>