<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>MediSync - Pharmacy Stock Management</title>
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <!-- DataTables -->
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap5.min.css">
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@300;400;500;600;700&family=Orbitron:wght@400;500;600;700&display=swap" rel="stylesheet">
    <style>
        :root {
            --primary: #0a84ff;
            --secondary: #5e5ce6;
            --accent: #00d9ff;
            --success: #30d158;
            --warning: #ff9f0a;
            --danger: #ff375f;
            --dark: #1c1c1e;
            --darker: #121214;
            --light: #f5f5f7;
            --pharmacy: #2e7d32;
        }
        
        body {
            background-color: #121214;
            color: #e5e5e7;
            font-family: 'Candara', 'Montserrat', sans-serif;
            overflow-x: hidden;
            height: 100vh;
            transition: all 0.3s;
        }
        
        .futuristic-font {
            font-family: 'Montserrat', sans-serif;
            letter-spacing: 1px;
        }
        
        /* Custom Scrollbar */
        ::-webkit-scrollbar {
            width: 8px;
        }
        ::-webkit-scrollbar-track {
            background: var(--darker);
        }
        ::-webkit-scrollbar-thumb {
            background: var(--pharmacy);
            border-radius: 4px;
        }
        
        /* Sidebar */
        #sidebar {
            background: linear-gradient(180deg, var(--darker) 0%, rgba(28,28,30,0.95) 100%);
            border-right: 1px solid rgba(94,92,230,0.2);
            height: 100vh;
            position: fixed;
            transition: all 0.3s;
            z-index: 1000;
            box-shadow: 0 0 20px rgba(0,0,0,0.5);
            width: 250px;
        }
        
        .sidebar-header {
            padding: 20px;
            background: rgba(46, 125, 50, 0.2);
            border-bottom: 1px solid rgba(94,92,230,0.2);
        }
        
        .sidebar-menu {
            padding-top: 20px;
            overflow-y: auto;
            height: calc(100vh - 150px);
        }
        
        .sidebar-menu .nav-link {
            color: rgba(229,229,231,0.7);
            padding: 12px 20px;
            margin: 5px 15px;
            border-radius: 8px;
            transition: all 0.3s;
            font-weight: 500;
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;
        }
        
        .sidebar-menu .nav-link:hover, .sidebar-menu .nav-link.active {
            background: linear-gradient(90deg, rgba(46, 125, 50, 0.3) 0%, rgba(10,132,255,0.2) 100%);
            color: var(--accent);
            transform: translateX(5px);
        }
        
        .sidebar-menu .nav-link i {
            margin-right: 10px;
            font-size: 1.2rem;
            width: 25px;
            text-align: center;
        }
        
        /* Collapsed sidebar */
        #sidebar.collapsed {
            width: 70px;
        }
        
        #sidebar.collapsed .sidebar-header h3,
        #sidebar.collapsed .sidebar-header p,
        #sidebar.collapsed .nav-link span {
            display: none;
        }
        
        #sidebar.collapsed .nav-link {
            text-align: center;
            padding: 12px 5px;
        }
        
        #sidebar.collapsed .nav-link i {
            margin-right: 0;
            font-size: 1.5rem;
        }
        
        #sidebar.collapsed .sidebar-menu .nav-item {
            text-align: center;
        }
        
        /* Main Content */
        #content {
            margin-left: 250px;
            padding: 20px;
            min-height: 100vh;
            transition: all 0.3s;
        }
        
        #content.collapsed {
            margin-left: 70px;
        }
        
        /* Top Bar */
        .top-bar {
            background: rgba(28,28,30,0.8);
            backdrop-filter: blur(10px);
            border-bottom: 1px solid rgba(94,92,230,0.2);
            padding: 15px 25px;
            border-radius: 12px;
            margin-bottom: 25px;
        }
        
        /* Cards */
        .card {
            background: rgba(28,28,30,0.7);
            border: 1px solid rgba(46, 125, 50, 0.3);
            border-radius: 16px;
            backdrop-filter: blur(10px);
            box-shadow: 0 8px 32px rgba(0,0,0,0.3);
            transition: transform 0.3s, box-shadow 0.3s;
            margin-bottom: 25px;
        }
        
        .card:hover {
            transform: translateY(-5px);
            box-shadow: 0 12px 40px rgba(46, 125, 50, 0.4);
        }
        
        .card-header {
            background: linear-gradient(90deg, rgba(46, 125, 50, 0.2) 0%, rgba(10,132,255,0.15) 100%);
            border-bottom: 1px solid rgba(46, 125, 50, 0.2);
            padding: 15px 20px;
            border-radius: 16px 16px 0 0 !important;
            font-weight: 600;
        }
        
        /* Buttons */
        .btn-pharmacy {
            background: linear-gradient(90deg, var(--pharmacy) 0%, #4caf50 100%);
            border: none;
            border-radius: 8px;
            font-weight: 600;
            color: white;
        }
        
        .btn-outline-pharmacy {
            border: 1px solid var(--pharmacy);
            color: var(--pharmacy);
            border-radius: 8px;
            font-weight: 600;
        }
        
        .btn-outline-pharmacy:hover {
            background: linear-gradient(90deg, var(--pharmacy) 0%, #4caf50 100%);
            color: white;
        }
        
        /* Data Table */
        .dataTables_wrapper {
            padding: 0 15px 15px 15px;
        }
        
        .dataTables_filter input {
            background: rgba(28,28,30,0.5);
            border: 1px solid rgba(46, 125, 50, 0.3);
            color: white;
            border-radius: 8px;
            padding: 8px 15px;
        }
        
        .dataTables_length select {
            background: rgba(28,28,30,0.5);
            border: 1px solid rgba(46, 125, 50, 0.3);
            color: white;
            border-radius: 8px;
            padding: 5px;
        }
        
        /* Stats Cards */
        .stat-card {
            text-align: center;
            padding: 20px;
            border-radius: 16px;
            background: rgba(28,28,30,0.7);
            border: 1px solid rgba(46, 125, 50, 0.3);
            transition: all 0.3s;
        }
        
        .stat-card:hover {
            transform: translateY(-5px);
            border-color: var(--accent);
        }
        
        .stat-card i {
            font-size: 2.5rem;
            margin-bottom: 15px;
            background: linear-gradient(90deg, var(--pharmacy) 0%, #4caf50 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }
        
        .stat-card .value {
            font-size: 2rem;
            font-weight: 700;
            margin: 10px 0;
            background: linear-gradient(90deg, var(--accent) 0%, var(--pharmacy) 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }
        
        /* Toasts */
        .toast {
            background: rgba(28,28,30,0.9);
            border: 1px solid rgba(46, 125, 50, 0.5);
            border-left: 4px solid var(--pharmacy);
            backdrop-filter: blur(10px);
            border-radius: 8px;
        }
        
        .toast-header {
            background: rgba(28,28,30,0.7);
            color: var(--pharmacy);
            border-bottom: 1px solid rgba(46, 125, 50, 0.3);
        }
        
        /* Modal */
        .modal-content {
            background: rgba(28,28,30,0.95);
            border: 1px solid rgba(46, 125, 50, 0.5);
            border-radius: 16px;
            backdrop-filter: blur(10px);
        }
        
        .modal-header {
            border-bottom: 1px solid rgba(46, 125, 50, 0.3);
        }
        
        /* Form Elements */
        .form-control, .form-select {
            background: rgba(28,28,30,0.7);
            border: 1px solid rgba(46, 125, 50, 0.3);
            color: white;
            border-radius: 8px;
            padding: 10px 15px;
        }
        
        .form-control:focus, .form-select:focus {
            background: rgba(28,28,30,0.8);
            border-color: var(--accent);
            box-shadow: 0 0 0 0.25rem rgba(46, 125, 50, 0.25);
            color: white;
        }
        
        /* Expiry Status */
        .expiry-badge {
            padding: 5px 10px;
            border-radius: 20px;
            font-size: 0.85rem;
            font-weight: 600;
        }
        
        .expiry-safe {
            background: rgba(48, 209, 88, 0.15);
            color: var(--success);
        }
        
        .expiry-warning {
            background: rgba(255, 159, 10, 0.15);
            color: var(--warning);
        }
        
        .expiry-danger {
            background: rgba(255, 55, 95, 0.15);
            color: var(--danger);
        }
        
        .expiry-expired {
            background: rgba(150, 150, 150, 0.15);
            color: #ccc;
            text-decoration: line-through;
        }
        
        /* Responsive */
        @media (max-width: 992px) {
            #sidebar {
                width: 70px;
            }
            
            #sidebar .sidebar-header h3,
            #sidebar .sidebar-header p,
            #sidebar .nav-link span {
                display: none;
            }
            
            #sidebar .nav-link {
                text-align: center;
                padding: 12px 5px;
            }
            
            #sidebar .nav-link i {
                margin-right: 0;
                font-size: 1.5rem;
            }
            
            #sidebar .sidebar-menu .nav-item {
                text-align: center;
            }
            
            #content {
                margin-left: 70px;
            }
            
            .top-bar .d-flex {
                flex-direction: column;
                gap: 10px;
            }
            
            .top-bar .d-flex > div {
                width: 100%;
            }
        }
        
        @media (max-width: 768px) {
            #sidebar {
                width: 100%;
                height: auto;
                position: relative;
                margin-bottom: 20px;
            }
            
            #sidebar .nav-link span {
                display: inline;
            }
            
            #sidebar .nav-link {
                text-align: left;
                padding: 12px 20px;
            }
            
            #sidebar .nav-link i {
                margin-right: 10px;
                font-size: 1.2rem;
            }
            
            #content {
                margin-left: 0;
            }
            
            .top-bar {
                padding: 10px 15px;
            }
            
            .card-header .d-flex {
                flex-direction: column;
                gap: 10px;
            }
        }
        
        /* Mobile menu toggle */
        .mobile-menu-btn {
            display: none;
            position: fixed;
            top: 20px;
            left: 20px;
            z-index: 1100;
            background: var(--pharmacy);
            color: white;
            border: none;
            border-radius: 50%;
            width: 50px;
            height: 50px;
            font-size: 1.5rem;
            box-shadow: 0 0 10px rgba(0,0,0,0.5);
        }
        
        @media (max-width: 768px) {
            .mobile-menu-btn {
                display: block;
            }
            
            #sidebar {
                position: fixed;
                left: -100%;
                top: 0;
                height: 100vh;
                overflow-y: auto;
                z-index: 1000;
                transition: left 0.3s;
            }
            
            #sidebar.active {
                left: 0;
            }
        }
    </style>
</head>
<body>
    <!-- Mobile Menu Toggle -->
    <button class="mobile-menu-btn" id="mobileMenuBtn">
        <i class="fas fa-bars"></i>
    </button>
    
    <!-- Sidebar -->
    <div id="sidebar">
        <div class="sidebar-header">
            <h3 class="futuristic-font mb-0"><i class="fas fa-pills me-2"></i>MediSync</h3>
            <p class="text-muted mb-0">Pharmacy Management</p>
        </div>
        
        <ul class="nav flex-column sidebar-menu">
            <li class="nav-item">
                <a class="nav-link" href="#"><i class="fas fa-tachometer-alt"></i> <span>Dashboard</span></a>
            </li>
            <li class="nav-item">
                <a class="nav-link active" href="#"><i class="fas fa-capsules"></i> <span>Stock Management</span></a>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="#"><i class="fas fa-prescription-bottle-alt"></i> <span>Dispensary</span></a>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="#"><i class="fas fa-file-prescription"></i> <span>Prescriptions</span></a>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="#"><i class="fas fa-vial"></i> <span>Suppliers</span></a>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="#"><i class="fas fa-chart-line"></i> <span>Reports</span></a>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="#"><i class="fas fa-exclamation-triangle"></i> <span>Expiry Alerts</span></a>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="#"><i class="fas fa-shopping-cart"></i> <span>Purchase Orders</span></a>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="#"><i class="fas fa-cog"></i> <span>Settings</span></a>
            </li>
        </ul>
        
        <div class="mt-auto p-3 text-center">
            <div class="btn-group">
                <button class="btn btn-sm btn-outline-pharmacy" id="toggleSidebar">
                    <i class="fas fa-chevron-left"></i>
                </button>
                <button class="btn btn-sm btn-outline-pharmacy"><i class="fas fa-question-circle"></i></button>
                <button class="btn btn-sm btn-pharmacy"><i class="fas fa-sign-out-alt"></i> <span>Logout</span></button>
            </div>
        </div>
    </div>

    <!-- Main Content -->
    <div id="content">
        <!-- Top Bar -->
        <div class="top-bar d-flex justify-content-between align-items-center">
            <div>
                <h4 class="futuristic-font mb-0"><i class="fas fa-capsules me-2"></i> Pharmacy Stock Management</h4>
                <p class="text-muted mb-0">Manage inventory, track expirations, and document dispensary</p>
            </div>
            <div class="d-flex align-items-center">
                <div class="me-3">
                    <button class="btn btn-pharmacy me-2" data-bs-toggle="modal" data-bs-target="#addStockModal">
                        <i class="fas fa-plus me-1"></i> Add Stock
                    </button>
                    <button class="btn btn-outline-pharmacy" data-bs-toggle="modal" data-bs-target="#dispenseModal">
                        <i class="fas fa-paper-plane me-1"></i> Record Dispensing
                    </button>
                </div>
                <div class="dropdown">
                    <button class="btn btn-outline-pharmacy dropdown-toggle" type="button" data-bs-toggle="dropdown">
                        <i class="fas fa-user-circle me-2"></i> Pharmacist
                    </button>
                    <ul class="dropdown-menu dropdown-menu-end">
                        <li><a class="dropdown-item" href="#"><i class="fas fa-user me-2"></i> Profile</a></li>
                        <li><a class="dropdown-item" href="#"><i class="fas fa-cog me-2"></i> Settings</a></li>
                        <li><hr class="dropdown-divider"></li>
                        <li><a class="dropdown-item" href="#"><i class="fas fa-sign-out-alt me-2"></i> Logout</a></li>
                    </ul>
                </div>
            </div>
        </div>
        
        <!-- Stats Overview -->
        <div class="row">
            <div class="col-md-3 col-sm-6 mb-3">
                <div class="stat-card">
                    <i class="fas fa-capsules"></i>
                    <div class="label">Total Items</div>
                    <div class="value">1,248</div>
                    <div class="text-success small">24 categories</div>
                </div>
            </div>
            <div class="col-md-3 col-sm-6 mb-3">
                <div class="stat-card">
                    <i class="fas fa-boxes"></i>
                    <div class="label">Total Stock</div>
                    <div class="value">58,412</div>
                    <div class="text-info small">units available</div>
                </div>
            </div>
            <div class="col-md-3 col-sm-6 mb-3">
                <div class="stat-card">
                    <i class="fas fa-exclamation-triangle"></i>
                    <div class="label">Near Expiry</div>
                    <div class="value">87</div>
                    <div class="text-warning small">items expiring soon</div>
                </div>
            </div>
            <div class="col-md-3 col-sm-6 mb-3">
                <div class="stat-card">
                    <i class="fas fa-cart-arrow-down"></i>
                    <div class="label">Low Stock</div>
                    <div class="value">42</div>
                    <div class="text-danger small">items need reorder</div>
                </div>
            </div>
        </div>
        
        <!-- Stock Management Table -->
        <div class="card mb-4">
            <div class="card-header d-flex justify-content-between align-items-center flex-wrap">
                <h5 class="mb-0"><i class="fas fa-table me-2"></i> Current Stock Inventory</h5>
                <div class="d-flex mt-2 mt-md-0">
                    <div class="input-group me-2" style="width: 200px;">
                        <select class="form-select form-select-sm">
                            <option>All Categories</option>
                            <option>Antibiotics</option>
                            <option>Analgesics</option>
                            <option>Cardiovascular</option>
                            <option>Diabetes</option>
                            <option>Vitamins</option>
                        </select>
                    </div>
                    <button class="btn btn-sm btn-outline-pharmacy">
                        <i class="fas fa-filter me-1"></i> Filter
                    </button>
                </div>
            </div>
            <div class="card-body">
                <table id="stockTable" class="table table-hover">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Item Name</th>
                            <th>Category</th>
                            <th>Batch No.</th>
                            <th>Quantity</th>
                            <th>Expiry Date</th>
                            <th>Days Left</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>P-04512</td>
                            <td>Amoxicillin 500mg Capsule</td>
                            <td>Antibiotics</td>
                            <td>AMX-2301</td>
                            <td>1,248</td>
                            <td>2024-06-15</td>
                            <td>234</td>
                            <td><span class="expiry-badge expiry-safe">Safe</span></td>
                            <td>
                                <button class="btn btn-sm btn-outline-pharmacy me-1"><i class="fas fa-eye"></i></button>
                                <button class="btn btn-sm btn-outline-warning me-1"><i class="fas fa-edit"></i></button>
                                <button class="btn btn-sm btn-outline-danger"><i class="fas fa-trash"></i></button>
                            </td>
                        </tr>
                        <tr>
                            <td>P-07841</td>
                            <td>Insulin Glargine 100U/ml</td>
                            <td>Diabetes</td>
                            <td>INS-2305</td>
                            <td>342</td>
                            <td>2023-12-20</td>
                            <td>52</td>
                            <td><span class="expiry-badge expiry-warning">Warning</span></td>
                            <td>
                                <button class="btn btn-sm btn-outline-pharmacy me-1"><i class="fas fa-eye"></i></button>
                                <button class="btn btn-sm btn-outline-warning me-1"><i class="fas fa-edit"></i></button>
                                <button class="btn btn-sm btn-outline-danger"><i class="fas fa-trash"></i></button>
                            </td>
                        </tr>
                        <tr>
                            <td>P-01245</td>
                            <td>Paracetamol 500mg Tablet</td>
                            <td>Analgesics</td>
                            <td>PAR-2212</td>
                            <td>8,420</td>
                            <td>2023-11-05</td>
                            <td>28</td>
                            <td><span class="expiry-badge expiry-warning">Warning</span></td>
                            <td>
                                <button class="btn btn-sm btn-outline-pharmacy me-1"><i class="fas fa-eye"></i></button>
                                <button class="btn btn-sm btn-outline-warning me-1"><i class="fas fa-edit"></i></button>
                                <button class="btn btn-sm btn-outline-danger"><i class="fas fa-trash"></i></button>
                            </td>
                        </tr>
                        <tr>
                            <td>P-08956</td>
                            <td>Atorvastatin 20mg Tablet</td>
                            <td>Cardiovascular</td>
                            <td>ATO-2303</td>
                            <td>3,125</td>
                            <td>2025-01-30</td>
                            <td>479</td>
                            <td><span class="expiry-badge expiry-safe">Safe</span></td>
                            <td>
                                <button class="btn btn-sm btn-outline-pharmacy me-1"><i class="fas fa-eye"></i></button>
                                <button class="btn btn-sm btn-outline-warning me-1"><i class="fas fa-edit"></i></button>
                                <button class="btn btn-sm btn-outline-danger"><i class="fas fa-trash"></i></button>
                            </td>
                        </tr>
                        <tr>
                            <td>P-03478</td>
                            <td>Vitamin D3 1000IU Capsule</td>
                            <td>Vitamins</td>
                            <td>VIT-2308</td>
                            <td>2,845</td>
                            <td>2023-10-30</td>
                            <td>22</td>
                            <td><span class="expiry-badge expiry-danger">Critical</span></td>
                            <td>
                                <button class="btn btn-sm btn-outline-pharmacy me-1"><i class="fas fa-eye"></i></button>
                                <button class="btn btn-sm btn-outline-warning me-1"><i class="fas fa-edit"></i></button>
                                <button class="btn btn-sm btn-outline-danger"><i class="fas fa-trash"></i></button>
                            </td>
                        </tr>
                        <tr>
                            <td>P-05623</td>
                            <td>Lisinopril 10mg Tablet</td>
                            <td>Cardiovascular</td>
                            <td>LIS-2302</td>
                            <td>1,580</td>
                            <td>2023-09-15</td>
                            <td>-3</td>
                            <td><span class="expiry-badge expiry-expired">Expired</span></td>
                            <td>
                                <button class="btn btn-sm btn-outline-pharmacy me-1"><i class="fas fa-eye"></i></button>
                                <button class="btn btn-sm btn-outline-warning me-1"><i class="fas fa-edit"></i></button>
                                <button class="btn btn-sm btn-outline-danger"><i class="fas fa-trash"></i></button>
                            </td>
                        </tr>
                        <tr>
                            <td>P-07892</td>
                            <td>Metformin 850mg Tablet</td>
                            <td>Diabetes</td>
                            <td>MET-2304</td>
                            <td>5,240</td>
                            <td>2024-08-12</td>
                            <td>304</td>
                            <td><span class="expiry-badge expiry-safe">Safe</span></td>
                            <td>
                                <button class="btn btn-sm btn-outline-pharmacy me-1"><i class="fas fa-eye"></i></button>
                                <button class="btn btn-sm btn-outline-warning me-1"><i class="fas fa-edit"></i></button>
                                <button class="btn btn-sm btn-outline-danger"><i class="fas fa-trash"></i></button>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
        
        <!-- Recent Dispensary Records -->
        <div class="row">
            <div class="col-lg-8">
                <div class="card">
                    <div class="card-header d-flex justify-content-between align-items-center flex-wrap">
                        <h5 class="mb-0"><i class="fas fa-file-prescription me-2"></i> Recent Dispensary Records</h5>
                        <div class="d-flex mt-2 mt-md-0">
                            <input type="date" class="form-control form-control-sm me-2">
                            <button class="btn btn-sm btn-outline-pharmacy">
                                <i class="fas fa-filter me-1"></i> Filter
                            </button>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-sm">
                                <thead>
                                    <tr>
                                        <th>Date</th>
                                        <th>Prescription ID</th>
                                        <th>Patient</th>
                                        <th>Items Dispensed</th>
                                        <th>Pharmacist</th>
                                        <th>Status</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>2023-10-16</td>
                                        <td>RX-23010145</td>
                                        <td>John Smith</td>
                                        <td>3 items</td>
                                        <td>Dr. Anderson</td>
                                        <td><span class="badge bg-success">Completed</span></td>
                                        <td><button class="btn btn-sm btn-outline-pharmacy"><i class="fas fa-eye"></i></button></td>
                                    </tr>
                                    <tr>
                                        <td>2023-10-16</td>
                                        <td>RX-23010146</td>
                                        <td>Mary Johnson</td>
                                        <td>5 items</td>
                                        <td>Dr. Roberts</td>
                                        <td><span class="badge bg-success">Completed</span></td>
                                        <td><button class="btn btn-sm btn-outline-pharmacy"><i class="fas fa-eye"></i></button></td>
                                    </tr>
                                    <tr>
                                        <td>2023-10-15</td>
                                        <td>RX-23010142</td>
                                        <td>Robert Davis</td>
                                        <td>2 items</td>
                                        <td>Dr. Anderson</td>
                                        <td><span class="badge bg-success">Completed</span></td>
                                        <td><button class="btn btn-sm btn-outline-pharmacy"><i class="fas fa-eye"></i></button></td>
                                    </tr>
                                    <tr>
                                        <td>2023-10-15</td>
                                        <td>RX-23010143</td>
                                        <td>Sarah Wilson</td>
                                        <td>4 items</td>
                                        <td>Dr. Roberts</td>
                                        <td><span class="badge bg-warning">Pending</span></td>
                                        <td><button class="btn btn-sm btn-outline-pharmacy"><i class="fas fa-eye"></i></button></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Expiry Alerts -->
            <div class="col-lg-4">
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0"><i class="fas fa-exclamation-triangle me-2"></i> Expiry Alerts</h5>
                    </div>
                    <div class="card-body">
                        <div class="list-group">
                            <a href="#" class="list-group-item list-group-item-action bg-transparent border-secondary">
                                <div class="d-flex w-100 justify-content-between">
                                    <h6 class="mb-1">Vitamin D3 1000IU</h6>
                                    <small class="text-danger">22 days</small>
                                </div>
                                <p class="mb-1">Batch: VIT-2308 | Qty: 2,845</p>
                                <small>Expiry: 2023-10-30</small>
                            </a>
                            <a href="#" class="list-group-item list-group-item-action bg-transparent border-secondary">
                                <div class="d-flex w-100 justify-content-between">
                                    <h6 class="mb-1">Paracetamol 500mg</h6>
                                    <small class="text-warning">28 days</small>
                                </div>
                                <p class="mb-1">Batch: PAR-2212 | Qty: 8,420</p>
                                <small>Expiry: 2023-11-05</small>
                            </a>
                            <a href="#" class="list-group-item list-group-item-action bg-transparent border-secondary">
                                <div class="d-flex w-100 justify-content-between">
                                    <h6 class="mb-1">Insulin Glargine</h6>
                                    <small class="text-warning">52 days</small>
                                </div>
                                <p class="mb-1">Batch: INS-2305 | Qty: 342</p>
                                <small>Expiry: 2023-12-20</small>
                            </a>
                            <a href="#" class="list-group-item list-group-item-action bg-transparent border-secondary">
                                <div class="d-flex w-100 justify-content-between">
                                    <h6 class="mb-1">Lisinopril 10mg</h6>
                                    <small class="text-muted">Expired</small>
                                </div>
                                <p class="mb-1">Batch: LIS-2302 | Qty: 1,580</p>
                                <small>Expiry: 2023-09-15</small>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Add Stock Modal -->
    <div class="modal fade" id="addStockModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><i class="fas fa-plus me-2"></i> Add New Stock</h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form>
                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label class="form-label">Item Name</label>
                                <input type="text" class="form-control" placeholder="Enter item name">
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Category</label>
                                <select class="form-select">
                                    <option>Select category</option>
                                    <option>Antibiotics</option>
                                    <option>Analgesics</option>
                                    <option>Cardiovascular</option>
                                    <option>Diabetes</option>
                                    <option>Vitamins</option>
                                    <option>Other</option>
                                </select>
                            </div>
                        </div>
                        
                        <div class="row mb-3">
                            <div class="col-md-4">
                                <label class="form-label">Batch Number</label>
                                <input type="text" class="form-control" placeholder="Enter batch number">
                            </div>
                            <div class="col-md-4">
                                <label class="form-label">Quantity</label>
                                <input type="number" class="form-control" placeholder="Enter quantity">
                            </div>
                            <div class="col-md-4">
                                <label class="form-label">Unit of Measure</label>
                                <select class="form-select">
                                    <option>Tablets</option>
                                    <option>Capsules</option>
                                    <option>Bottles</option>
                                    <option>Vials</option>
                                    <option>Boxes</option>
                                </select>
                            </div>
                        </div>
                        
                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label class="form-label">Expiry Date</label>
                                <input type="date" class="form-control">
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Manufacture Date</label>
                                <input type="date" class="form-control">
                            </div>
                        </div>
                        
                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label class="form-label">Supplier</label>
                                <select class="form-select">
                                    <option>Select supplier</option>
                                    <option>MediSupply Co.</option>
                                    <option>PharmaDist Inc.</option>
                                    <option>Global Health Supplies</option>
                                    <option>Quality Meds Ltd.</option>
                                </select>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Purchase Price</label>
                                <div class="input-group">
                                    <span class="input-group-text">$</span>
                                    <input type="number" class="form-control" placeholder="0.00">
                                </div>
                            </div>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">Storage Location</label>
                            <div class="row">
                                <div class="col-md-6">
                                    <input type="text" class="form-control" placeholder="Shelf or Rack">
                                </div>
                                <div class="col-md-6">
                                    <input type="text" class="form-control" placeholder="Bin or Section">
                                </div>
                            </div>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">Notes</label>
                            <textarea class="form-control" rows="3" placeholder="Any special instructions or notes"></textarea>
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="button" class="btn btn-pharmacy">Add Stock</button>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Dispense Items Modal -->
    <div class="modal fade" id="dispenseModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><i class="fas fa-paper-plane me-2"></i> Dispense Medication</h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form>
                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label class="form-label">Patient</label>
                                <select class="form-select">
                                    <option>Select patient</option>
                                    <option>John Smith (ID: P-10245)</option>
                                    <option>Mary Johnson (ID: P-10246)</option>
                                    <option>Robert Davis (ID: P-10247)</option>
                                    <option>Sarah Wilson (ID: P-10248)</option>
                                </select>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Prescription ID</label>
                                <input type="text" class="form-control" placeholder="Enter prescription ID">
                            </div>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">Prescribing Physician</label>
                            <input type="text" class="form-control" placeholder="Enter physician name">
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">Items to Dispense</label>
                            <div class="table-responsive">
                                <table class="table table-sm">
                                    <thead>
                                        <tr>
                                            <th>Item</th>
                                            <th>Batch</th>
                                            <th>Quantity</th>
                                            <th>Dosage</th>
                                            <th>Price</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td>
                                                <select class="form-select form-select-sm">
                                                    <option>Select item</option>
                                                    <option>Amoxicillin 500mg Capsule</option>
                                                    <option>Paracetamol 500mg Tablet</option>
                                                    <option>Insulin Glargine 100U/ml</option>
                                                    <option>Atorvastatin 20mg Tablet</option>
                                                </select>
                                            </td>
                                            <td>
                                                <select class="form-select form-select-sm">
                                                    <option>Select batch</option>
                                                    <option>AMX-2301 (Exp: 2024-06-15)</option>
                                                    <option>AMX-2302 (Exp: 2024-07-10)</option>
                                                </select>
                                            </td>
                                            <td><input type="number" class="form-control form-control-sm" value="30"></td>
                                            <td><input type="text" class="form-control form-control-sm" value="1 cap TID"></td>
                                            <td><input type="number" class="form-control form-control-sm" value="15.50"></td>
                                            <td><button class="btn btn-sm btn-outline-danger"><i class="fas fa-times"></i></button></td>
                                        </tr>
                                        <tr>
                                            <td colspan="5" class="text-center">
                                                <button class="btn btn-sm btn-outline-pharmacy"><i class="fas fa-plus me-1"></i> Add Item</button>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        
                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label class="form-label">Dispensing Pharmacist</label>
                                <input type="text" class="form-control" value="Dr. Anderson" readonly>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Dispensing Date</label>
                                <input type="date" class="form-control" value="2023-10-16">
                            </div>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">Special Instructions</label>
                            <textarea class="form-control" rows="2" placeholder="Any special instructions for the patient"></textarea>
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="button" class="btn btn-pharmacy">Dispense Items</button>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Toast Container -->
    <div class="toast-container position-fixed bottom-0 end-0 p-3">
        <div class="toast" role="alert" aria-live="assertive" aria-atomic="true" data-bs-autohide="false">
            <div class="toast-header">
                <strong class="me-auto"><i class="fas fa-check-circle me-2"></i> Stock Added</strong>
                <small>Just now</small>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="toast" aria-label="Close"></button>
            </div>
            <div class="toast-body">
                500 units of Amoxicillin added to inventory.
            </div>
        </div>
    </div>

    <!-- Scripts -->
    <script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap5.min.js"></script>
    
    <script>
        $(document).ready(function() {
            // Initialize DataTable
            $('#stockTable').DataTable({
                pageLength: 5,
                lengthMenu: [[5, 10, 25, 50, -1], [5, 10, 25, 50, 'All']],
                responsive: true,
                dom: '<"row"<"col-sm-12 col-md-6"l><"col-sm-12 col-md-6"f>>rt<"row"<"col-sm-12 col-md-6"i><"col-sm-12 col-md-6"p>>'
            });
            
            // Toggle sidebar
            $('#toggleSidebar').on('click', function() {
                $('#sidebar').toggleClass('collapsed');
                $('#content').toggleClass('collapsed');
                
                // Change icon based on state
                if ($('#sidebar').hasClass('collapsed')) {
                    $(this).html('<i class="fas fa-chevron-right"></i>');
                } else {
                    $(this).html('<i class="fas fa-chevron-left"></i>');
                }
            });
            
            // Mobile menu toggle
            $('#mobileMenuBtn').on('click', function() {
                $('#sidebar').toggleClass('active');
            });
            
            // Show toast notification
            $('.toast').toast('show');
            
            // Show modal on button click
            $('.btn-pharmacy:contains("Add Stock")').on('click', function() {
                $('#addStockModal').modal('show');
            });
            
            // Color code expiration days
            $('td:contains("22")').parent().find('.expiry-badge').removeClass('expiry-safe expiry-warning').addClass('expiry-danger');
            $('td:contains("28")').parent().find('.expiry-badge').removeClass('expiry-safe expiry-danger').addClass('expiry-warning');
            $('td:contains("52")').parent().find('.expiry-badge').removeClass('expiry-safe expiry-danger').addClass('expiry-warning');
            $('td:contains("-3")').parent().find('.expiry-badge').removeClass().addClass('expiry-badge expiry-expired');
        });
    </script>
</body>
</html>