<table id="patientsTable" class="table table-bordered table-striped">
    <thead>
        <tr>
            <th>Patient ID</th>
            <th>Name</th>
            <th>Contact</th>
            <th>Gender</th>
            <th>Age</th>
            <th>Blood Group</th>
            <th>Last Visit</th>
            <th>Status</th>
            <th>Actions</th>
        </tr>
    </thead>
</table>

<script>
$(document).ready(function() {
    $('#patientsTable').DataTable({
        processing: true,
        serverSide: false, // we are loading all data at once
        ajax: {
            url: 'fetch_patients.php', // make sure this path is correct
            type: 'GET',
            dataSrc: 'data' // matches the "data" key in your PHP output
        },
        columns: [
            { data: 'patient_id' },
            { data: 'name' },
            { data: 'contact' },
            { data: 'gender' },
            { data: 'age' },
            { data: 'blood_group' },
            { data: 'last_visit' },
            { data: 'status' },
            { data: 'actions' }
        ]
    });
});
</script>
