<?php
header('Content-Type: application/json');

// Secure DB Connection
$DBhost = 'localhost';
$DBuser = 'rhedlkwp_Rhedrick';
$DBpass = 'Avr2025!Cav2026!';
$DBname = 'rhedlkwp_cav';

try {
    $DBcon = new PDO("mysql:host=$DBhost;dbname=$DBname", $DBuser, $DBpass);
    $DBcon->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $ex) {
    http_response_code(500);
    echo json_encode(['error' => 'Database connection failed']);
    exit;
}

// Validate request
$client = $_GET['client'] ?? '';
$key    = $_GET['key'] ?? '';
$vendor = $_GET['vendor'] ?? '';
$trxnref = $_GET['trxnref'] ?? '';

$API_KEY = '8nsir98rhorwgf98wrhf8r09iu035h098h59hf85045ht0n808t6hj8fd7tegg';

$allowed_vendors = ['Royusuf', 'TierraCasa', 'OBrien', 'Simrheam'];
if ($client !== 'Wema' || $key !== $API_KEY || !in_array($vendor, $allowed_vendors)) {
    http_response_code(403);
    echo json_encode(['error' => 'Access Denied']);
    exit;
}

// Fetch record
try {
    $stmt = $DBcon->prepare("SELECT * FROM `d_jobs` WHERE `trxnref` = :trxnref AND `signature` = :vendor");
    $stmt->bindParam(':trxnref', $trxnref);
    $stmt->bindParam(':vendor', $vendor);
    $stmt->execute();

    if ($stmt->rowCount() === 0) {
        // Check in test_jobs
        $testStmt = $DBcon->prepare("SELECT * FROM `jobs` WHERE `trxnref` = :trxnref AND `signature` = :vendor");
        $testStmt->bindParam(':trxnref', $trxnref);
        $testStmt->bindParam(':vendor', $vendor);
        $testStmt->execute();

        if ($testStmt->rowCount() > 0) {
            echo json_encode(['message' => 'Request Still Processing, Pending Vendor Approval']);
        } else {
            echo json_encode(['message' => 'Record Not Found']);
        }

        exit;
    }

    $row = $stmt->fetch(PDO::FETCH_ASSOC);

    // Return only required fields
    $response = [
        'trxnref'                     => $row['trxnref'] ?? '',
        'batch'                       => $row['batch'] ?? '',
        'coord'                       => $row['coord'] ?? '',
        'google_map'                  => !empty($row['coord']) ? "http://maps.google.com/maps?q=loc:" . $row['coord'] : '',
        'first_name'                 => $row['first_name'] ?? '',
        'last_name'                  => $row['last_name'] ?? '',
        'customer_address'           => $row['customer_address'] ?? '',
        'address_exists'             => $row['address_status'] ?? '',
        'customer_resides'           => $row['customer_resides'] ?? '',
        'landmark'                   => $row['landmark'] ?? '',
        'city'                       => $row['city'] ?? '',
        'state'                      => $row['state'] ?? '',
        'building_condition'         => $row['building_condition'] ?? '',
        'building_finishing'         => $row['building_finishing'] ?? '',
        'customer_rel_with_address'  => $row['customer_rel_with_address'] ?? '',
        'owner_relationship'         => $row['owner_relationship'] ?? '',
        'interviewee'                => $row['interviewee'] ?? '',
        'interviewee_relationship'   => $row['interviewee_relationship'] ?? '',
        'visitation_date'            => $row['visitation_date'] ?? '',
        'visitation_time'            => $row['visitation_time'] ?? '',
        'building_type'              => $row['building_type'] ?? '',
        'colour_of_building'         => $row['colour_of_building'] ?? '',
        'ver_message_comments'       => $row['comments'] ?? '',
        'agent'                      => $row['agent'] ?? '',
        'st_photo'                   => $row['st_photo'] ?? '',
        'bd_photo'                   => $row['bd_photo'] ?? '',
        'vendor'                     => $row['signature'] ?? '',
    ];

    echo json_encode([
        'status' => 'success',
        'data'   => $response
    ]);

} catch (PDOException $ex) {
    http_response_code(500);
    echo json_encode(['error' => 'Query Error']);
}

$DBcon = null;
?>
