<?php
header("Content-Type: application/json");

// DB Credentials
$DB_HOST = 'localhost';
$DB_USER = 'rhedlkwp_Rhedrick';
$DB_PASS = 'Avr2025!Cav2026!';
$DB_NAME = 'rhedlkwp_cav';

// Connect
try {
    $DB_con = new PDO("mysql:host={$DB_HOST};dbname={$DB_NAME}", $DB_USER, $DB_PASS);
    $DB_con->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(["status" => "error", "message" => "Database connection failed."]);
    exit;
}

// Get JSON input
$data = json_decode(file_get_contents("php://input"), true);

// Validate Access
$client = $_SERVER['HTTP_X_CLIENT'] ?? '';
$key    = $_SERVER['HTTP_X_API_KEY'] ?? '';
$vendor = $_SERVER['HTTP_X_VENDOR'] ?? '';

$allowed_vendors = ['Royusuf', 'TierraCasa', 'OBrien', 'Simrheam'];

if (
    $client !== 'Wema' || $key !== '8nsir98rhorwgf98wrhf8r09iu035h098h59hf85045ht0n808t6hj8fd7tegg' || !in_array($vendor, $allowed_vendors)
) {
    http_response_code(401);
    echo json_encode(["status" => "error", "message" => "Unauthorized client or vendor."]);
    exit;
}


// Clean function
function clean($val) {
    return trim($val ?? '');
}

// Validate fields
$fields = [
    "trxnref"    => [100, true],
    "first_name" => [250, true],
    "last_name"  => [250, true],
    "state"      => [50, true],
    "city"       => [100, true],
    "phone_no"   => [15, true],
    "address"    => [1000, true],
    "batch"      => [300, true],
];

$errors = [];
$values = [];

foreach ($fields as $field => [$max, $required]) {
    $value = clean($data[$field] ?? '');
    if ($required && $value === '') {
        $errors[$field] = "This field is required.";
    } elseif (strlen($value) > $max) {
        $errors[$field] = "Must not exceed {$max} characters.";
    } else {
        $values[$field] = $value;
    }
}

if (!empty($errors)) {
    http_response_code(422);
    echo json_encode([
        "status" => "error",
        "message" => "Validation failed.",
        "errors" => $errors
    ]);
    exit;
}

// Assign sanitized values
extract($values);

$signature = $vendor;
$post_by   = $client;
$post_date = date("Y-m-d h:i:sa");
$status = 'Undone';
$customer_name = $occupation = $landmark = $alias = $company = $agent = "N/A";

try {
    // Check duplicate
    $check = $DB_con->prepare("SELECT COUNT(*) FROM jobs WHERE trxnref = :trxnref");
    $check->execute([':trxnref' => $trxnref]);

    if ($check->fetchColumn() > 0) {
        http_response_code(409);
        echo json_encode(["status" => "error", "message" => "Transaction reference already exists."]);
        exit;
    }

    // Insert
    $stmt = $DB_con->prepare('INSERT INTO jobs (
        trxnref, customer_name, first_name, last_name, state, city, phone_no,
        occupation, address, landmark, alias, company, agent, client,
        post_by, signature, post_date, status, batch
    ) VALUES (
        :trxnref, :customer_name, :first_name, :last_name, :state, :city, :phone_no,
        :occupation, :address, :landmark, :alias, :company, :agent, :client,
        :post_by, :signature, :post_date, :status, :batch
    )');

    $stmt->execute([
        ':trxnref' => $trxnref,
        ':customer_name' => $customer_name,
        ':first_name' => $first_name,
        ':last_name' => $last_name,
        ':state' => $state,
        ':city' => $city,
        ':phone_no' => $phone_no,
        ':occupation' => $occupation,
        ':address' => $address,
        ':landmark' => $landmark,
        ':alias' => $alias,
        ':company' => $company,
        ':agent' => $agent,
        ':client' => $client,
        ':post_by' => $post_by,
        ':signature' => $signature,
        ':post_date' => $post_date,
        ':status' => $status,
        ':batch' => $batch,
    ]);

    echo json_encode(["status" => "success", "message" => "Successfully inserted", "reference" => $trxnref]);
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(["status" => "error", "message" => "Database error.", "details" => $e->getMessage()]);
}
?>
