<?php
	function convert_number_to_words($number) {
    
    $hyphen      = '-';
    $conjunction = ' and ';
    $separator   = ', ';
    $negative    = 'negative ';
    $decimal     = ' point ';
    $dictionary  = array(
        0                   => 'Zero',
        1                   => 'One',
        2                   => 'Two',
        3                   => 'Three',
        4                   => 'Four',
        5                   => 'Five',
        6                   => 'Six',
        7                   => 'Seven',
        8                   => 'Eight',
        9                   => 'Nine',
        10                  => 'Ten',
        11                  => 'Eleven',
        12                  => 'Twelve',
        13                  => 'Thirteen',
        14                  => 'Fourteen',
        15                  => 'Fifteen',
        16                  => 'Sixteen',
        17                  => 'Seventeen',
        18                  => 'Eighteen',
        19                  => 'Nineteen',
        20                  => 'Twenty',
        30                  => 'Thirty',
        40                  => 'Fourty',
        50                  => 'Fifty',
        60                  => 'Sixty',
        70                  => 'Seventy',
        80                  => 'Eighty',
        90                  => 'Ninety',
        100                 => 'Hundred',
        1000                => 'Thousand',
        1000000             => 'Million',
        1000000000          => 'Billion',
        1000000000000       => 'Trillion',
        1000000000000000    => 'Quadrillion',
        1000000000000000000 => 'Quintillion'
    );
    
    if (!is_numeric($number)) {
        return false;
    }
    
    if (($number >= 0 && (int) $number < 0) || (int) $number < 0 - PHP_INT_MAX) {
        // overflow
        trigger_error(
            'convert_number_to_words only accepts numbers between -' . PHP_INT_MAX . ' and ' . PHP_INT_MAX,
            E_USER_WARNING
        );
        return false;
    }

    if ($number < 0) {
        return $negative . convert_number_to_words(abs($number));
    }
    
    $string = $fraction = null;
    
    if (strpos($number, '.') !== false) {
        list($number, $fraction) = explode('.', $number);
    }
    
    switch (true) {
        case $number < 21:
            $string = $dictionary[$number];
            break;
        case $number < 100:
            $tens   = ((int) ($number / 10)) * 10;
            $units  = $number % 10;
            $string = $dictionary[$tens];
            if ($units) {
                $string .= $hyphen . $dictionary[$units];
            }
            break;
        case $number < 1000:
            $hundreds  = $number / 100;
            $remainder = $number % 100;
            $string = $dictionary[$hundreds] . ' ' . $dictionary[100];
            if ($remainder) {
                $string .= $conjunction . convert_number_to_words($remainder);
            }
            break;
        default:
            $baseUnit = pow(1000, floor(log($number, 1000)));
            $numBaseUnits = (int) ($number / $baseUnit);
            $remainder = $number % $baseUnit;
            $string = convert_number_to_words($numBaseUnits) . ' ' . $dictionary[$baseUnit];
            if ($remainder) {
                $string .= $remainder < 100 ? $conjunction : $separator;
                $string .= convert_number_to_words($remainder);
            }
            break;
    }
    
    if (null !== $fraction && is_numeric($fraction)) {
        $string .= $decimal;
        $words = array();
        foreach (str_split((string) $fraction) as $number) {
            $words[] = $dictionary[$number];
        }
        $string .= implode(' ', $words);
    }
    
    return $string;
} 
    require_once ('../../con.php');
    
	$client = $_POST['client'];
	$db = new mysqli(hosth, db_userh, db_passh, db_nameh);
    if (!$db) {
    exit('Connect Error (' . mysqli_connect_errno() . ') '
         . mysqli_connect_error());
    }
    $category = "SELECT* FROM `clients` WHERE `username` = '$client'";
    $cat = mysqli_query($db, $category);
    $clt=mysqli_fetch_assoc($cat);
    
    $name = $clt['name'];
    $address = $clt['address'];
    $sitio = $clt['website'];
    $correo = $clt['email'];
    $phone = $clt['tel'];
    
	$vendor = $_POST['vendor'];
	$surfix = substr("$vendor",0,2);
	$db = new mysqli(hosth, db_userh, db_passh, db_nameh);
    if (!$db) {
    exit('Connect Error (' . mysqli_connect_errno() . ') '
         . mysqli_connect_error());
    }
    $category = "SELECT* FROM `vendor` WHERE `username` = '$vendor'";
    $cat = mysqli_query($db, $category);
    $vnd=mysqli_fetch_assoc($cat);
    
    $nom = $vnd['name'];
    $addresse = $vnd['address'];
    $site = $vnd['website'];
    $email = $vnd['email'];
    $tele = $vnd['tel'];
    $logo = '../images/'.$vnd['logo'];
	
	$year = $_POST['year'];
	$month = $_POST['month'];
	$day = $_POST['day'];
	$cav_accepted = $_POST['cav_accepted'];
	$applied_rate = $_POST['applied_rate'];
	$date = $day.'/'.$month.'/'.$year;
	$desc = "CAV Reports for ". $month .', '. $year .'.';
	$number = $cav_accepted * $applied_rate;
	
	$new = convert_number_to_words($number);
	
	$acc_name = $_POST['acc_name'];
	$acc_no = $_POST['acc_no'];
	$acc_type = $_POST['acc_type'];
	$bank = $_POST['bank'];

	require('../WriteHTML.php');

	$pdf=new PDF_HTML();

	$pdf->AliasNbPages();
	$pdf->SetAutoPageBreak(true, 15);

	$pdf->AddPage();
	$pdf-> Image("{$logo}",10,6,200);
	$pdf-> SetFont ("Arial", "B", "20");
    $pdf-> Ln(55);
	
	$pdf-> SetFont ("Arial", "B", "13");
	$pdf-> Cell (30, 10, "Name :", 0, 0);
	$pdf-> SetFont ("Arial", "", "12");
	$pdf-> Cell (85, 10, "{$name}", 0, 0);
	
	$pdf-> SetFont ("Arial", "B", "13");
	$pdf-> Cell (20, 10, "Date : ", 0, 0, "R");
	$pdf-> SetFont ("Arial", "", "12");
	$pdf-> Cell (40, 10, "{$date}", 0, 1, "R");
	
	$pdf-> SetFont ("Arial", "B", "13");
	$pdf-> Cell (30, 10, "Address :", 0, 0);
	$pdf-> SetFont ("Arial", "", "12");
	$pdf-> Cell (85, 10, "{$address}", 0, 0);
	
	$pdf-> SetFont ("Arial", "B", "13");
	$pdf-> Cell (33, 10, "Invoice No : ", 0, 0, "R");
	$pdf-> SetFont ("Arial", "", "12");
	$pdf-> Cell (36, 10, "DB/{$surfix}/{$month}/{$year}", 0, 1, "R");
	
	$pdf-> SetFont ("Arial", "B", "13");
	$pdf-> Cell (25, 10, "Phone No :", 0, 0);
	$pdf-> SetFont ("Arial", "", "12");
	$pdf-> Cell (85, 10, "{$phone}", 0, 0);
	
	$pdf-> SetFont ("Arial", "B", "13");
	$pdf-> Cell (23, 10, "Rep : ", 0, 0, "R");
	$pdf-> SetFont ("Arial", "", "12");
	$pdf-> Cell (57, 10, "{$rep}", 0, 1, "R");
	
	$pdf-> Ln(15);
	
	$pdf-> SetFont ("Arial", "B", "13");
	$pdf-> Cell (30, 10, "Quantity", 1, 0);
	$pdf-> Cell (80, 10, "Description", 1, 0);
	$pdf-> Cell (35, 10, "Rate(N)", 1, 0);
	$pdf-> Cell (45, 10, "Amount", 1, 1);
	
	$pdf-> SetFont ("Arial", "", "12");
	$pdf-> Cell (30, 20, "{$cav_accepted}", 1, 0);
	$pdf-> Cell (80, 20, "{$desc}", 1, 0);
	$pdf-> Cell (35, 20, "{$applied_rate}", 1, 0);
	$pdf-> Cell (45, 20, "{$number}", 1, 1);
		
	$pdf-> SetFont ("Arial", "B", "12");
	$pdf-> Cell (145, 10, "Total", 1, 0);
	$pdf-> Cell (45, 10, "{$number}", 1, 1);
	
	$pdf-> Ln(10);
	
	
	
	
	$pdf-> SetFont ("Arial", "B", "13");
	$pdf-> Cell (50, 10, "Amount in Words :", 0, 1);
	$pdf-> SetFont ("Arial", "", "12");
	$pdf-> MultiCell (0, 10, "{$new} Naira Only.", 0, 1);
	
	$pdf-> Ln(10);
	
	$pdf-> SetFont ("Arial", "B", "13");
	$pdf-> Cell (45, 10, "Account Details", 1, 0);
	
	$pdf-> Ln(10);
	
	$pdf-> SetFont ("Arial", "B", "13");
	$pdf-> Cell (45, 10, "Acc Name :", 0, 0);
	$pdf-> SetFont ("Arial", "", "12");
	$pdf-> Cell (75, 10, "{$acc_name}", 0, 1);
	
	$pdf-> SetFont ("Arial", "B", "13");
	$pdf-> Cell (45, 10, "Acc Number :", 0, 0);
	$pdf-> SetFont ("Arial", "", "12");
	$pdf-> Cell (75, 10, "{$acc_no}", 0, 1);
	
	$pdf-> SetFont ("Arial", "B", "13");
	$pdf-> Cell (45, 10, "Account Type :", 0, 0);
	$pdf-> SetFont ("Arial", "", "12");
	$pdf-> Cell (75, 10, "{$acc_type}", 0, 1);
	
	$pdf-> SetFont ("Arial", "B", "13");
	$pdf-> Cell (45, 10, "Bank :", 0, 0);
	$pdf-> SetFont ("Arial", "", "12");
	$pdf-> Cell (75, 10, "{$bank}", 0, 1);
	
	
	$pdf-> Image('foot.png',10,250,75);
	$pdf->Output(); 
?>