<?php
session_start();
require_once("class.user.php");
$login = new USER();

// Redirect if already logged in
if ($login->is_loggedin() != "") {
    $login->redirect('home');
}

// Initialize error and vendor
$error = '';
$ini_vendor = isset($_GET['vendor']) ? htmlspecialchars(trim($_GET['vendor'])) : '';

// Login attempt
if (isset($_POST['btn-login'])) {
    $uname = htmlspecialchars(trim($_POST['txt_uname_email']));
    $umail = $uname; // same field
    $upass = htmlspecialchars(trim($_POST['txt_password']));

    if ($login->doLogin($uname, $umail, $upass)) {
        $login->redirect('home');
    } else {
        $error = "Wrong Details!";
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1" />
<title>Login | AVR Portal</title>
<!-- [favicon] begin -->
<link rel="icon" href="https://sylvianettebox.net/favicon.ico" />
<!-- [favicon] end -->
<link href="../bootstrap/css/bootstrap.min.css" rel="stylesheet">
<link href="../bootstrap/css/bootstrap-theme.min.css" rel="stylesheet">
<link rel="stylesheet" href="style.css" type="text/css" />
<style>
    .toggle-password {
        cursor: pointer;
        position: absolute;
        right: 10px;
        top: 8px;
        font-size: 14px;
        color: #007bff;
    }
    .password-wrapper {
        position: relative;
    }
</style>
</head>
<body>

<div class="signin-form">
    <div class="container">
        <form class="form-signin" method="post" id="login-form">
            <hr />
            <center>
                <?php
                $vendor_logos = ['Royusuf', 'XGlobal', 'IDAzeke', 'TierraCasa', 'OBrien', 'Simrheam'];
                if (in_array($ini_vendor, $vendor_logos)) {
                    echo "<img width='50%' src='../../{$ini_vendor}Logo.png'/>";
                } else {
                    echo "<img width='25%' src='../../Logo.png'/>";
                }
                ?>
            </center>
            <hr />

            <?php if (!empty($error)) : ?>
                <div class="alert alert-danger">
                    <i class="glyphicon glyphicon-warning-sign"></i> &nbsp; <?= $error ?>
                </div>
            <?php endif; ?>

            <center><h4 class="form-signin-heading"><b>[Vendor &amp; Admins]</b></h4></center>

            <div class="form-group">
                <input type="text" class="form-control" name="txt_uname_email" placeholder="UserID / Email" required />
            </div>

            <div class="form-group password-wrapper">
                <input type="password" class="form-control" name="txt_password" id="password" placeholder="Your Password" required />
                <span class="toggle-password" onclick="togglePassword()">Show</span>
            </div>

            <hr />

            <div class="form-group">
                <button type="submit" name="btn-login" class="btn btn-default">
                    <i class="glyphicon glyphicon-log-in"></i>&nbsp; SIGN IN
                </button>
                &nbsp; | &nbsp;
                <label><a href="#">Recover Password</a></label>
            </div>
            <i>...CAVPortal 3.2</i>
        </form>
    </div>
</div>

<script>
function togglePassword() {
    const passField = document.getElementById("password");
    const toggle = document.querySelector(".toggle-password");
    if (passField.type === "password") {
        passField.type = "text";
        toggle.textContent = "Hide";
    } else {
        passField.type = "password";
        toggle.textContent = "Show";
    }
}
</script>

</body>
</html>
