<?php
    $r_num_length = 7; 
	$r_num = uniqid(rand(),0); 
	$r_num = strip_tags(stripslashes($r_num)); 
	$r_num = str_replace(".","",$r_num); 
	$r_num = strrev(str_replace("/","",$r_num)); 
	$r_num = substr($r_num,7,$r_num_length);
	require 'cabeza.php';
	
	require_once 'tdbconfig.php';
	
	if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['add-btn'])) {
        require_once '../../con.php';
    
        // Initialize database connection using PDO
        try {
            $pdo = new PDO("mysql:host=" . hosth . ";dbname=" . db_nameh, db_userh, db_passh);
            $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        } catch (PDOException $e) {
            die("Database connection failed: " . $e->getMessage());
        }
    
        // Clean and default POST input
        function cleanInput($key) {
            return !empty($_POST[$key]) ? trim($_POST[$key]) : 'N/A';
        }
    
        $trxnref       = cleanInput('trxnref');
        $customer_name = cleanInput('customer_name');
        $first_name    = cleanInput('first_name');
        $last_name     = cleanInput('last_name');
        $state         = cleanInput('state');
        $city          = cleanInput('city');
        $phone_no      = cleanInput('phone_no');
        $occupation    = cleanInput('occupation');
        $address       = cleanInput('address');
        $landmark      = cleanInput('landmark');
        $alias         = cleanInput('alias');
        $company       = cleanInput('company');
        $agent         = cleanInput('agent');
        $client        = cleanInput('client');
        $batch         = cleanInput('batch');
    
        // These should be securely obtained from session or context
        $signature = $usario ?? 'N/A';
        $post_by   = $usario ?? 'N/A';
        $status    = 'Undone';
        $post_date = date("Y-m-d h:i:sa");
    
        // Duplicate check
        $checkStmt = $pdo->prepare("
            SELECT trxnref, customer_name, first_name, last_name, address, company 
            FROM jobs 
            WHERE trxnref = :trxnref 
               OR customer_name = :customer_name 
               OR first_name = :first_name 
               OR last_name = :last_name 
               OR address = :address 
               OR company = :company
            LIMIT 1
        ");
    
        $checkStmt->execute([
            ':trxnref'       => $trxnref,
            ':customer_name' => $customer_name,
            ':first_name'    => $first_name,
            ':last_name'     => $last_name,
            ':address'       => $address,
            ':company'       => $company
        ]);
    
        $duplicate = $checkStmt->fetch(PDO::FETCH_ASSOC);
        $error = [];
        $success = [];
        if ($duplicate) {
            if ($duplicate['trxnref'] === $trxnref) $error[] = "Ref No exists";
            if ($duplicate['customer_name'] === $customer_name && $customer_name !== 'N/A') $error[] = "Customer Name exists";
            if ($duplicate['first_name'] === $first_name && $first_name !== 'N/A') $error[] = "First Name exists";
            if ($duplicate['last_name'] === $last_name && $last_name !== 'N/A') $error[] = "Last Name exists";
            if ($duplicate['address'] === $address) $error[] = "Address exists";
            if ($duplicate['company'] === $company && $company !== 'N/A') $error[] = "Company exists";
        }
    
        if (empty($error)) {
            try {
                $insert = $pdo->prepare("
                    INSERT INTO jobs (
                        trxnref, customer_name, first_name, last_name, state, city, phone_no, occupation,
                        address, landmark, alias, company, agent, client, post_by, signature, post_date, status, batch
                    ) VALUES (
                        :trxnref, :customer_name, :first_name, :last_name, :state, :city, :phone_no, :occupation,
                        :address, :landmark, :alias, :company, :agent, :client, :post_by, :signature, :post_date, :status, :batch
                    )
                ");
    
                $insert->execute([
                    ':trxnref'       => $trxnref,
                    ':customer_name' => $customer_name,
                    ':first_name'    => $first_name,
                    ':last_name'     => $last_name,
                    ':state'         => $state,
                    ':city'          => $city,
                    ':phone_no'      => $phone_no,
                    ':occupation'    => $occupation,
                    ':address'       => $address,
                    ':landmark'      => $landmark,
                    ':alias'         => $alias,
                    ':company'       => $company,
                    ':agent'         => $agent,
                    ':client'        => $client,
                    ':post_by'       => $post_by,
                    ':signature'     => $signature,
                    ':post_date'     => $post_date,
                    ':status'        => $status,
                    ':batch'         => $batch
                ]);
    
                $success[] = "<b>$trxnref</b> Request Successfully PoSTED to <b>$agent</b>";
            } catch (PDOException $e) {
                $error[] = "Database Submission Error: " . $e->getMessage();
            }
        } else {
            $error[] = "Unable to submit due to validation errors.";
        }
    }
    if (isset($_POST['update-btn'])) {
        // Helper to fallback to "N/A"
        function clean_input($field) {
            return !empty($_POST[$field]) ? htmlspecialchars($_POST[$field], ENT_QUOTES, 'UTF-8') : "N/A";
        }
    
        $llave         = $_POST['llave'];
        $trxnref       = clean_input('trxnref');
        $customer_name = clean_input('customer_name');
        $first_name    = clean_input('first_name');
        $last_name     = clean_input('last_name');
        $state         = clean_input('state');
        $city          = clean_input('city');
        $phone_no      = clean_input('phone_no');
        $occupation    = clean_input('occupation');
        $address       = clean_input('address');
        $landmark      = clean_input('landmark');
        $alias         = clean_input('alias');
        $company       = clean_input('company');
        $agent         = clean_input('agent');
        $client        = clean_input('client');
        $status        = clean_input('status');
        $error = [];
        $success = [];
        // Assuming $usario is defined in session or earlier
        $signature = $post_by = isset($usario) && !empty($usario) ? $usario : "N/A";
    
        if (empty($errMSG)) {
            $stmt = $DB_con->prepare('UPDATE `jobs` 
                SET 
                    `customer_name` = :cme, `first_name` = :fme, `last_name` = :lme, 
                    `state` = :ste, `city` = :cty, `phone_no` = :pno, `occupation` = :ocp, 
                    `address` = :add, `landmark` = :lmk, `alias` = :als, `company` = :cpy, 
                    `agent` = :agt, `post_by` = :pby, `status` = :stt
                WHERE `j_id` = :llv');
    
            $stmt->bindParam(':cme', $customer_name);
            $stmt->bindParam(':fme', $first_name);
            $stmt->bindParam(':lme', $last_name);
            $stmt->bindParam(':ste', $state);
            $stmt->bindParam(':cty', $city);
            $stmt->bindParam(':pno', $phone_no);
            $stmt->bindParam(':ocp', $occupation);
            $stmt->bindParam(':add', $address);
            $stmt->bindParam(':lmk', $landmark);
            $stmt->bindParam(':als', $alias);
            $stmt->bindParam(':cpy', $company);
            $stmt->bindParam(':agt', $agent);
            $stmt->bindParam(':pby', $post_by);
            $stmt->bindParam(':stt', $status);
            $stmt->bindParam(':llv', $llave);
    
            if ($stmt->execute()) {
                $success[] = "<b>$trxnref</b> Request Successfully Updated for <b>$agent</b>";
            } else {
                $error[] = "Update failed, please try again.";
            }
        }
    }

    if (isset($_POST['btn-upload'])){
        
    	$client = $_POST['client'];
        $file = $_FILES['csv-upload']['tmp_name'];
        $handle = fopen($file, "r");
        $exito = [];
        $error = [];
        while(($fileop = fgetcsv($handle,1000, ","))  !==false){
            $r_num_length = 7; 
        	$r_num = uniqid(rand(),0); 
        	$r_num = strip_tags(stripslashes($r_num)); 
        	$r_num = str_replace(".","",$r_num); 
        	$r_num = strrev(str_replace("/","",$r_num)); 
        	$r_num = substr($r_num,7,$r_num_length);
    	    require('../../tab3.php');
            $post_by = $usario;
            $signature = $usario;
            $status = 'Undone';
            $post_date = date("Y-m-d h:i:sa");
    		try
    		{
    			$stmt = $auth_user->runQuery("SELECT `trxnref` FROM `jobs` WHERE `trxnref`=:txn");
    			$stmt->execute(array(':txn'=>$trxnref));
    			$row=$stmt->fetch(PDO::FETCH_ASSOC);
    				
    			if($row['trxnref']==$trxnref) {
    				$error[] = $trxnref." Exists";
    			}
    			if(empty($error))
    			{
    				if($auth_user->bulk($trxnref, $customer_name, $first_name, $last_name, $state, $city, $phone_no, $occupation, $address, $landmark, $alias, $company, $agent ,$client, $post_by, $signature, $post_date, $status, $batch)){
        				$exito[] = $trxnref;
        					
    				}
    			}
    		}
    		catch(PDOException $e)
    		{
    			echo $e->getMessage();
    		}
        }
        if(!empty($exito)){
            $nm = count($exito);
            $success = $nm.' Jobs Successfully Uploaded';
        }
    }
    if(isset($_GET['borrar'])){
        $llave = $_GET['borrar'];
        
        $stmt = $DB_con->prepare('DELETE FROM `jobs`
                                WHERE `j_id`=:llv');
        $stmt->bindParam(':llv',$llave);
        
            if($stmt->execute())
            {
                $success = $llave." Deleted Successfully";
                $borrar = 'Si';
            }
            else
            {
                $error[] = 'Delete Unsuccessful';
            }
    }
    if(isset($_POST['delete-execute'])){
        $agent = $_POST['agent'];
        $client = $_POST['client'];
		$ref_no = $_POST['ref_no'];
		$where = NULL;
			
		if(!empty($agent)){
			if($agent == 'All'){
				$where .= "WHERE `status`='Undone' AND `client` = '$client' AND `signature`='$usario'";
			}else{
				$where .= "WHERE `agent` = '$agent' AND `client` = '$client' AND `status`='Undone' AND `signature`='$usario'";
			}
		}elseif(!empty($ref_no)){
			$where .= "WHERE `trxnref` = '$ref_no' AND `status`='Undone' AND `signature`='$usario'";
		}
        
        $stmt = $DB_con->prepare("DELETE FROM `jobs` $where");
        
            if($stmt->execute())
            {
                $success = " Deleted Successfully";
                $borrar = 'Si';
            }
            else
            {
                $error[] = 'Delete Unsuccessful';
            }
    }
    if(isset($_POST['multi'])){
        $checkbox = $_POST['checkbox'];
        if($_POST['action'] == 'delete'){
            $fbk = NULL;
            foreach($checkbox as $del_id){
                $stmt = $DB_con->prepare("DELETE FROM `jobs` WHERE `trxnref` = '$del_id' AND `status`='Undone' AND `signature`='$usario'");
                $fbk .=$del_id.' ';
                $stmt->execute();
            }
            if($stmt->execute())
            {
               ?>
                        <script>
                        alert('Deleted Sucessfully! <?php echo $fbk ?>');
                        window.location.href='requested-jobs';
                        </script>
                      
                <?php
            }
            else
            {
            ?>
                    <script>
                    alert('Failed, please try again');
                    window.location.href='requested-jobs';
                    </script>
            <?php
            }
        }
        if($_POST['action'] == 'assign'){
            $agent = $_POST['agent'];
            if(!empty ($agent)){
                $fbk = NULL;
                foreach($checkbox as $job_id){
                    $stmt = $DB_con->prepare("UPDATE `jobs` SET `agent`='$agent'WHERE `trxnref`='$job_id'");
                    $fbk .=$job_id.' ';
                    $stmt->execute();
                }
            }else{
                $falla ='No agent selected';
            }
            if($stmt->execute())
            {
               ?>
                        <script>
                        alert('<?php echo $fbk ?> Sucessfully Assigned to <?php echo $agent ?>');
                        window.location.href='requested-jobs';
                        </script>
                      
                <?php
            }
            else
            {
            ?>
                    <script>
                    alert('Failed, please try again [ <?php echo $falla ?>]');
                    window.location.href='requested-jobs';
                    </script>
            <?php
            }
        }
    }
?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head><meta http-equiv="Content-Type" content="text/html; charset=utf-8">

<meta name="viewport" content="width=device-width, initial-scale=1" />
<link href="../bootstrap/css/bootstrap.min.css" rel="stylesheet" media="screen">
<link href="../bootstrap/css/bootstrap-theme.min.css" rel="stylesheet" media="screen">
<link href="../datatables/css/dataTables.bootstrap.min.css" rel="stylesheet" media="screen">
<!-- [favicon] begin -->
<link rel="shortcut icon" type="image/x-icon" href="https://www.sylvianettebox.net/favicon.ico" />
<link rel="icon" type="image/x-icon" href="https://www.sylvianettebox.net/favicon.ico" />
<!-- [favicon] end -->

<script type="text/javascript" src="jquery-1.11.3-jquery.min.js"></script>
<link rel="stylesheet" href="style.css" type="text/css"  />
<style>
    #agentt {
      display: none;
    }
    
    #agentt.show {
      display: inline;
    }
</style>
<title>Requested Jobs (<?php print($userRow['username']); ?>) | AVR Portal</title>
<script>
function showFields(str) {
    if (str == "") {
        document.getElementById("txtHint").innerHTML = "";
        return;
    } else { 
        if (window.XMLHttpRequest) {
            // code for IE7+, Firefox, Chrome, Opera, Safari
            xmlhttp = new XMLHttpRequest();
        } else {
            // code for IE6, IE5
            xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
        }
        xmlhttp.onreadystatechange = function() {
            if (this.readyState == 4 && this.status == 200) {
                document.getElementById("txtHint").innerHTML = this.responseText;
            }
        };
        xmlhttp.open("GET","morefields.php?q="+str,true);
        xmlhttp.send();
    }
}
</script>
</head>

<body>

    <?php 
        $page = 'requests';
        $page1 = 'request';
        include ('include/nav.php');
    ?>

    <div class="clearfix"></div>
    	
    
    <div class="container-fluid" style="margin-top:80px;">
	
        <div class="container">
    
    	<label class="h5">Requested Jobs | <?php print $usario; ?></label>
        <hr />
        <div class="panel panel-primary" id="adminn">
            <?php
            echo $checkbox[$i];
            if(isset($errMSG)){ ?>
                <div class="alert alert-danger">
                    <button class='close' data-dismiss='alert'>&times;</button>
                    <center><?php echo $errMSG; ?></center>
                  
                </div>
            <?php }
			require_once ('../../con.php');
			$connect = mysqli_connect(hosth, db_userh, db_passh, db_nameh);
			
			$query ="SELECT* FROM jobs WHERE `status` ='Undone' AND `agent` != 'N/A' AND `agent` IS NOT NULL AND `signature` = '$usario' ORDER BY `j_id` DESC";
			$result = mysqli_query($connect, $query);
			$rowcount=mysqli_num_rows($result);
			$td = NULL;
			while($row = mysqli_fetch_array($result))
			{   $actual = date("Y/m/d h:i:sa");
			    $start = strtotime($row["post_date"]);
                $end   = strtotime($actual);
                $diff  = $end - $start;
                $hours = floor($diff / (60 * 60));
                $tat = $hours .  'hrs';
			    require ('../../tab1.php');
			}
			mysqli_close($connect);
			?>
            <div class="panel-heading">
                <h1 class="panel-title"><strong><center><?php echo $rowcount ?> Pending Jobs</center></strong></h1>
            </div>
            <div class="panel-body">
                <form method="post" class="form-inline">
                <a title="Add New Job" data-toggle="modal" href="#add-new" class="btn btn-primary"><i class="glyphicon glyphicon-plus"></i>&nbsp;<strong>Add</strong></a> | <a title="Add Bulk" data-toggle="modal" href="#add-bulk" class="btn btn-primary"><i class="glyphicon glyphicon-list"></i>&nbsp;<strong>Bulk</strong></a><div class="form-group" style="float:right"><div class="form-group"><select id="actionn" name="action" class="form-control" required><option value="">Action</option><option value="assign">Assign</option><option value="delete">Delete</option></select></div><?php require_once ('../../con.php'); $db = new mysqli(hosth, db_userh, db_passh, db_nameh); if (!$db) { exit('Connect Error ('. mysqli_connect_error());}?><div class="form-group"><select id="agentt" name="agent" class="form-control"><option value="">Select Agent</option><?php $gender = "SELECT `username`, `name` FROM `staffs` WHERE `dept` = 'CAV' AND `post_by` = '$usario' AND `status` = 'Active' ORDER BY `name` ASC"; $gen = mysqli_query($db, $gender); while ( $d=mysqli_fetch_assoc($gen)) { echo "<option value='".$d['name']."'>".$d['name']."</option>"; } ?></select></div><div class="form-group"><button type="submit" onclick="return confirm('Proceed ?')" name="multi" class="btn btn-primary"><i class="glyphicon glyphicon-check"></i>&nbsp;Go</button></div></div><br><br>
                
				<div class="table-responsive" id="employee_table">
					<table class="table table-striped table-bordered table-hover" id="mydata">
						<thead>
			    				<tr>
    								<th></th>
    								<th>Action</th>
    								<th>Ref</th>
    								<th>Customer Name</th>
    								<th>Customer Address</th>
    								<th>City</th>
    								<th>State</th>
    								<th>Tel.</th>
    								<th>Agent</th>
    								<th>TAT</th>
    								<th>Client</th>
    								<th>Batch No.</th>
								</tr>
				    		</thead>
						<tbody>
							<?php echo $td ?>
						</tbody>
					</table>
			    </div>
				</form>
            </div>
        </div>
        <div id="add-new" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" data-backdrop="static" data-keyboard="false" aria-hidden="true" style="display: none;">
            <div class="modal-dialog"> 
                <div class="modal-content"> 
                    <div class="modal-header"> 
                        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button> 
                        <h4 class="modal-title">
                        	<center><i class="glyphicon glyphicon-plus"></i>&nbsp;Add Job</center>
                        </h4> 
                    </div> 
                    <div class="modal-body"> 
                        <form class="form-signin" method="post" id="login-form" enctype="multipart/form-data">
                            <div class="form-group">
                    			<select name="client" class="form-control" onchange="showFields(this.value)" required>
                    				<option value="">Select Client</option>
                    				<?php
                	                  require_once ('../../con.php');
                	                  $db = new mysqli(hosth, db_userh, db_passh, db_nameh);
                        			  if (!$db) {
                        			    exit('Connect Error (' . mysqli_connect_errno() . ') '
                        			         . mysqli_connect_error());
                        			  }
                	                  $gender = "SELECT `client` FROM `connect` WHERE `vendor` = '$usario' ORDER BY `client` ASC";
                	                  $gen = mysqli_query($db, $gender);
                	                  while ( $d=mysqli_fetch_assoc($gen)) {
                	                  echo "<option value='".$d['client']."'>".$d['client']."</option>";
                	                  }
                	                ?>
                    			</select>
                    		</div>
                    		<div id="txtHint"></div>
                	        <div class="form-group">
            	              <select name="agent" class="form-control">
            	                <option value="">Select Agent</option>
            	                <?php
            	                  $gender = "SELECT `username`, `name` FROM `staffs` WHERE `dept` = 'CAV' AND `post_by` = '$usario' AND `status` = 'Active' ORDER BY `name` ASC";
            	                  $gen = mysqli_query($db, $gender);
            	                  while ( $d=mysqli_fetch_assoc($gen)) {
            	                  echo "<option value='".$d['name']."'>".$d['name']."</option>";
            	                  }
            	                ?>
            	              </select>
                            </div>
                            <div class="form-group">
                	            <input type="text" class="form-control" name="batch" placeholder="Batch No." />
                	        </div>
                    		<div class="form-group">
                	            <input type="text" class="form-control" name="signature" value="<?php echo $usario ?>" placeholder="Signature" required readonly/>
                	        </div>
                	        <div class="form-group">
                	            <button type="submit" onclick="return confirm('Are you sure you want to submit job ?')" name="add-btn" class="btn btn-primary">
                	                <i class="glyphicon glyphicon-save-file"></i>&nbsp;Submit
                	            </button>
                	        </div> 
                        </form>
                    </div> 
                    <div class="modal-footer"> 
                          <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>  
                    </div> 
                    
                </div> 
            </div>
        </div><!-- /.modal --> 
        <div id="add-bulk" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" data-backdrop="static" data-keyboard="false" aria-hidden="true" style="display: none;">
            <div class="modal-dialog"> 
                <div class="modal-content"> 
                    <div class="modal-header"> 
                        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button> 
                        <h4 class="modal-title">
                        	<center><i class="glyphicon glyphicon-list"></i>&nbsp;Bulk Upload</center>
                        </h4> 
                        <?php
                          $csv = NULL;
    	                  $gender = "SELECT `csv`, `client` FROM `connect` WHERE `vendor` = '$usario'";
    	                  $gen = mysqli_query($db, $gender);
    	                  while ( $d=mysqli_fetch_assoc($gen)) {
                   		  $csv .='<a href="'.$d['csv'].'" download title="Always remove headers before upload" class="btn btn-default"><i class="glyphicon glyphicon-file"></i>&nbsp;<strong>'.$d['client'].'</strong></a> | ';
    	                  }
    	                ?>
                        <center><?php echo $csv ?></center>
                    </div> 
                    <div class="modal-body">
                        <form method="post" enctype="multipart/form-data" class="form-signin">
                            <label>Select Client</label>
                            <div class="form-group">
                            	<select name="client" class="form-control" required>
                            		<option value="">Select</option>
                            		<?php
                	                  $gender = "SELECT `client` FROM `connect` WHERE `vendor` = '$usario' ORDER BY `client` ASC";
                	                  $gen = mysqli_query($db, $gender);
                	                  while ( $d=mysqli_fetch_assoc($gen)) {
                	                  echo "<option value='".$d['client']."'>".$d['client']."</option>";
                	                  }
                	                ?>
                            	</select>
                            </div>
            		        <div class="form-group">
            		            <input type="file" id="company" class="form-control" name="csv-upload" />
            		        </div>
                            <div class="form-group">  
                                <button type="submit" class="btn btn-primary" onclick="return confirm('Are you sure you want to upload file ?')" name="btn-upload">
                                    <i class="glyphicon glyphicon-open-file"></i>&nbsp;Upload
                                </button>
            	            </div>
                        </form>
                    </div> 
                    <div class="modal-footer"> 
                          <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>  
                    </div> 
                    
                </div> 
            </div>
        </div><!-- /.modal -->
        <div id="delete" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" data-backdrop="static" data-keyboard="false" aria-hidden="true" style="display: none;">
            <div class="modal-dialog"> 
                <div class="modal-content"> 
                    <div class="modal-header"> 
                        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button> 
                        <h4 class="modal-title">
                        	<center><i class="glyphicon glyphicon-trash"></i>&nbsp;Delete Jobs</center>
                        </h4> 
                    </div> 
                    <div class="modal-body"> 
                        <form method="post" enctype="multipart/form-data" class="form-signin">
                    	    <label>Delete All &amp; by Agent</label>
                    	    <div class="form-group">
                         	    <select name="agent" class="form-control">
                                    <option value="">Select Target</option>
                                    <option value="All">All Requested Jobs</option>
                                    <?php
                                      $gender = "SELECT `username`, `name` FROM `staffs` WHERE `dept` = 'CAV' AND `post_by` = '$usario' AND `status` = 'Active' ORDER BY name ASC";
                                      $gen = mysqli_query($db, $gender);
                                      while ( $d=mysqli_fetch_assoc($gen)) {
                                      echo "<option value='".$d['name']."'>All ".$d['name']."</option>";
                                      }
                                    ?>
                                </select>
            		        </div>
            		        <label>Delete by Client</label>
            	            <div class="form-group">
            	                <select name="client" class="form-control" required>
                                    <option value="">Select Client</option>
                    				<?php
                	                  $gender = "SELECT `client` FROM `connect` WHERE `vendor` = '$usario' ORDER BY `client` ASC";
                	                  $gen = mysqli_query($db, $gender);
                	                  while ( $d=mysqli_fetch_assoc($gen)) {
                	                  echo "<option value='".$d['client']."'>".$d['client']."</option>";
                               		  $db = NULL;
                	                  }
                	                ?>
                                </select>
            	            </div>
            	            <label>Delete by Ref No.</label>
            	            <div class="form-group">
            	                <input type="text" class="form-control" name="ref_no" placeholder="Enter Reference Number"/>
            	            </div>
            	            <div class="form-group">
            	              <button type="submit" class="btn btn-primary" onclick="return confirm('Are you sure you want to execute ?')" name="delete-execute">
            	                  <i class="glyphicon glyphicon-trash"></i>&nbsp;Delete
            	              </button>
            	            </div>
            	        </form>
                    </div> 
                    <div class="modal-footer"> 
                          <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>  
                    </div> 
                    
                </div> 
            </div>
        </div><!-- /.modal -->
        <div id="view-modal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" data-backdrop="static" data-keyboard="false" aria-hidden="true" style="display: none;">
             <div class="modal-dialog"> 
                  <div class="modal-content"> 
                  
                       <div class="modal-header"> 
                            <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                            <h4 class="modal-title">
			                    <center><i class="glyphicon glyphicon-map-marker"></i> Job</center>
                            </h4> 
                       </div> 
                       <div class="modal-body"> 
                       
                       	   <div id="modal-loader" style="display: none; text-align: center;">
                       	   	<img src="ajax-loader.gif">
                       	   </div>
                            
                           <!-- content will be load here -->                          
                           <div id="dynamic-content"></div>
                             
                        </div> 
                        <div class="modal-footer"> 
                              <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>  
                        </div> 
                        
                 </div> 
              </div>
        </div><!-- /.modal -->
        <?php if (!empty($success)) : ?>
        <!-- SUCCESS MODAL -->
        <div id="successful" class="modal fade" tabindex="-1" role="dialog" data-backdrop="static" aria-hidden="true">
            <div class="modal-dialog modal-sm"> 
                <div class="modal-content"> 
                    <div class="modal-header"> 
                        <button type="button" class="close" data-dismiss="modal">&times;</button>
                        <h4 class="modal-title text-center">
                            <i class="glyphicon glyphicon-info-sign"></i>&nbsp;Feedback
                        </h4> 
                    </div> 
                    <div class="modal-body"> 
                        <?php foreach ($success as $msg): ?>
                            <div class="alert alert-success">
                                <i class="glyphicon glyphicon-ok"></i>&nbsp;<?= $msg ?>
                            </div>
                        <?php endforeach; ?>
                    </div> 
                    <div class="modal-footer"> 
                        <?php if (!empty($borrar) && $borrar === 'Si'): ?>
                            <a class="btn btn-danger" href="requested-jobs">Close</a>
                        <?php else: ?>
                            <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
                        <?php endif; ?>
                    </div> 
                </div> 
            </div>
        </div>
        <script>
            $(window).on('load', function() {
                $('#successful').modal('show');
            });
        </script>
        <?php endif; ?>

        <?php if (!empty($error)) : ?>
        <!-- ERROR MODAL -->
        <div id="failed" class="modal fade" tabindex="-1" role="dialog" data-backdrop="static" aria-hidden="true">
            <div class="modal-dialog modal-sm"> 
                <div class="modal-content"> 
                    <div class="modal-header"> 
                        <button type="button" class="close" data-dismiss="modal">&times;</button>
                        <h4 class="modal-title text-center">
                            <i class="glyphicon glyphicon-info-sign"></i>&nbsp;Feedback
                        </h4> 
                    </div> 
                    <div class="modal-body"> 
                        <?php foreach ($error as $err): ?>
                            <div class="alert alert-danger">
                                <i class="glyphicon glyphicon-warning-sign"></i>&nbsp;<?= $err ?>
                            </div>
                        <?php endforeach; ?>
                    </div> 
                    <div class="modal-footer"> 
                        <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
                    </div> 
                </div> 
            </div>
        </div>
        <script>
            $(window).on('load', function() {
                $('#failed').modal('show');
            });
        </script>
        <?php endif; ?>
    </div>
  <?php include 'include/footer.php'; ?>

<script src="../assets/jquery-1.12.4.min.js"></script>
<script src="../assets/js/bootstrap.min.js"></script>
<script src="../datatables/js/jquery.dataTables.min.js"></script>
<script src="../datatables/js/dataTables.bootstrap.min.js"></script>
<script>
    const source = document.querySelector("#actionn");
    const target = document.querySelector("#agentt");
    
    const displayWhenSelected = (source, value, target) => {
        const selectedIndex = source.selectedIndex;
        const isSelected = source[selectedIndex].value === value;
        target.classList[isSelected
            ? "add"
            : "remove"
        ]("show");
    };
    source.addEventListener("change", (evt) =>
        displayWhenSelected(source, "assign", target)
    );
    $('#mydata').dataTable();
    $(document).ready(function(){

    	$(document).on('click', '#see-undone', function(e){
    		
    		e.preventDefault();
    		
    		var uid = $(this).data('id');   // it will get id of clicked row
    		
    		$('#dynamic-content').html(''); // leave it blank before ajax call
    		$('#modal-loader').show();      // load ajax loader
    		
    		$.ajax({
    			url: '../getUndone.php',
    			type: 'POST',
    			data: 'id='+uid,
    			dataType: 'html'
    		})
    		.done(function(data){
    			console.log(data);	
    			$('#dynamic-content').html('');    
    			$('#dynamic-content').html(data); // load response 
    			$('#modal-loader').hide();		  // hide ajax loader	
    		})
    		.fail(function(){
    			$('#dynamic-content').html('<i class="glyphicon glyphicon-info-sign"></i> Something went wrong, Please try again...');
    			$('#modal-loader').hide();
    		});
    		
    	});
    	
    });
    $(document).ready(function(){
    	
    	$(document).on('click', '#edit-undone', function(e){
    		
    		e.preventDefault();
    		
    		var uid = $(this).data('id');   // it will get id of clicked row
    		
    		$('#dynamic-content').html(''); // leave it blank before ajax call
    		$('#modal-loader').show();      // load ajax loader
    		
    		$.ajax({
    			url: '../getUndoneEdit.php',
    			type: 'POST',
    			data: 'id='+uid,
    			dataType: 'html'
    		})
    		.done(function(data){
    			console.log(data);	
    			$('#dynamic-content').html('');    
    			$('#dynamic-content').html(data); // load response 
    			$('#modal-loader').hide();		  // hide ajax loader	
    		})
    		.fail(function(){
    			$('#dynamic-content').html('<i class="glyphicon glyphicon-info-sign"></i> Something went wrong, Please try again...');
    			$('#modal-loader').hide();
    		});
    		
    	});
    	
    });
</script>
</body>
</html>