<?php

require_once('dbconfig.php');

class USER
{	

	private $conn;
	
	public function __construct()
	{
		$database = new Database();
		$db = $database->dbConnection();
		$this->conn = $db;
    }
	
	public function runQuery($sql)
	{
		$stmt = $this->conn->prepare($sql);
		return $stmt;
	}
	
	public function bulk($trxnref, $customer_name, $first_name, $last_name, $state, $city, $phone_no, $occupation, $address, $landmark, $alias, $company, $agent ,$client, $post_by, $signature, $post_date, $status, $batch)
	{
		try
		{
		    $stmt = $this->conn->prepare("INSERT INTO `jobs` (`trxnref`, `customer_name`, `first_name`, `last_name`, `state`, `city`, `phone_no`, `occupation`, `address`, `landmark`, `alias`, `company`, `agent`, `client`, `post_by`, `signature`, `post_date`, `status`, `batch`)
                                                       VALUES(:txn, :cme, :fme, :lme, :ste, :cty, :pno, :ocp, :add, :lmk, :als, :cpy, :agt, :clt, :pby, :sgt, :pdt, :stt, :bch)");
            $stmt->bindParam(':txn',$trxnref);
            $stmt->bindParam(':cme',$customer_name); 
            $stmt->bindParam(':fme',$first_name);
            $stmt->bindParam(':lme',$last_name); 
            $stmt->bindParam(':ste',$state); 
            $stmt->bindParam(':cty',$city);  
            $stmt->bindParam(':pno',$phone_no); 
            $stmt->bindParam(':ocp',$occupation);
            $stmt->bindParam(':add',$address); 
            $stmt->bindParam(':lmk',$landmark); 
            $stmt->bindParam(':als',$alias); 
            $stmt->bindParam(':cpy',$company); 
            $stmt->bindParam(':agt',$agent); 
            $stmt->bindParam(':clt',$client);
            $stmt->bindParam(':pby',$post_by); 
            $stmt->bindParam(':sgt',$signature);
            $stmt->bindParam(':pdt',$post_date); 
            $stmt->bindParam(':stt',$status);
            $stmt->bindParam(':bch',$batch);								  
				
			$stmt->execute();	
			
			return $stmt;	
		}
		catch(PDOException $e)
		{
			echo $e->getMessage();
		}				
	}
	
	
	public function doLogin($uname, $umail, $upass, $vendor)
    {
        try {
            // 🔹 Check CLIENT login first
            $stmt = $this->conn->prepare("
                SELECT * FROM clients 
                WHERE username = :uname OR email = :umail
            ");
            $stmt->execute(array(':uname' => $uname, ':umail' => $umail));
            $userRow = $stmt->fetch(PDO::FETCH_ASSOC);
    
            if ($stmt->rowCount() == 1) {
    
                // ✅ Validate password, status, and token
                if (
                    $upass == $userRow['password'] &&
                    $userRow['status'] == 'Active' &&
                    $userRow['token'] == '8nsir98rhorwgf98wrhf8r09iu035h098h59hf85045ht0n808t6hj8fd7tegg'
                ) {
    
                    // ❗ Vendor must be provided
                    if (empty($vendor)) {
                        return false;
                    }
    
                    // 🔍 Check client–vendor connection
                    $vendorStmt = $this->conn->prepare("
                        SELECT vendor 
                        FROM connect 
                        WHERE client = :client AND vendor = :vendor 
                        LIMIT 1
                    ");
                    $vendorStmt->execute(array(
                        ':client' => $uname,
                        ':vendor' => $vendor
                    ));
                    $vendorRow = $vendorStmt->fetch(PDO::FETCH_ASSOC);
    
                    // ❌ If no vendor match, stop login
                    if (!$vendorRow || empty($vendorRow['vendor'])) {
                        return false;
                    }
    
                    // ✅ All checks passed — set sessions
                    $_SESSION['user_session'] = $userRow['id'];
                    $_SESSION['user_session_token'] = $userRow['token'];
                    $_SESSION['user_session_type'] = 'Client';
                    $_SESSION['user_session_vendor'] = $vendorRow['vendor'];
    
                    return true;
                }
            }
    
            // 🔹 If not a client, try STAFF login
            $stmt = $this->conn->prepare("
                SELECT * FROM staffs 
                WHERE username = :uname OR email = :umail
            ");
            $stmt->execute(array(':uname' => $uname, ':umail' => $umail));
            $userRow = $stmt->fetch(PDO::FETCH_ASSOC);
    
            if ($stmt->rowCount() == 1) {
                if (
                    $upass == $userRow['password'] &&
                    $userRow['status'] == 'Active' &&
                    $userRow['token'] == '8nsir98rhorwgf98wrhf8r09iu035h098h59hf85045ht0n808t6hj8fd7tegg'
                ) {
                    $_SESSION['user_session'] = $userRow['id'];
                    $_SESSION['user_session_token'] = $userRow['token'];
                    $_SESSION['user_session_type'] = 'C.Admin';
                    return true;
                }
            }
    
            // ❌ No matching user found
            return false;
        } catch (PDOException $e) {
            echo $e->getMessage();
        }
    }

	
	public function is_loggedin()
	{
		if(isset($_SESSION['user_session']) && ($_SESSION['user_session_token']))
		{
			return true;
		}
	}
	
	public function redirect($url)
	{
		header("Location: $url");
	}
	
	public function doLogout()
	{
		session_destroy();
		session_unset();
		return true;
	}
}
?>