<?php
if (isset($_GET["type"]) && ($_GET["type"] === 'CSV' || $_GET["type"] === 'PDF')) {
    require_once('../con.php'); // Database credentials
    $connect = mysqli_connect(hostc, db_userc, db_passc, db_namec);
    
    if (!$connect) {
        die("Database connection failed: " . mysqli_connect_error());
    }

    // Retrieve input parameters
    $usario = $_GET['usario'] ?? '';
    $nombre = $_GET['nombre'] ?? '';
    $vendor = $_GET['vendor'] ?? '';

    // Validate required parameters
    if (empty($usario) || empty($nombre) || empty($vendor)) {
        die("Error: Missing required parameters");
    }

    // Fetch data using prepared statement
    $query = "SELECT trxnref, 
                     CONCAT_WS(' ', customer_name, first_name, last_name) AS Name, 
                     state, city, phone_no, occupation, address, 
                     landmark, alias, company, agent, client, batch
              FROM jobs 
              WHERE ((agent = ? AND signature = ? AND status = 'Undone') 
                 OR (l_agent = ? AND signature = ? AND status = 'Undone'))
              ORDER BY j_id DESC";

    $stmt = mysqli_prepare($connect, $query);
    mysqli_stmt_bind_param($stmt, "ssss", $nombre, $vendor, $usario, $vendor);
    mysqli_stmt_execute($stmt);
    $result = mysqli_stmt_get_result($stmt);

    // Handle CSV Export
    if ($_GET["type"] === 'CSV') {
        header('Content-Type: text/csv; charset=utf-8'); 
        header('Content-Disposition: attachment; filename=PendingRequests.csv');
        ob_clean();
        $output = fopen("php://output", "w");
        
        // CSV Headers
        fputcsv($output, [
            'ID', 'Name', 'State', 'City', 'Phone No', 'Occupation', 
            'Address', 'Landmark', 'Alias', 'Company', 'Agent', 'Client', 'Batch'
        ]);

        // Write all data (including empty/N/A values)
        while ($row = mysqli_fetch_assoc($result)) {
            fputcsv($output, $row);
        }

        fclose($output);
        mysqli_close($connect);
        exit();
    }

    // Handle PDF Export (Non-tabular, skip N/A)
    if ($_GET["type"] === 'PDF') {
        require('fpdf/fpdf.php'); // Ensure FPDF is installed
        $pdf = new FPDF('P', 'mm', 'A4');
        $pdf->AddPage();
        $pdf->SetFont('Arial', 'B', 18);
        
        // PDF Header
        $pdf->Cell(0, 10, 'Pending Requests ['.$vendor.']', 0, 1, 'C');
        $pdf->SetFont('Arial', '', 14);
        $pdf->Cell(0, 4, '[Generated on: ' . date('M j, Y h:i:sa').']', 0, 1, 'C');
        $pdf->Ln(3);

        // Field labels (adjust as needed)
        $labels = [
            'trxnref' => 'ID', 'Name' => 'Name', 'state' => 'State', 
            'city' => 'City', 'phone_no' => 'Phone No', 'occupation' => 'Occupation',
            'address' => 'Address', 'landmark' => 'Landmark', 'alias' => 'Alias',
            'company' => 'Company', 'agent' => 'Agent', 'client' => 'Client', 
            'batch' => 'Batch'
        ];

        // Loop through records
        $counter = 1;
        while ($row = mysqli_fetch_assoc($result)) {
            $pdf->SetFont('Arial', 'B', 12);
            $pdf->Cell(0, 5, "Record #$counter", 0, 1);
            $pdf->SetFont('Arial', '', 11);

            // Display non-empty fields
            foreach ($labels as $field => $label) {
                $value = $row[$field] ?? '';
                if (empty($value) || trim($value) === 'N/A') continue; // Skip N/A/empty

                $pdf->Cell(30, 3.5, "$label:", 0, 0);
                $pdf->MultiCell(0, 3.5, $value, 0, 1);
                $pdf->Ln(1);
            }

            // Add separator line
            $pdf->SetDrawColor(200, 200, 200);
            $pdf->Line(3, $pdf->GetY(), 200, $pdf->GetY());
            $pdf->Ln(3);
            $counter++;
        }

        $pdf->Output('D', 'PendingRequests.pdf');
        exit();
    }
}
?>