<center>
    <img width="30" src="avr.png" onload="getLocation()" />
</center>

<div id="retryDiv" style="display:none; text-align:center; margin-top:10px;">
    <button onclick="getLocation()" class="btn btn-warning">
        Refresh & Retry Getting Location
    </button>
</div>

<script>
function getLocation() {
    if (navigator.geolocation) {
        navigator.geolocation.getCurrentPosition(showPosition, showError);
    } else { 
        alert("Geolocation is not supported by this browser.");
    }
}

function showPosition(position) {
    var coordDiv = document.getElementById("coord");
    coordDiv.innerHTML = '<input type="text" class="form-control" name="coord" value="' +
                         position.coords.latitude + ', ' + position.coords.longitude +
                         '" required readonly/>';
    document.getElementById("retryDiv").style.display = "none"; // Hide Retry if successful
}

function showError(error) {
    if (error.code === error.PERMISSION_DENIED) {
        alert('Permission denied. Please allow Location permission in your browser settings and try again.');
    } else if (error.code === error.POSITION_UNAVAILABLE) {
        alert('Location information is unavailable. Please try again.');
    } else if (error.code === error.TIMEOUT) {
        alert('The request to get your location timed out. Please try again.');
    } else {
        alert('An unknown error occurred. Please try again.');
    }
    document.getElementById("retryDiv").style.display = "block"; // Show Retry button
}
</script>

<?php
if (isset($_REQUEST['id'])) {
    $id = intval($_REQUEST['id']);
}
?>

<form class="form-signin" method="post" id="login-form" enctype="multipart/form-data">
    <div class="form-group">
        <input type="text" class="form-control" name="llave" value="<?php echo $id; ?>" required readonly/>
    </div>
    <div class="form-group" id="coord">
        <!-- Coordinate input will be dynamically injected here -->
    </div>
    <div class="form-group">
        <button type="submit" onclick="return confirm('Are you sure you want to save for later?');" name="btn-save" class="btn btn-default">
            <i class="glyphicon glyphicon-save"></i>&nbsp;Save
        </button>
    </div>  
</form>