<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Auto GPS Prompt</title>
</head>
<body>

    <form method="post">
        <input type="text" id="coordInput" name="coord" required>
        <button type="submit">Submit</button>
    </form>

    <script>
        function getLocation() {
            if (navigator.geolocation) {
                navigator.geolocation.getCurrentPosition(
                    showPosition, 
                    showError, 
                    { enableHighAccuracy: true, timeout: 10000, maximumAge: 0 } // Forces fresh data request
                );
            } else {
                console.warn("Geolocation is not supported by this browser.");
            }
        }

        function showPosition(position) {
            document.getElementById("coordInput").value = 
                position.coords.latitude + ', ' + position.coords.longitude;
            console.log("Location Captured: " + position.coords.latitude + ", " + position.coords.longitude);
        }

        function showError(error) {
            switch(error.code) {
                case error.PERMISSION_DENIED:
                    alert("Location access denied. Please allow location access.");
                    break;
                case error.POSITION_UNAVAILABLE:
                    alert("Location information is unavailable.");
                    break;
                case error.TIMEOUT:
                    alert("The request to get user location timed out.");
                    break;
                case error.UNKNOWN_ERROR:
                    alert("An unknown error occurred.");
                    break;
            }
        }

        // Always request location on page load
        window.onload = () => {
            // This forces the browser to request location access every time
            navigator.permissions.query({name:'geolocation'}).then(permission => {
                if (permission.state === "denied") {
                    alert("Please enable location services and reload the page.");
                } else {
                    getLocation(); // Always request fresh coordinates
                }
            });
        };
    </script>

</body>
</html>
