<?php
require('fpdf/fpdf.php'); // Adjust path to FPDF library
require_once('../con.php'); // Database configuration

// Retrieve parameters
$id = isset($_GET['clave']) ? intval($_GET['clave']) : 0;
$signature = isset($_GET['signatura']) ? $_GET['signatura'] : '';

// Database connection
$DBhost = hostc;
$DBuser = db_userc;
$DBpass = db_passc;
$DBname = db_namec;

try {
    $DBcon = new PDO("mysql:host=$DBhost;dbname=$DBname", $DBuser, $DBpass);
    $DBcon->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch(PDOException $ex) {
    die("Connection failed: " . $ex->getMessage());
}

// Fetch job data
$stmt = $DBcon->prepare("SELECT * FROM d_jobs WHERE d_id = :id");
$stmt->execute([':id' => $id]);
$row = $stmt->fetch(PDO::FETCH_ASSOC);
$trxnref = !empty($row['trxnref']) && $row['trxnref'] != 'N/A' 
    ? $row['trxnref'] 
    : 'Not Available';

if (!$row) {
    die('Record not found.');
}

// Fetch vendor information
$stmtVendor = $DBcon->prepare("SELECT * FROM vendor WHERE username = :signature");
$stmtVendor->execute([':signature' => $signature]);
$vendorData = $stmtVendor->fetch(PDO::FETCH_ASSOC);
if ($vendorData){
    // Extract vendor details
    $nombre = $vendorData['name'];
    $email = $vendorData['email'];
    $sitio = $vendorData['website'];
    $tel = $vendorData['tel'];
    $address = $vendorData['address'];
    $logo = $vendorData['logo'];
}

// Initialize PDF
$pdf = new FPDF('P','mm',array(210,297));
$pdf->AddPage();
$pdf->Image('images/'.$logo,90,3,0,30);
$pdf-> Cell(189  ,1,'',0,1);//end of line
$pdf->SetFont('Arial','B',12);
$pdf->Cell(185, 50, $nombre, 0, 0, 'C');
$pdf-> Cell(189  ,0,'',0,1);//end of line
$pdf->SetFont('Arial','I',10);
$pdf->Cell(185, 60, $address, 0, 0, 'C');
$pdf->Cell(-185, 68, $email.' | '.$tel , 0, 0, 'C');
$pdf-> Cell(189  ,0,'',0,1);//end of line

$pdf-> Cell(189  ,35,'',0,1);//end of line
$pdf->SetFont('Arial', 'B', 16);
$pdf->Cell(0, 10, 'Verification Report', 0, 1, 'C');
$pdf->Ln(8);
$pdf->SetFont('Arial', '', 12);
// Function to add fields
function addField($pdf, $label, $value) {
    $pdf->SetFont('Arial', 'B', 12);
    $pdf->Cell(60, 2.5, $label . ':', 0, 0);
    $pdf->SetFont('Arial', '', 12);
    $pdf->MultiCell(0, 3.5, $value);
    $pdf->Ln(4);
}

// Process each field
$fields = [
    'trxnref' => 'Ref No.',
    'batch' => 'Batch No.',
    'coord' => 'GPS Coordinates',
    'company_name' => 'Company',
    'customer_title' => 'Title',
    'customer_name' => 'Name',
    'first_name' => 'First Name',
    'last_name' => 'Last Name',
    'alias' => ($row['client'] == 'FirstBank') ? 'Relocation Plans' : 'Alias',
    'phone_no' => 'Phone No.',
    'occupation' => 'Occupation',
    'customer_address' => 'Address',
    'address_status' => ($row['client'] == 'FirstBank') ? 'Address Exists' : 'Address Status',
    'customer_resides' => 'Customer Resides',
    'nearest_bstp' => 'Nearest B-Stop',
    'landmark' => 'Landmark',
    'city' => 'City',
    'state' => 'State',
    'ver_stat_desc' => 'Ver Stat Desc',
    'building_condition' => 'Bld. Condition',
    'building_finishing' => 'Bld. Finishing',
    'building_completion' => 'Bld. Completion',
    'building_type2' => 'Bld. Type',
    'colour_of_building' => 'Colour of Building',
    'customer_rel_with_address' => 'Customer Rel. With Address',
    'owner_relationship' => 'Owner Rel.',
    'area_profile' => 'Area Profile',
    'interviewed' => 'Interviewed',
    'interviewee' => ($row['client'] == 'FirstBank') ? 'Interviewed Customer' : 'Interviewee',
    'interviewee_surname' => 'Int. Surname',
    'interviewee_other_names' => 'Int. Other Names',
    'interviewee_relationship' => 'Int. Rel',
    'interviewee_address' => 'Int. Address',
    'interviewee_telephone' => 'Int. Tel.',
    'visitation_date' => 'Visitation Date',
    'visitation_time' => 'Visitation Time',
    'staff_met' => 'Staff Met',
    'staff_met_comment' => 'Staff Met Comment',
    'address_visited' => 'Address Visited',
    'building_type' => 'Bld. Description',
    'sure_of_address' => 'Sure of Address',
    'reason' => 'Reason',
    'comments' => 'Comment',
    'agent' => 'Agent',
    'l_agent' => 'Supervisor',
    'client' => 'Client',
    'post_by' => 'Posted By'
];

foreach ($fields as $key => $label) {
    if (!empty($row[$key]) && $row[$key] != 'N/A') {
        addField($pdf, $label, $row[$key]);
    }
}
$pdf->SetFont('Arial','i',9);
$pdf->Cell(195 ,5,'Generated: '. date("M j, Y h:i:sa"),0,1,'C');

// Handle Images
$yPosition = $pdf->GetY(); // Get current Y position after text
$maxPageHeight = 250; 
$availableHeight = $maxPageHeight - $yPosition;

// Both images container
if (!empty($row['st_photo']) || !empty($row['bd_photo'])) {
    if($availableHeight < 100) { 
        $pdf->AddPage();
        $yPosition = 20;
        $availableHeight = $maxPageHeight - $yPosition;
    }

    $images = [];
    if (!empty($row['st_photo']) && $row['st_photo'] != 'N/A') {
        $imagePath = $_SERVER['DOCUMENT_ROOT'] . parse_url($row['st_photo'], PHP_URL_PATH);
        if (file_exists($imagePath)) {
            $images[] = ['path' => $imagePath, 'label' => 'Photo1'];
        }
    }
    if (!empty($row['bd_photo']) && $row['bd_photo'] != 'N/A') {
        $imagePath = $_SERVER['DOCUMENT_ROOT'] . parse_url($row['bd_photo'], PHP_URL_PATH);
        if (file_exists($imagePath)) {
            $images[] = ['path' => $imagePath, 'label' => 'Photo2'];
        }
    }

    if(count($images) > 0) {
        $maxWidth = 85; 
        $totalHeight = 0;
        $scaledImages = [];

        foreach($images as $img) {
            list($width, $height) = getimagesize($img['path']);
            $scale = min($maxWidth / $width, ($availableHeight - 20) / $height);
            $scaledWidth = $width * $scale;
            $scaledHeight = $height * $scale;
            
            $scaledImages[] = [
                'path' => $img['path'],
                'label' => $img['label'],
                'w' => $scaledWidth,
                'h' => $scaledHeight
            ];
            $totalHeight += $scaledHeight + 15;
        }

        if($totalHeight <= $availableHeight) {
            // Vertical layout
            foreach($scaledImages as $img) {
                $pdf->SetFont('Arial','B',10);
                $pdf->Cell(0, 6, $img['label'], 0, 1);
                $pdf->Image($img['path'], 10, $pdf->GetY(), $img['w'], $img['h']);
                $pdf->SetY($pdf->GetY() + $img['h'] + 5);

                if (!empty($row['coord']) && $row['coord'] != 'N/A') {
                    $pdf->SetFont('Arial','I',9);
                    $pdf->Cell(0, 6, "GPS: " . $row['coord'], 0, 1, 'L');
                    $pdf->Ln(3);
                }
            }
        } else {
            // Horizontal layout
            $maxWidth = (190 - 20) / count($images); 
            $x = 10;
            $y = $pdf->GetY();
            $maxScaledHeight = 0;

            foreach($images as $index => $img) {
                list($width, $height) = getimagesize($img['path']);
                $scale = min($maxWidth / $width, ($availableHeight - 20) / $height);
                $scaledWidth = $width * $scale;
                $scaledHeight = $height * $scale;

                $pdf->SetFont('Arial','B',10);
                $pdf->SetXY($x, $y);
                $pdf->Cell($maxWidth, 6, $img['label'], 0, 2, 'C');
                
                $pdf->Image($img['path'], $x, $pdf->GetY(), $scaledWidth, $scaledHeight);
                
                if (!empty($row['coord']) && $row['coord'] != 'N/A') {
                    $pdf->SetY($pdf->GetY() + $scaledHeight + 2);
                    $pdf->SetX($x);
                    $pdf->SetFont('Arial','I',9);
                    $pdf->MultiCell($maxWidth, 5, "GPS: " . $row['coord'], 0, 'C');
                }

                $x += $maxWidth + 10; 
                if ($scaledHeight > $maxScaledHeight) {
                    $maxScaledHeight = $scaledHeight;
                }
            }
            $pdf->SetY($y + $maxScaledHeight + 15);
        }
    }
}

// Output PDF
$pdf->Output('I', 'Report_'.$trxnref.'_'.$signature.'.pdf');
?>
