<?php
require 'cabeza.php';
require_once 'tdbconfig.php';

if (isset($_POST['upload_csv'])) {

    if (isset($_FILES['csv_file']['tmp_name']) && is_uploaded_file($_FILES['csv_file']['tmp_name'])) {
        $file = fopen($_FILES['csv_file']['tmp_name'], 'r');

        // Skip header
        $headers = fgetcsv($file, 1000, ",");
        $headers = array_map('trim', $headers);
        
        while (($data = fgetcsv($file, 1000, ",")) !== FALSE) {
            $csv = array_combine($headers, $data);

            $trxnref = $csv['TRXNREF'];
            $f_name = $csv['FIRSTNAME'] ?? 'N/A';
            $l_name = $csv['LASTNAME'] ?? 'N/A';
            $state = $csv['STATE'] ?? 'N/A';
            $city = $csv['CITY'] ?? 'N/A';
            $customer_address = $csv['ADDRESS'] ?? 'N/A';
            $address_status = $csv['STATUS'] ?? 'N/A';
            $address_visited = $csv['ADDRESS EXISTS'] ?? 'N/A';
            $visitation_raw = $csv['VISITATION DATE'] ?? null;
            $visitation_date = $visitation_raw ? date('Y-m-d', strtotime($visitation_raw)): 'N/A';
            $visitation_time = $csv['VISITATION TIME'] ?? '';
            $cus_resides = $csv['CUSTOMER RESIDES'] ?? 'N/A';
            $ver_stat_desc = $csv['VERIFICATION MESSAGE'] ?? date('H:i:s');
            $build_cond = $csv['BUILDING CONDITION'] ?? 'N/A';
            $build_finish = $csv['BUILDING FINISHING'] ?? 'N/A';
            $colour_of_building = $csv['BUILDING COLOUR'] ?? 'N/A';
            $building_type = $csv['BUILDING TYPE'] ?? 'N/A';
            $cus_rel_wit_add = $csv['CUSTOMER RELATIONSHIP WITH THE ADDRESS'] ?? 'N/A';
            $int_name = $csv['NAME OF INDIVIDUAL INTERVIEWED'] ?? 'N/A';
            $int_rel = $csv['RELATIONSHIP WITH ADDRESS'] ?? 'N/A';
            $landmark = $csv['LANDMARK'] ?? 'N/A';
            $agent = $csv['AGENT'] ?? 'N/A';
            $l_agent = $csv['SUPERVISOR'] ?? 'N/A';
            $st_photo = $csv['PHOTO1'] ?? 'N/A';
            $bd_photo = $csv['PHOTO2'] ?? 'N/A';
            $coord = $csv['Coordinates'] ?? 'N/A';
            $tat = $csv['TAT'] ?? 'N/A';
            $batch = $csv['BATCH'] ?? 'N/A';

            // Derive this if needed
            $joined = "Address is a {$colour_of_building} coloured {$building_type}";
            $status = "Approved";

            // Assign defaults
            $customer_name = 'N/A';
            $post_by = 'Royusuf';
            $current_time = date('H:i:s');
            
            $post_date = date('Y-m-d', strtotime($visitation_date)) . ' ' . $current_time;
            $in_date = $post_date;
            $sure_of_address = 'N/A';
            $reason = 'N/A';
            $staff_met = 'N/A';
            $staff_met_comment = 'N/A';
            $comments = 'N/A';

            $stmt = $DB_con->prepare('INSERT INTO `d_jobs` 
                (`trxnref`,`customer_phone`,`customer_title`,`customer_name`,`first_name`,`last_name`,`customer_address`,`address_status`,
                 `customer_resides`,`nearest_bstp`,`landmark`,`alias`,`company_name`,`city`, `state`,`ver_stat_desc`,`building_condition`,
                 `building_finishing`,`building_completion`,`building_type2`,`customer_rel_with_address`,`occupation`,`owner_relationship`,
                 `area_profile`,`interviewed`,`interviewee`,`interviewee_surname`,`interviewee_other_names`,`interviewee_relationship`,
                 `interviewee_address`,`interviewee_telephone`,`visitation_date`,`visitation_time`,`staff_met`,`staff_met_comment`,
                 `address_visited`,`building_type`,`colour_of_building`,`sure_of_address`,`reason`,`st_photo`,`bd_photo`,`coord`,
                 `comments`,`agent`,`l_agent`,`client`,`post_date`,`post_by`,`status`,`signature`,`tat`,`batch`)
                 VALUES(:txn, "N/A", "N/A", :cun, :fnm, :lnm, :cad, :ads, :crl, "N/A", :lmk, "N/A", "N/A", :cty, :ste, :vsd, :bcd, :bfs, "N/A", :bt2, :cwa, "N/A", "N/A", "N/A", :int, "N/A", "N/A", "N/A", :irl, "", "N/A", :vdt, :vtm, :smt, :smc, :adv, :bdt, :cbd, :soa, :rsn, :str, :bld, :cod, :cmt, :agt, :lag, "Wema", :pdt, :pby, :stt, "Royusuf", :tat, :bch)
            ');

            // Bind values
            $stmt->bindParam(':txn', $trxnref);
            $stmt->bindParam(':cun', $customer_name);
            $stmt->bindParam(':fnm', $f_name);
            $stmt->bindParam(':lnm', $l_name);
            $stmt->bindParam(':cad', $customer_address);
            $stmt->bindParam(':ads', $address_status);
            $stmt->bindParam(':crl', $cus_resides);
            $stmt->bindParam(':lmk', $landmark);
            $stmt->bindParam(':cty', $city);
            $stmt->bindParam(':ste', $state);
            $stmt->bindParam(':vsd', $ver_stat_desc);
            $stmt->bindParam(':bcd', $build_cond);
            $stmt->bindParam(':bfs', $build_finish);
            $stmt->bindParam(':bt2', $building_type);
            $stmt->bindParam(':cwa', $cus_rel_wit_add);
            $stmt->bindParam(':int', $int_name);
            $stmt->bindParam(':irl', $int_rel);
            $stmt->bindParam(':vdt', $visitation_date);
            $stmt->bindParam(':vtm', $visitation_time);
            $stmt->bindParam(':smt', $staff_met);
            $stmt->bindParam(':smc', $staff_met_comment);
            $stmt->bindParam(':adv', $address_visited);
            $stmt->bindParam(':bdt', $joined);
            $stmt->bindParam(':cbd', $colour_of_building);
            $stmt->bindParam(':soa', $sure_of_address);
            $stmt->bindParam(':rsn', $reason);
            $stmt->bindParam(':str', $st_photo);
            $stmt->bindParam(':bld', $bd_photo);
            $stmt->bindParam(':cod', $coord);
            $stmt->bindParam(':cmt', $comments);
            $stmt->bindParam(':agt', $agent);
            $stmt->bindParam(':lag', $l_agent);
            $stmt->bindParam(':pdt', $post_date);
            $stmt->bindParam(':pby', $post_by);
            $stmt->bindParam(':stt', $status);
            $stmt->bindParam(':tat', $tat);
            $stmt->bindParam(':bch', $batch);

            $stmt->execute();
        }

        fclose($file);
        echo "<script>alert('CSV Import Successful!'); window.location.href='';</script>";
    } else {
        echo "<script>alert('Please upload a valid CSV file');</script>";
    }
}
?>
<form method="POST" enctype="multipart/form-data">
  <input type="file" name="csv_file" accept=".csv,.tsv" required>
  <button type="submit" name="upload_csv">Upload CSV</button>
</form>
