<?php
// Define the upload directory
$uploadDir = "uploads/";

// Ensure the uploads directory exists
if (!is_dir($uploadDir)) {
    mkdir($uploadDir, 0777, true);
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Check if a file was uploaded
    if (isset($_FILES['image']) && $_FILES['image']['error'] === UPLOAD_ERR_OK) {
        $fileTmpPath = $_FILES['image']['tmp_name'];
        $fileName = basename($_FILES['image']['name']);
        $fileSize = $_FILES['image']['size'];
        $fileType = mime_content_type($fileTmpPath);

        // Define allowed file types and max size
        $allowedTypes = ['image/jpeg', 'image/png', 'image/gif'];
        $maxFileSize = 2 * 1024 * 1024; // 2MB

        if (in_array($fileType, $allowedTypes)) {
            if ($fileSize <= $maxFileSize) {
                $destination = $uploadDir . $fileName;

                // Move the uploaded file to the desired location
                if (move_uploaded_file($fileTmpPath, $destination)) {
                    echo "File uploaded successfully: <a href='$destination'>$fileName</a>";
                } else {
                    echo "Error moving the file.";
                }
            } else {
                echo "File size exceeds the maximum allowed size of 2MB.";
            }
        } else {
            echo "Invalid file type. Only JPG, PNG, and GIF files are allowed.";
        }
    } else {
        echo "No file uploaded or an error occurred.";
    }
}
?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head><meta http-equiv="Content-Type" content="text/html; charset=utf-8">

<meta name="viewport" content="width=device-width, initial-scale=1" />
<meta http-equiv="refresh" content="<?php echo $seg ?>;URL='<?php echo $pagina ?>'">
<link href="bootstrap/css/bootstrap.min.css" rel="stylesheet" media="screen">
<link href="bootstrap/css/bootstrap-theme.min.css" rel="stylesheet" media="screen">
<link href="datatables/css/dataTables.bootstrap.min.css" rel="stylesheet" media="screen">
<!-- [favicon] begin -->
<link rel="shortcut icon" type="image/x-icon" href="http://slsdteam.com.ng/favicon.ico" />
<link rel="icon" type="image/x-icon" href="http://slsdteam.com.ng/favicon.ico" />
<!-- [favicon] end -->
<script type="text/javascript" src="jquery-1.11.3-jquery.min.js"></script>
<link rel="stylesheet" href="style.css" type="text/css"  />
<title>Upload Images (<?php print $usario; ?>) | AVR</title>
</head>

<body>

    <?php 
        $page = 'requests';
        $page1 = 'undone-jobs'; 
        include ('include/nav.php') 
    ?>

    <div class="clearfix"></div>
    	
    
<div class="container-fluid" style="margin-top:80px;">
	
    <div class="container">
    
    	<label class="h5">Upload Images | <?php print $usario; ?></label>
        <hr />
        <div class="panel panel-primary" id="adminn">
            <div class="panel-heading">
                <h1 class="panel-title"><strong><center>Upload Images</center></strong></h1>
            </div>
            <div class="panel-body">
                <form action="" method="post" enctype="multipart/form-data">
                    <label for="image">Select an image:</label>
                    <input type="file" name="image" id="image" accept="image/*" required>
                    <button type="submit">Upload</button>
                </form> 
            </div>
        </div>
    </div>
    
</div>
<?php include 'include/footer.php'; ?>
<script src="assets/jquery-1.12.4.min.js"></script>
<script src="assets/js/bootstrap.min.js"></script>
<script src="datatables/js/jquery.dataTables.min.js"></script>
<script src="datatables/js/dataTables.bootstrap.min.js"></script>
 
<script>


$('#mydata').dataTable();

$(document).ready(function(){

	$(document).on('click', '#see-undone', function(e){
		
		e.preventDefault();
		
		var uid = $(this).data('id');   // it will get id of clicked row
		
		$('#dynamic-content').html(''); // leave it blank before ajax call
		$('#modal-loader').show();      // load ajax loader
		
		$.ajax({
			url: 'getUndone.php',
			type: 'POST',
			data: 'id='+uid,
			dataType: 'html'
		})
		.done(function(data){
			console.log(data);	
			$('#dynamic-content').html('');    
			$('#dynamic-content').html(data); // load response 
			$('#modal-loader').hide();		  // hide ajax loader	
		})
		.fail(function(){
			$('#dynamic-content').html('<i class="glyphicon glyphicon-info-sign"></i> Something went wrong, Please try again...');
			$('#modal-loader').hide();
		});
		
	});
	
});
$(document).ready(function(){

	$(document).on('click', '#report-undone', function(e){
		
		e.preventDefault();
		
		var uid = $(this).data('id');   // it will get id of clicked row
		
		$('#dynamic-content').html(''); // leave it blank before ajax call
		$('#modal-loader').show();      // load ajax loader
		
		$.ajax({
			url: 'getReportJob.php',
			type: 'POST',
			data: 'id='+uid,
			dataType: 'html'
		})
		.done(function(data){
			console.log(data);	
			$('#dynamic-content').html('');    
			$('#dynamic-content').html(data); // load response 
			$('#modal-loader').hide();		  // hide ajax loader	
		})
		.fail(function(){
			$('#dynamic-content').html('<i class="glyphicon glyphicon-info-sign"></i> Something went wrong, Please try again...');
			$('#modal-loader').hide();
		});
		
	});
	
});
$(document).ready(function(){

	$(document).on('click', '#reject-undone', function(e){
		
		e.preventDefault();
		
		var uid = $(this).data('id');   // it will get id of clicked row
		
		$('#dynamic-content').html(''); // leave it blank before ajax call
		$('#modal-loader').show();      // load ajax loader
		
		$.ajax({
			url: 'getRejectJob.php',
			type: 'POST',
			data: 'id='+uid,
			dataType: 'html'
		})
		.done(function(data){
			console.log(data);	
			$('#dynamic-content').html('');    
			$('#dynamic-content').html(data); // load response 
			$('#modal-loader').hide();		  // hide ajax loader	
		})
		.fail(function(){
			$('#dynamic-content').html('<i class="glyphicon glyphicon-info-sign"></i> Something went wrong, Please try again...');
			$('#modal-loader').hide();
		});
		
	});
	
});
</script>

</body>
</html>