<?php
// Database credentials
$host = 'localhost';
$db_name = 'rhedlkwp_cav';
$username = 'rhedlkwp_Rhedrick';
$password = 'Avr2025!Cav2026!';

// Create PDO connection
try {
    $pdo = new PDO("mysql:host=$host;dbname=$db_name", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Database connection failed: " . $e->getMessage());
}

// Handle coordinate updates
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['coords'])) {
    foreach ($_POST['coords'] as $trxnref => $coord) {
        if (!empty($coord)) {
            $stmt = $pdo->prepare("UPDATE d_jobs SET coord = :coord WHERE trxnref = :trxnref");
            try {
                $stmt->execute(['coord' => $coord, 'trxnref' => $trxnref]);
            } catch (PDOException $e) {
                // Skip duplicates or failed updates
                continue;
            }
        }
    }
    echo "<div class='alert alert-success text-center'>✅ Coordinates updated successfully.</div>";
}

// Fetch records
// --- GET FILTERS ---
$signature        = $_GET['signature'] ?? '';
$status           = $_GET['status'] ?? '';
$address_status   = $_GET['address_status'] ?? '';
$customer_resides = $_GET['customer_resides'] ?? '';
$coord            = $_GET['coord'] ?? '';
$limit            = $_GET['limit'] ?? 1000;

// ❗ Don't load table if no filter is selected
$noFilterSelected = (
    $signature === '' &&
    $status === '' &&
    $address_status === '' &&
    $customer_resides === '' &&
    $coord === '' &&
    !isset($_GET['limit']) // means the page just opened, no GET values
);

if ($noFilterSelected) {
    $records = []; // Table will remain empty
} else {
    // --- BUILD QUERY ---
    $query = "SELECT trxnref, first_name, last_name, customer_address, state, city, address_status, customer_resides, coord 
              FROM d_jobs 
              WHERE client='Wema'";
    // Apply filters only if selected
    if ($signature !== '')        $query .= " AND signature = " . $pdo->quote($signature);
    if ($status !== '')           $query .= " AND status = " . $pdo->quote($status);
    if ($address_status !== '')   $query .= " AND address_status = " . $pdo->quote($address_status);
    if ($customer_resides !== '') $query .= " AND customer_resides = " . $pdo->quote($customer_resides);
    
    if ($coord === 'NULL')        $query .= " AND coord IS NULL";
    if ($coord === 'NOT NULL')    $query .= " AND coord IS NOT NULL";
    
    $query .= " LIMIT " . intval($limit);
    $stmt = $pdo->query($query);
    $records = $stmt->fetchAll(PDO::FETCH_ASSOC);
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Wema Coordinate Updater</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap5.min.css" rel="stylesheet">
  <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
  <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
  <script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap5.min.js"></script>
  <style>
    body { background:#f8f9fa; font-family: "Segoe UI", sans-serif; }
    .map-preview { width: 150px; height: 120px; border-radius: 8px; border: 1px solid #ddd; margin-top: 4px; }
    table td { vertical-align: middle !important; }
    #progressContainer { display:none; margin-top:20px; }
    
  </style>
</head>
<body class="p-4">
<div class="container bg-white p-4 rounded shadow-sm">
  <h3 class="mb-3 text-center text-primary">📍 Wema - Missing Coordinates</h3>
    <form method="GET" class="mb-3 p-3 border rounded bg-light">

      <div class="row g-2">
    
        <div class="col-md-2">
          <label class="form-label">Signature</label>
          <select name="signature" class="form-select form-select-sm">
            <option value="">Any</option>
            <option>Rhedrick</option>
          </select>
        </div>
    
        <div class="col-md-2">
          <label class="form-label">Status</label>
          <select name="status" class="form-select form-select-sm">
            <option value="">Any</option>
            <option>Rejected</option>
            <option>Approved</option>
            <option>Pending</option>
          </select>
        </div>
    
        <div class="col-md-2">
          <label class="form-label">Address Status</label>
          <select name="address_status" class="form-select form-select-sm">
            <option value="">Any</option>
            <option>Yes</option>
            <option>No</option>
          </select>
        </div>
    
        <div class="col-md-2">
          <label class="form-label">Customer Resides</label>
          <select name="customer_resides" class="form-select form-select-sm">
            <option value="">Any</option>
            <option>Yes</option>
            <option>No</option>
          </select>
        </div>
    
        <div class="col-md-2">
          <label class="form-label">Coordinate</label>
          <select name="coord" class="form-select form-select-sm">
            <option value="">Any</option>
            <option value="NULL">IS NULL</option>
            <option value="NOT NULL">IS NOT NULL</option>
          </select>
        </div>
    
        <div class="col-md-2">
          <label class="form-label">Limit</label>
          <select name="limit" class="form-select form-select-sm">
            <option value="100">100</option>
            <option value="500">500</option>
            <option value="1000">1000</option>
            <option value="2000">2000</option>
            <option value="5000">5000</option>
            <option value="10000">10000</option>
          </select>
        </div>
    
      </div>
    
      <button class="btn btn-primary btn-sm mt-3">Apply Filters</button>
  </form>
  <form method="POST">
    <div class="mb-2 d-flex justify-content-between">
      <button type="button" id="fetchSelected" class="btn btn-outline-primary btn-sm">📡 Get GPS for Selected</button>
      <button type="submit" class="btn btn-success btn-sm">💾 Update All Selected</button>
    </div>

    <div id="progressContainer" class="progress">
      <div id="progressBar" class="progress-bar progress-bar-striped progress-bar-animated" style="width:0%">0%</div>
    </div>

    <table id="coordTable" class="table table-striped table-bordered table-hover">
      <thead class="table-primary text-center">
        <tr>
          <th><input type="checkbox" id="checkAll"></th>
          <th>TrxnRef</th>
          <th>Customer</th>
          <th>Address</th>
          <th>City</th>
          <th>State</th>
          <th>GPS Coordinates</th>
          <th>Action</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($records as $row): ?>
        <tr>
          <td class="text-center"><input type="checkbox" class="row-check"></td>
          <td><?= htmlspecialchars($row['trxnref']) ?></td>
          <td><?= htmlspecialchars($row['first_name'] . ' ' . $row['last_name']) ?></td>
          <td><?= htmlspecialchars($row['customer_address']) ?></td>
          <td><?= htmlspecialchars($row['city']) ?></td>
          <td><?= htmlspecialchars($row['state']) ?></td>
          <td>
            <input type="text" class="form-control form-control-sm mb-1" 
                   name="coords[<?= $row['trxnref'] ?>]" 
                   id="coord_<?= $row['trxnref'] ?>" 
                   placeholder="Latitude, Longitude">
            <div id="map_<?= $row['trxnref'] ?>"></div>
          </td>
          <td class="text-center">
            <button type="button" 
                    class="btn btn-outline-primary btn-sm fetch-btn" 
                    data-trxnref="<?= $row['trxnref'] ?>"
                    data-address="<?= htmlspecialchars($row['customer_address']) ?>"
                    data-city="<?= htmlspecialchars($row['city']) ?>"
                    data-state="<?= htmlspecialchars($row['state']) ?>">
              Get GPS
            </button>
          </td>
        </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </form>
</div>
<!-- ✅ Add this modal block just before closing </body> -->
<div class="modal fade" id="mapModal" tabindex="-1" aria-labelledby="mapModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="mapModalLabel">Adjust Location on Map</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <div id="liveMap" style="width:100%; height:500px; border-radius:8px;"></div>
      </div>
      <div class="modal-footer">
        <button type="button" id="applyLocation" class="btn btn-primary">Apply Location</button>
      </div>
    </div>
  </div>
</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

<script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyACN8Gf4LwFFXv7HV8fpVAW0osUx3J9Lz8&libraries=places"></script>

<script>
// ✅ Address Cleaner — Context-aware
function cleanAddress(rawAddress) {
  if (!rawAddress) return '';

  let address = rawAddress.toLowerCase().trim();

  // --- 1️⃣ Normalize punctuation and spaces ---
  address = address.replace(/[-/]/g, ' ');
  address = address.replace(/\s{2,}/g, ' ').trim();

  // --- 2️⃣ Remove postal/box references ---
  address = address.replace(/\b(p\.?o\.?\s?box|postal\s*address|pmb)\s*\d*\b/gi, '');

  // --- 3️⃣ Remove building/unit identifiers ---
  address = address.replace(/\b(flat|suite|unit|apt|apartment|room|block|wing|floor|flr|complex|tower)\b.*?(,|$)/gi, '');

  // --- 4️⃣ Remove building numbers, keep context (except known estates) ---
  address = address.replace(/\b(?:no\.?|plot|house|building|#)\s*\d+[a-z]*/gi, '');
  address = address.replace(/\b\d+[a-z]?\b(?!\s*estate)/gi, '');

  // --- 5️⃣ Remove directional / vague terms ---
  address = address.replace(/\b(opposite|opp\.?|beside|behind|before|after|near|by|next\s*to|off|close\s*to|along|around|in\s*front\s*of|adjacent\s*to|besides)\b.*?(,|$)/gi, '');

  // --- 6️⃣ Remove misleading or traffic-related points ---
  address = address.replace(/\b(filling\s*station|bus\s*stop|junction|roundabout|gate|terminal|garage|expressway|highway)\b.*?(,|$)/gi, '');

  // --- 7️⃣ Keep structured anchors (not streets but recognizable) ---
  address = address.replace(/\b(market|estate|school|hotel|mall|plaza|church|mosque|camp|quarters|layout|village|court|hospital|clinic|park)\b(?!\s*(road|street|close|crescent|lane|drive))/gi, '$1');

  // --- 8️⃣ Expand local abbreviations ---
  const replacements = {
    '\\bstr?t\\b': 'street',
    '\\brd\\b': 'road',
    '\\bave\\b': 'avenue',
    '\\bcr?es\\b': 'crescent',
    '\\bcl\\b': 'close',
    '\\bln\\b': 'lane',
    '\\bdrv?\\b': 'drive',
    '\\bboulevard\\b': 'boulevard',
    '\\bway\\b': 'way',
    '\\bph\\b': 'port harcourt',
    '\\bfct\\b': 'abuja',
    '\\blag\\b': 'lagos'
  };
  for (let key in replacements) {
    address = address.replace(new RegExp(key, 'gi'), replacements[key]);
  }

  // --- 9️⃣ Clean redundant commas ---
  address = address.replace(/,+/g, ',').replace(/\s*,\s*/g, ', ').replace(/^,|,$/g, '').trim();

  // --- 🔟 Remove redundant national context ---
  address = address.replace(/\b(nigeria|state|city|town|community|barracks)\b/gi, '');

  // --- 11️⃣ Extract street-level candidate ---
  const streetRegex = /\b[\w\s]+(?:street|road|avenue|crescent|close|lane|drive|boulevard|way)\b[\w\s,]*/gi;
  const matches = address.match(streetRegex);

  let bestSegment = '';
  if (matches && matches.length) {
    // prefer the shortest meaningful street
    matches.sort((a, b) => a.length - b.length);
    bestSegment = matches.find(seg => seg.length < 60) || matches[0];
  } else {
    // Fallback to smaller recognizable landmarks
    const landmarkRegex = /\b([\w\s]+(?:market|estate|mall|plaza|school|church|mosque|hospital|court|layout|quarters|village|hotel|park))\b/gi;
    const landmarkMatch = address.match(landmarkRegex);
    bestSegment = landmarkMatch && landmarkMatch.length ? landmarkMatch[0] : address.split(',')[0];
  }

  // --- 12️⃣ Format casing ---
  bestSegment = bestSegment
    .split(',')
    .map(p => p.trim().replace(/\b\w/g, l => l.toUpperCase()))
    .join(', ');

  // --- 13️⃣ Append Nigeria if not already ---
  if (!/nigeria/i.test(bestSegment)) bestSegment += ', Nigeria';

  return bestSegment.trim();
}

// ✅ Initialize DataTable
$(document).ready(function() {
  const table = $('#coordTable').DataTable({
    pageLength: 100,
    lengthMenu: [[100, 250, 500, 750, 1000], [100, 250, 500, 750, 1000]],
    order: [[1, 'asc']]
  });

  // ✅ Check/Uncheck logic
  $('#checkAll').on('click', function() {
    const checked = this.checked;
    $('#coordTable tbody input.row-check').prop('checked', checked);
  });

  $('#coordTable tbody').on('change', 'input.row-check', function() {
    const total = $('#coordTable tbody input.row-check').length;
    const checked = $('#coordTable tbody input.row-check:checked').length;
    $('#checkAll').prop('checked', total === checked);
  });

  // ✅ Individual Fetch
  $('.fetch-btn').click(async function() {
    await fetchCoordinates($(this));
  });

  // ✅ Multiple Fetch with Progress
  $('#fetchSelected').click(async function() {
    const selectedRows = $('#coordTable tbody tr').has('input.row-check:checked');
    if (selectedRows.length === 0) {
      alert('Please select at least one record.');
      return;
    }

    $('#progressContainer').show();
    let count = 0;
    for (let i = 0; i < selectedRows.length; i++) {
      const btn = $(selectedRows[i]).find('.fetch-btn');
      await fetchCoordinates(btn, true);
      count++;
      const percent = Math.round((count / selectedRows.length) * 100);
      $('#progressBar').css('width', percent + '%').text(`${count}/${selectedRows.length} (${percent}%)`);
    }

    $('#progressBar').text('Completed ✅');
    setTimeout(() => $('#progressContainer').fadeOut(), 2000);
  });
});

// ✅ Fetch Coordinates — refined to mimic human clicks
async function fetchCoordinates(btn, silent = false) {
  const trxnref = btn.data('trxnref');
  const rawAddress = btn.data('address');
  const city = btn.data('city');
  const state = btn.data('state');
  const input = $('#coord_' + trxnref);
  const mapDiv = $('#map_' + trxnref);

  if (!silent) btn.prop('disabled', true).text('Fetching...');

  const cleanedAddress = cleanAddress(rawAddress);
  let query = cleanedAddress ? `${cleanedAddress}, ${city}, ${state}, Nigeria` : `${city}, ${state}, Nigeria`;
  const url = `https://maps.googleapis.com/maps/api/geocode/json?address=${encodeURIComponent(query)}&key=AIzaSyACN8Gf4LwFFXv7HV8fpVAW0osUx3J9Lz8`;

  try {
    const response = await fetch(url);
    const data = await response.json();

    if (data.status === 'OK' && data.results.length > 0) {
      // Prioritize human-like street-level match
      let validResult = data.results.find(r => {
        const t = r.types.join(',');
        return /(route|street_address|premise|subpremise)/i.test(t);
      });

      // If none suitable, fallback to a landmark-level match
      if (!validResult) {
        validResult = data.results.find(r => /(establishment|point_of_interest|premise)/i.test(r.types.join(',')));
      }

      // Still nothing usable? fallback to first but humanize it
      if (!validResult) validResult = data.results[0];

      let loc = validResult.geometry.location;
      const placeType = validResult.types.join(',');

      // Avoid points on expressways / highways / routes
      if (/highway|expressway|route/.test(placeType)) {
        loc.lat += (Math.random() - 0.5) * 0.00035;
        loc.lng += (Math.random() - 0.5) * 0.00035;
      }

      // Final coordinate — realistic click point
      const coord = `${loc.lat.toFixed(6)}, ${loc.lng.toFixed(6)}`;
      input.val(coord);
      showMap(mapDiv, loc.lat, loc.lng);
      btn.text('Fetched ✅').removeClass('btn-outline-primary').addClass('btn-success');
    } else {
      input.val('');
      btn.text('Not Found ❌').removeClass('btn-outline-primary').addClass('btn-danger');
    }
  } catch (err) {
    if (!silent) alert('Error: ' + err.message);
  } finally {
    if (!silent) setTimeout(() => btn.prop('disabled', false).text('Get GPS'), 2000);
  }
}

// 🗺️ Static Map Preview
function showMap(container, lat, lon) {
  const mapUrl = `https://maps.googleapis.com/maps/api/staticmap?center=${lat},${lon}&zoom=17&size=150x120&markers=color:red%7C${lat},${lon}&key=AIzaSyACN8Gf4LwFFXv7HV8fpVAW0osUx3J9Lz8`;
  container.html(`<img src="${mapUrl}" class="map-preview" alt="Map preview">`);
}
let map, marker, activeTrxnRef = null;
let activeAddress = "";

$(document).ready(function() {
  // Append Edit Map button next to each Get GPS
  $('.fetch-btn').each(function() {
    const trxnref = $(this).data('trxnref');
    const address = $(this).data('address');
    $(this).after(`
      <button type="button" 
              class="btn btn-outline-secondary btn-sm ms-1 edit-map-btn" 
              data-trxnref="${trxnref}" 
              data-address="${address}">
        🗺 Edit Map
      </button>
    `);
  });

  // When Edit Map is clicked
  $(document).on('click', '.edit-map-btn', function() {
    activeTrxnRef = $(this).data('trxnref');
    activeAddress = $(this).data('address');
    $('#mapModalLabel').html(`Adjust Location: <small class="text-muted">${activeAddress}</small>`);

    const coordField = $('#coord_' + activeTrxnRef).val();
    let lat = 6.5244, lng = 3.3792; // Default Lagos

    if (coordField && coordField.includes(',')) {
      const parts = coordField.split(',');
      lat = parseFloat(parts[0]);
      lng = parseFloat(parts[1]);
    }

    $('#mapModal').modal('show');
    setTimeout(() => initLiveMap(lat, lng), 500);
  });

  // Apply Location
  $('#applyLocation').click(function() {
    if (activeTrxnRef && marker) {
      const lat = marker.getPosition().lat().toFixed(6);
      const lng = marker.getPosition().lng().toFixed(6);
      const coord = `${lat}, ${lng}`;
      $('#coord_' + activeTrxnRef).val(coord);
      $('#map_' + activeTrxnRef).html(
        `<img src="https://maps.googleapis.com/maps/api/staticmap?center=${lat},${lng}&zoom=17&size=150x120&markers=color:red%7C${lat},${lng}&key=AIzaSyACN8Gf4LwFFXv7HV8fpVAW0osUx3J9Lz8" class="map-preview">`
      );
      $('#mapModal').modal('hide');
    }
  });
});

function initLiveMap(lat, lng) {
  const position = { lat, lng };
  const mapDiv = document.getElementById('liveMap');
  mapDiv.innerHTML = ''; // clear previous

  map = new google.maps.Map(mapDiv, {
    center: position,
    zoom: 17,
    mapTypeId: google.maps.MapTypeId.ROADMAP,
    zoomControl: true,
    mapTypeControl: true,
    mapTypeControlOptions: {
      style: google.maps.MapTypeControlStyle.HORIZONTAL_BAR,
      position: google.maps.ControlPosition.TOP_LEFT,
      mapTypeIds: [
        google.maps.MapTypeId.ROADMAP,
        google.maps.MapTypeId.SATELLITE,
        google.maps.MapTypeId.HYBRID,
        google.maps.MapTypeId.TERRAIN,
      ],
    },
    streetViewControl: true,
    streetViewControlOptions: {
      position: google.maps.ControlPosition.RIGHT_TOP,
    },
    fullscreenControl: true,
    gestureHandling: 'greedy', // allows scroll-wheel + touch zoom
    tilt: 45, // 3D perspective (if supported)
  });

  marker = new google.maps.Marker({
    position,
    map,
    draggable: true,
    animation: google.maps.Animation.DROP,
    title: "Drag to correct location",
  });

  // Reposition marker on map click
  map.addListener('click', e => marker.setPosition(e.latLng));

  // Search Box
  const input = document.createElement('input');
  input.type = 'text';
  input.placeholder = 'Search any place, street or landmark...';
  input.className = 'form-control shadow-sm';
  input.style.cssText = `
    margin:10px;
    width:350px;
    max-width:90%;
    border-radius:8px;
    padding:8px 12px;
  `;
  map.controls[google.maps.ControlPosition.TOP_CENTER].push(input);

  const searchBox = new google.maps.places.SearchBox(input);
  map.addListener('bounds_changed', () => searchBox.setBounds(map.getBounds()));

  searchBox.addListener('places_changed', () => {
    const places = searchBox.getPlaces();
    if (places.length === 0) return;
    const place = places[0];
    if (!place.geometry) return;
    map.panTo(place.geometry.location);
    map.setZoom(17);
    marker.setPosition(place.geometry.location);
  });

  // ✅ Important: fix tile rendering when modal becomes visible
  setTimeout(() => {
    google.maps.event.trigger(map, 'resize');
    map.setCenter(position);
  }, 600);
}
</script>

</body>
</html>