<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>AVR Portal - Address Verification System</title>
    
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <!-- Animate.css -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css">
    
    <!-- Custom CSS -->
    <style>
        :root {
            --primary-color: #2c3e50;
            --secondary-color: #3498db;
            --accent-color: #e74c3c;
            --light-color: #ecf0f1;
            --dark-color: #2c3e50;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            color: #333;
            overflow-x: hidden;
        }
        
        .navbar {
            background-color: var(--primary-color);
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            padding: 15px 0;
            transition: all 0.3s ease;
        }
        
        .navbar-brand {
            font-weight: 700;
            color: white !important;
            font-size: 1.5rem;
        }
        
        .navbar-nav .nav-link {
            color: rgba(255,255,255,0.85) !important;
            font-weight: 500;
            margin: 0 5px;
            transition: color 0.3s;
        }
        
        .navbar-nav .nav-link:hover {
            color: white !important;
        }
        
        .hero-section {
            background: linear-gradient(135deg, var(--primary-color) 0%, var(--secondary-color) 100%);
            color: white;
            padding: 100px 0 80px;
            margin-top: 76px;
        }
        
        .hero-title {
            font-size: 3.5rem;
            font-weight: 700;
            margin-bottom: 20px;
        }
        
        .hero-subtitle {
            font-size: 1.3rem;
            margin-bottom: 30px;
            opacity: 0.9;
        }
        
        .section-title {
            font-weight: 700;
            margin-bottom: 40px;
            position: relative;
            color: var(--primary-color);
        }
        
        .section-title:after {
            content: '';
            position: absolute;
            bottom: -10px;
            left: 0;
            width: 60px;
            height: 4px;
            background-color: var(--secondary-color);
        }
        
        .feature-card {
            border: none;
            border-radius: 10px;
            box-shadow: 0 5px 15px rgba(0,0,0,0.05);
            transition: transform 0.3s, box-shadow 0.3s;
            margin-bottom: 30px;
            height: 100%;
        }
        
        .feature-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 25px rgba(0,0,0,0.1);
        }
        
        .feature-icon {
            font-size: 2.5rem;
            color: var(--secondary-color);
            margin-bottom: 20px;
        }
        
        .security-badge {
            background-color: var(--light-color);
            border-radius: 50px;
            padding: 8px 20px;
            font-size: 0.9rem;
            font-weight: 600;
            color: var(--primary-color);
            display: inline-block;
            margin: 5px;
        }
        
        .carousel-item {
            height: 500px;
            background-size: cover;
            background-position: center;
        }
        
        .carousel-caption {
            background: rgba(0,0,0,0.6);
            border-radius: 10px;
            padding: 20px;
            bottom: 30%;
        }
        
        .footer {
            background-color: var(--primary-color);
            color: white;
            padding: 40px 0 20px;
        }
        
        .cookies-consent {
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            background: rgba(44, 62, 80, 0.95);
            color: white;
            padding: 15px;
            z-index: 9999;
            box-shadow: 0 -2px 10px rgba(0,0,0,0.1);
        }
        
        .btn-primary {
            background-color: var(--secondary-color);
            border-color: var(--secondary-color);
            padding: 10px 25px;
            border-radius: 50px;
            font-weight: 600;
            transition: all 0.3s;
        }
        
        .btn-primary:hover {
            background-color: #2980b9;
            border-color: #2980b9;
            transform: translateY(-2px);
        }
        
        .btn-outline-primary {
            color: var(--secondary-color);
            border-color: var(--secondary-color);
            border-radius: 50px;
            font-weight: 600;
            transition: all 0.3s;
        }
        
        .btn-outline-primary:hover {
            background-color: var(--secondary-color);
            color: white;
            transform: translateY(-2px);
        }
        
        .modal-content {
            border-radius: 10px;
            border: none;
            box-shadow: 0 10px 30px rgba(0,0,0,0.1);
        }
        
        .modal-header {
            background-color: var(--primary-color);
            color: white;
            border-radius: 10px 10px 0 0;
        }
        
        .security-section {
            background-color: #f8f9fa;
            padding: 80px 0;
        }
        
        .animate-on-scroll {
            opacity: 0;
            transform: translateY(30px);
            transition: opacity 0.6s, transform 0.6s;
        }
        
        .animate-on-scroll.animated {
            opacity: 1;
            transform: translateY(0);
        }
        
        @media (max-width: 768px) {
            .hero-title {
                font-size: 2.5rem;
            }
            
            .hero-subtitle {
                font-size: 1.1rem;
            }
            
            .carousel-item {
                height: 300px;
            }
        }
    </style>
</head>
<body>
    <!-- Cookies Consent Dialog -->
    <div id="cookiesConsent" class="cookies-consent animate_animated animate_fadeInUp" style="display: none;">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-md-8">
                    <p class="mb-0">We use cookies to enhance your experience and ensure the security of your data. By continuing to browse, you agree to our <a href="#" class="text-white">Privacy Policy</a> and <a href="#" class="text-white">Cookie Policy</a>.</p>
                </div>
                <div class="col-md-4 text-end">
                    <button id="acceptCookies" class="btn btn-primary btn-sm">Accept All</button>
                    <button id="rejectCookies" class="btn btn-outline-light btn-sm ms-2">Reject Non-Essential</button>
                </div>
            </div>
        </div>
    </div>

    <!-- Navigation -->
    <nav class="navbar navbar-expand-lg navbar-dark fixed-top">
        <div class="container">
            <a class="navbar-brand" href="#">
                <i class="fas fa-map-marked-alt me-2"></i>AVR Portal
            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto">
                    <li class="nav-item">
                        <a class="nav-link" href="mailto:avr@sylvianettebox.net">
                            <i class="fas fa-envelope me-1"></i>avr@sylvianettebox.net
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="tel:+2347038745727">
                            <i class="fas fa-phone me-1"></i>+234 703 874 5727
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#" data-bs-toggle="modal" data-bs-target="#contactModal">
                            <i class="fas fa-comment me-1"></i>Message
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#" data-bs-toggle="modal" data-bs-target="#loginModal">
                            <i class="fas fa-user me-1"></i>Login
                        </a>
                    </li>
                </ul>
            </div>
        </div>
    </nav>

    <!-- Hero Section -->
    <section class="hero-section">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-6">
                    <h1 class="hero-title animate_animated animate_fadeInDown">Address Verification Portal</h1>
                    <p class="hero-subtitle animate_animated animate_fadeInUp">Streamlined address verification with GPS integration, real-time tracking, and secure data management.</p>
                    <div class="animate_animated animate_fadeInUp">
                        <a href="#" class="btn btn-light btn-lg me-3" data-bs-toggle="modal" data-bs-target="#contactModal">Get Started</a>
                        <a href="#features" class="btn btn-outline-light btn-lg">Learn More</a>
                    </div>
                </div>
                <div class="col-lg-6 text-center">
                    <img src="https://via.placeholder.com/500x400/2c3e50/ffffff?text=AVR+System" alt="AVR System" class="img-fluid rounded animate_animated animate_zoomIn">
                </div>
            </div>
        </div>
    </section>

    <!-- Security Section -->
    <section class="security-section">
        <div class="container">
            <div class="row">
                <div class="col-12 text-center mb-5">
                    <h2 class="section-title">Enterprise-Grade Security</h2>
                    <p class="lead">Your data security is our top priority with end-to-end encryption and compliance standards.</p>
                </div>
            </div>
            <div class="row justify-content-center">
                <div class="col-md-8">
                    <div class="row">
                        <div class="col-md-6 mb-4">
                            <div class="d-flex align-items-center">
                                <i class="fas fa-shield-alt fa-2x text-primary me-3"></i>
                                <div>
                                    <h5>End-to-End Encryption</h5>
                                    <p class="mb-0">All data transfers are encrypted using industry-standard protocols.</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6 mb-4">
                            <div class="d-flex align-items-center">
                                <i class="fas fa-user-lock fa-2x text-primary me-3"></i>
                                <div>
                                    <h5>Role-Based Access Control</h5>
                                    <p class="mb-0">Granular permissions ensure users only access what they need.</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6 mb-4">
                            <div class="d-flex align-items-center">
                                <i class="fas fa-database fa-2x text-primary me-3"></i>
                                <div>
                                    <h5>Secure Data Storage</h5>
                                    <p class="mb-0">Data is stored in secure, redundant environments with regular backups.</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6 mb-4">
                            <div class="d-flex align-items-center">
                                <i class="fas fa-clipboard-check fa-2x text-primary me-3"></i>
                                <div>
                                    <h5>GDPR & Compliance</h5>
                                    <p class="mb-0">Our system adheres to global data protection regulations.</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row mt-4">
                <div class="col-12 text-center">
                    <span class="security-badge"><i class="fas fa-lock me-1"></i>SSL Secured</span>
                    <span class="security-badge"><i class="fas fa-check-circle me-1"></i>GDPR Compliant</span>
                    <span class="security-badge"><i class="fas fa-shield-virus me-1"></i>Malware Protected</span>
                    <span class="security-badge"><i class="fas fa-server me-1"></i>Secure Hosting</span>
                </div>
            </div>
        </div>
    </section>

    <!-- Features Section -->
    <section id="features" class="py-5">
        <div class="container">
            <div class="row">
                <div class="col-12 text-center mb-5">
                    <h2 class="section-title">Our Platform Features</h2>
                    <p class="lead">Comprehensive tools for efficient address verification management</p>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-3 col-md-6">
                    <div class="card feature-card h-100 animate-on-scroll">
                        <div class="card-body text-center p-4">
                            <div class="feature-icon">
                                <i class="fas fa-building"></i>
                            </div>
                            <h4 class="card-title">Vendor Module</h4>
                            <p class="card-text">Complete operational control with job management, field officer registration, and financial tracking.</p>
                            <ul class="list-unstyled text-start mt-3">
                                <li><i class="fas fa-check text-success me-2"></i>Register Field Officers</li>
                                <li><i class="fas fa-check text-success me-2"></i>Upload Job Requests</li>
                                <li><i class="fas fa-check text-success me-2"></i>Assign Jobs to Teams</li>
                                <li><i class="fas fa-check text-success me-2"></i>Financial Management</li>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6">
                    <div class="card feature-card h-100 animate-on-scroll">
                        <div class="card-body text-center p-4">
                            <div class="feature-icon">
                                <i class="fas fa-user-tie"></i>
                            </div>
                            <h4 class="card-title">Supervisors</h4>
                            <p class="card-text">Manage clustered field officers with job assignment, progress tracking, and report vetting.</p>
                            <ul class="list-unstyled text-start mt-3">
                                <li><i class="fas fa-check text-success me-2"></i>Acknowledge Assigned Jobs</li>
                                <li><i class="fas fa-check text-success me-2"></i>Assign to Field Officers</li>
                                <li><i class="fas fa-check text-success me-2"></i>Vet and Approve Reports</li>
                                <li><i class="fas fa-check text-success me-2"></i>Team Performance Metrics</li>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6">
                    <div class="card feature-card h-100 animate-on-scroll">
                        <div class="card-body text-center p-4">
                            <div class="feature-icon">
                                <i class="fas fa-user-check"></i>
                            </div>
                            <h4 class="card-title">Field Officers</h4>
                            <p class="card-text">Direct field operations with GPS integration, job reporting, and real-time updates.</p>
                            <ul class="list-unstyled text-start mt-3">
                                <li><i class="fas fa-check text-success me-2"></i>Street Search & Navigation</li>
                                <li><i class="fas fa-check text-success me-2"></i>Job Reporting</li>
                                <li><i class="fas fa-check text-success me-2"></i>GPS Coordinate Capture</li>
                                <li><i class="fas fa-check text-success me-2"></i>Filter & Manage Tasks</li>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6">
                    <div class="card feature-card h-100 animate-on-scroll">
                        <div class="card-body text-center p-4">
                            <div class="feature-icon">
                                <i class="fas fa-users"></i>
                            </div>
                            <h4 class="card-title">Clients</h4>
                            <p class="card-text">Monitor verification progress, approve reports, and track TAT with comprehensive dashboards.</p>
                            <ul class="list-unstyled text-start mt-3">
                                <li><i class="fas fa-check text-success me-2"></i>Approve/Reject Reports</li>
                                <li><i class="fas fa-check text-success me-2"></i>Track GPS Coordinates</li>
                                <li><i class="fas fa-check text-success me-2"></i>Upload Job Batches</li>
                                <li><i class="fas fa-check text-success me-2"></i>Monitor TAT & Performance</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Carousel Section -->
    <section class="py-5 bg-light">
        <div class="container">
            <div class="row">
                <div class="col-12 text-center mb-5">
                    <h2 class="section-title">AVR System in Action</h2>
                </div>
            </div>
            <div class="row">
                <div class="col-12">
                    <div id="avrCarousel" class="carousel slide" data-bs-ride="carousel">
                        <div class="carousel-indicators">
                            <button type="button" data-bs-target="#avrCarousel" data-bs-slide-to="0" class="active"></button>
                            <button type="button" data-bs-target="#avrCarousel" data-bs-slide-to="1"></button>
                            <button type="button" data-bs-target="#avrCarousel" data-bs-slide-to="2"></button>
                            <button type="button" data-bs-target="#avrCarousel" data-bs-slide-to="3"></button>
                        </div>
                        <div class="carousel-inner rounded">
                            <div class="carousel-item active" style="background-image: url('https://via.placeholder.com/1200x500/3498db/ffffff?text=Address+Verification+Made+Seamless')">
                                <div class="carousel-caption">
                                    <h3>Address Verification</h3>
                                    <p>Cover Large Volume Within TAT</p>
                                </div>
                            </div>
                            <div class="carousel-item" style="background-image: url('https://via.placeholder.com/1200x500/2c3e50/ffffff?text=GPS+Integration+For+Precision')">
                                <div class="carousel-caption">
                                    <h3>GPS Integration</h3>
                                    <p>Control With GPS Coordinates</p>
                                </div>
                            </div>
                            <div class="carousel-item" style="background-image: url('https://via.placeholder.com/1200x500/e74c3c/ffffff?text=Bulk+Data+Processing')">
                                <div class="carousel-caption">
                                    <h3>Bulk Data Processing</h3>
                                    <p>Handle Large Volumes Efficiently</p>
                                </div>
                            </div>
                            <div class="carousel-item" style="background-image: url('https://via.placeholder.com/1200x500/27ae60/ffffff?text=Real-Time+Tracking+And+Reporting')">
                                <div class="carousel-caption">
                                    <h3>Real-Time Tracking</h3>
                                    <p>Monitor Progress Instantly</p>
                                </div>
                            </div>
                        </div>
                        <button class="carousel-control-prev" type="button" data-bs-target="#avrCarousel" data-bs-slide="prev">
                            <span class="carousel-control-prev-icon"></span>
                        </button>
                        <button class="carousel-control-next" type="button" data-bs-target="#avrCarousel" data-bs-slide="next">
                            <span class="carousel-control-next-icon"></span>
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- CTA Section -->
    <section class="py-5" style="background: linear-gradient(135deg, var(--primary-color) 0%, var(--secondary-color) 100%); color: white;">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-8">
                    <h3>Ready to streamline your address verification process?</h3>
                    <p class="mb-0">Contact us today to schedule a demo or get started with our secure AVR platform.</p>
                </div>
                <div class="col-lg-4 text-lg-end mt-3 mt-lg-0">
                    <a href="#" class="btn btn-light btn-lg" data-bs-toggle="modal" data-bs-target="#contactModal">Contact Us Now</a>
                </div>
            </div>
        </div>
    </section>

    <!-- Footer -->
    <footer class="footer">
        <div class="container">
            <div class="row">
                <div class="col-lg-4 mb-4 mb-lg-0">
                    <h5><i class="fas fa-map-marked-alt me-2"></i>AVR Portal</h5>
                    <p>Advanced Address Verification System with GPS integration and real-time tracking for efficient field operations.</p>
                </div>
                <div class="col-lg-4 mb-4 mb-lg-0">
                    <h5>Contact Information</h5>
                    <ul class="list-unstyled">
                        <li><i class="fas fa-envelope me-2"></i>avr@sylvianettebox.net</li>
                        <li><i class="fas fa-phone me-2"></i>+234 703 874 5727</li>
                        <li><i class="fas fa-map-marker-alt me-2"></i>Lagos, Nigeria</li>
                    </ul>
                </div>
                <div class="col-lg-4">
                    <h5>Quick Links</h5>
                    <ul class="list-unstyled">
                        <li><a href="#" data-bs-toggle="modal" data-bs-target="#loginModal"><i class="fas fa-sign-in-alt me-1"></i> Login</a></li>
                        <li><a href="#" data-bs-toggle="modal" data-bs-target="#contactModal"><i class="fas fa-comment me-1"></i> Contact Us</a></li>
                        <li><a href="#"><i class="fas fa-shield-alt me-1"></i> Security</a></li>
                        <li><a href="#"><i class="fas fa-question-circle me-1"></i> Support</a></li>
                    </ul>
                </div>
            </div>
            <hr class="mt-4 mb-4" style="border-color: rgba(255,255,255,0.1);">
            <div class="row">
                <div class="col-md-6">
                    <p class="mb-0">&copy; 2025 AVR Portal. All rights reserved.</p>
                </div>
                <div class="col-md-6 text-md-end">
                    <p class="mb-0">A product of <a href="http://www.sylvianettebox.com" class="text-white">Sylvianette Box LLC</a></p>
                </div>
            </div>
        </div>
    </footer>

    <!-- Login Modal -->
    <div class="modal fade" id="loginModal" tabindex="-1">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><i class="fas fa-sign-in-alt me-2"></i>Login to AVR Portal</h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="text-center mb-4">
                        <img src="https://via.placeholder.com/80/2c3e50/ffffff?text=SB" alt="Logo" class="rounded-circle">
                    </div>
                    <form action="/cav/index" method="post" id="login-form">
                        <div class="mb-3">
                            <label for="loginEmail" class="form-label">User ID or Email</label>
                            <input type="text" class="form-control" id="loginEmail" name="txt_uname_email" placeholder="UserID/eMail" required>
                        </div>
                        <div class="mb-3">
                            <label for="loginPassword" class="form-label">Password</label>
                            <input type="password" class="form-control" id="loginPassword" name="txt_password" placeholder="Your Password" required>
                        </div>
                        <div class="d-grid gap-2">
                            <button type="submit" name="btn-login" class="btn btn-primary">
                                <i class="fas fa-sign-in-alt me-1"></i> Sign In
                            </button>
                        </div>
                    </form>
                    <div class="text-center mt-3">
                        <a href="#" data-bs-toggle="modal" data-bs-target="#passwordModal" data-bs-dismiss="modal">Forgot your password?</a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Password Recovery Modal -->
    <div class="modal fade" id="passwordModal" tabindex="-1">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><i class="fas fa-key me-2"></i>Password Recovery</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="text-center mb-4">
                        <img src="https://via.placeholder.com/80/2c3e50/ffffff?text=SB" alt="Logo" class="rounded-circle">
                    </div>
                    <form action="/cav/recover-password" method="post" id="password-recovery-form">
                        <div class="mb-3">
                            <label for="recoveryEmail" class="form-label">Email Address</label>
                            <input type="email" class="form-control" id="recoveryEmail" name="txt_uname_email" placeholder="Email Address..." required>
                        </div>
                        <div class="d-grid gap-2">
                            <button type="submit" name="btn-login" class="btn btn-primary">
                                <i class="fas fa-redo me-1"></i> Reset Password
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Contact Modal -->
    <div class="modal fade" id="contactModal" tabindex="-1">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><i class="fas fa-envelope me-2"></i>Contact Us</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <form method="post" id="contact-form">
                        <div class="mb-3">
                            <label for="contactName" class="form-label">Your Name</label>
                            <input type="text" class="form-control" id="contactName" name="name" placeholder="Your Name" required>
                        </div>
                        <div class="mb-3">
                            <label for="contactEmail" class="form-label">Email Address</label>
                            <input type="email" class="form-control" id="contactEmail" name="email" placeholder="Email Address" required>
                        </div>
                        <div class="mb-3">
                            <label for="contactTel" class="form-label">Phone Number</label>
                            <input type="tel" class="form-control" id="contactTel" name="tel" placeholder="Phone Number" required>
                        </div>
                        <div class="mb-3">
                            <label for="contactMsg" class="form-label">Message</label>
                            <textarea class="form-control" id="contactMsg" name="msg" rows="5" placeholder="Message" required></textarea>
                        </div>
                        <div class="d-grid gap-2">
                            <button type="submit" name="send-message" class="btn btn-primary" onclick="return confirm('Proceed?')">
                                <i class="fas fa-paper-plane me-1"></i> Send Message
                            </button>
                        </div>
                    </form>
                    <div class="mt-3">
                        <p class="small mb-0"><i class="fas fa-info-circle me-1"></i> You can also reach us at info@sylvianettebox.com or +234 803 333 3628</p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Bootstrap JS and dependencies -->
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.6/dist/umd/popper.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.min.js"></script>
    
    <!-- Custom JS -->
    <script>
        // Cookies Consent
        document.addEventListener('DOMContentLoaded', function() {
            if (!localStorage.getItem('cookiesAccepted')) {
                setTimeout(function() {
                    document.getElementById('cookiesConsent').style.display = 'block';
                }, 1000);
            }
            
            document.getElementById('acceptCookies').addEventListener('click', function() {
                localStorage.setItem('cookiesAccepted', 'true');
                document.getElementById('cookiesConsent').style.display = 'none';
            });
            
            document.getElementById('rejectCookies').addEventListener('click', function() {
                localStorage.setItem('cookiesAccepted', 'false');
                document.getElementById('cookiesConsent').style.display = 'none';
            });
            
            // Animate on scroll
            const animateElements = document.querySelectorAll('.animate-on-scroll');
            
            const observer = new IntersectionObserver((entries) => {
                entries.forEach(entry => {
                    if (entry.isIntersecting) {
                        entry.target.classList.add('animated');
                    }
                });
            }, { threshold: 0.1 });
            
            animateElements.forEach(el => observer.observe(el));
            
            // Smooth scrolling for anchor links
            document.querySelectorAll('a[href^="#"]').forEach(anchor => {
                anchor.addEventListener('click', function(e) {
                    e.preventDefault();
                    
                    const targetId = this.getAttribute('href');
                    if (targetId === '#') return;
                    
                    const targetElement = document.querySelector(targetId);
                    if (targetElement) {
                        window.scrollTo({
                            top: targetElement.offsetTop - 80,
                            behavior: 'smooth'
                        });
                    }
                });
            });
            
            // Navbar background on scroll
            window.addEventListener('scroll', function() {
                if (window.scrollY > 50) {
                    document.querySelector('.navbar').style.backgroundColor = 'rgba(44, 62, 80, 0.95)';
                    document.querySelector('.navbar').style.padding = '10px 0';
                } else {
                    document.querySelector('.navbar').style.backgroundColor = '';
                    document.querySelector('.navbar').style.padding = '15px 0';
                }
            });
        });
    </script>
</body>
</html>